/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.maf.MAFReader;
import org.broad.igv.maf.MAFTile;
import org.broad.igv.maf.MAFTileCodec;
import org.broad.igv.util.IGVHttpClientUtils;
import org.broad.igv.util.ResourceLocator;

public class MAFRemoteReader
implements MAFReader {
    static Logger log = Logger.getLogger(MAFRemoteReader.class);
    String serverURL = "http://www.broadinstitute.org/webservices/igv";
    static MAFTileCodec codec = new MAFTileCodec();

    public MAFRemoteReader(ResourceLocator locator) {
    }

    @Override
    public MAFTile loadTile(String chr, int start, int end, List<String> species) {
        InputStream is = null;
        try {
            MAFTile tile;
            URL url = new URL(this.serverURL + "?method=maf&chr=" + chr + "&start=" + start + "&end=" + end);
            is = IGVHttpClientUtils.openConnectionStream(url);
            DataInputStream dis = new DataInputStream(new GZIPInputStream(new BufferedInputStream(is)));
            MAFTile mAFTile = tile = codec.decode(dis);
            return mAFTile;
        }
        catch (IOException ex) {
            log.error("Error opening file", ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    log.error("Error closing URL stream", iOException);
                }
            }
        }
    }
}

