/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public abstract class GenomeDescriptor {
    private String name;
    private int version;
    private boolean chrNamesAltered;
    private String id;
    protected String cytoBandFileName;
    protected String geneFileName;
    protected String chrAliasFileName;
    private String geneTrackName;
    private String url;
    private String sequenceLocation;
    private boolean chromosomesAreOrdered = false;

    public GenomeDescriptor(String name, int version, boolean chrNamesAltered, String id, String cytoBandFileName, String geneFileName, String chrAliasFileName, String geneTrackName, String sequenceLocation, boolean chromosomesAreOrdered) {
        String tryThis;
        this.version = version;
        this.chrNamesAltered = chrNamesAltered;
        this.name = name;
        this.id = id;
        this.cytoBandFileName = cytoBandFileName;
        this.geneFileName = geneFileName;
        this.chrAliasFileName = chrAliasFileName;
        this.geneTrackName = geneTrackName;
        this.sequenceLocation = sequenceLocation;
        this.chromosomesAreOrdered = chromosomesAreOrdered;
        if (sequenceLocation.startsWith("/") && !new File(sequenceLocation).exists() && new File(tryThis = sequenceLocation.replaceFirst("/", "")).exists()) {
            this.sequenceLocation = tryThis;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getGeneFileName() {
        return this.geneFileName;
    }

    public String getGeneTrackName() {
        return this.geneTrackName;
    }

    public abstract InputStream getCytoBandStream() throws IOException;

    public boolean isCytoBandFileGZipFormat() {
        return this.isFileGZipFormat(this.cytoBandFileName);
    }

    public abstract InputStream getGeneStream() throws IOException;

    public abstract InputStream getChrAliasStream() throws IOException;

    public boolean isGeneFileGZipFormat() {
        String fileName = this.getGeneFileName();
        return this.isFileGZipFormat(fileName);
    }

    public void setSequenceLocation(String sequenceLocation) {
        this.sequenceLocation = sequenceLocation;
    }

    public String getSequenceLocation() {
        return this.sequenceLocation;
    }

    public abstract boolean isUserDefined();

    public String toString() {
        return this.name;
    }

    private boolean isFileGZipFormat(String fileName) {
        if (fileName == null) {
            return false;
        }
        return fileName.toLowerCase().endsWith(".gz");
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isChromosomesAreOrdered() {
        return this.chromosomesAreOrdered;
    }

    public boolean isChrNamesAltered() {
        return this.chrNamesAltered;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

