/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.FDistribution;
import org.apache.commons.math.special.Beta;

public class FDistributionImpl
extends AbstractContinuousDistribution
implements FDistribution,
Serializable {
    private static final long serialVersionUID = -8516354193418641566L;
    private double numeratorDegreesOfFreedom;
    private double denominatorDegreesOfFreedom;

    public FDistributionImpl(double numeratorDegreesOfFreedom, double denominatorDegreesOfFreedom) {
        this.setNumeratorDegreesOfFreedom(numeratorDegreesOfFreedom);
        this.setDenominatorDegreesOfFreedom(denominatorDegreesOfFreedom);
    }

    public double cumulativeProbability(double x) throws MathException {
        double ret;
        if (x <= 0.0) {
            ret = 0.0;
        } else {
            double n2 = this.getNumeratorDegreesOfFreedom();
            double m2 = this.getDenominatorDegreesOfFreedom();
            ret = Beta.regularizedBeta(n2 * x / (m2 + n2 * x), 0.5 * n2, 0.5 * m2);
        }
        return ret;
    }

    public double inverseCumulativeProbability(double p2) throws MathException {
        if (p2 == 0.0) {
            return 0.0;
        }
        if (p2 == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(p2);
    }

    protected double getDomainLowerBound(double p2) {
        return 0.0;
    }

    protected double getDomainUpperBound(double p2) {
        return Double.MAX_VALUE;
    }

    protected double getInitialDomain(double p2) {
        return this.getDenominatorDegreesOfFreedom() / (this.getDenominatorDegreesOfFreedom() - 2.0);
    }

    public void setNumeratorDegreesOfFreedom(double degreesOfFreedom) {
        if (degreesOfFreedom <= 0.0) {
            throw new IllegalArgumentException("degrees of freedom must be positive.");
        }
        this.numeratorDegreesOfFreedom = degreesOfFreedom;
    }

    public double getNumeratorDegreesOfFreedom() {
        return this.numeratorDegreesOfFreedom;
    }

    public void setDenominatorDegreesOfFreedom(double degreesOfFreedom) {
        if (degreesOfFreedom <= 0.0) {
            throw new IllegalArgumentException("degrees of freedom must be positive.");
        }
        this.denominatorDegreesOfFreedom = degreesOfFreedom;
    }

    public double getDenominatorDegreesOfFreedom() {
        return this.denominatorDegreesOfFreedom;
    }
}

