/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.IntHashMap;
import org.apache.commons.lang.UnhandledException;

class Entities {
    private static final String[][] BASIC_ARRAY = new String[][]{{"quot", "34"}, {"amp", "38"}, {"lt", "60"}, {"gt", "62"}};
    private static final String[][] APOS_ARRAY = new String[][]{{"apos", "39"}};
    static final String[][] ISO8859_1_ARRAY = new String[][]{{"nbsp", "160"}, {"iexcl", "161"}, {"cent", "162"}, {"pound", "163"}, {"curren", "164"}, {"yen", "165"}, {"brvbar", "166"}, {"sect", "167"}, {"uml", "168"}, {"copy", "169"}, {"ordf", "170"}, {"laquo", "171"}, {"not", "172"}, {"shy", "173"}, {"reg", "174"}, {"macr", "175"}, {"deg", "176"}, {"plusmn", "177"}, {"sup2", "178"}, {"sup3", "179"}, {"acute", "180"}, {"micro", "181"}, {"para", "182"}, {"middot", "183"}, {"cedil", "184"}, {"sup1", "185"}, {"ordm", "186"}, {"raquo", "187"}, {"frac14", "188"}, {"frac12", "189"}, {"frac34", "190"}, {"iquest", "191"}, {"Agrave", "192"}, {"Aacute", "193"}, {"Acirc", "194"}, {"Atilde", "195"}, {"Auml", "196"}, {"Aring", "197"}, {"AElig", "198"}, {"Ccedil", "199"}, {"Egrave", "200"}, {"Eacute", "201"}, {"Ecirc", "202"}, {"Euml", "203"}, {"Igrave", "204"}, {"Iacute", "205"}, {"Icirc", "206"}, {"Iuml", "207"}, {"ETH", "208"}, {"Ntilde", "209"}, {"Ograve", "210"}, {"Oacute", "211"}, {"Ocirc", "212"}, {"Otilde", "213"}, {"Ouml", "214"}, {"times", "215"}, {"Oslash", "216"}, {"Ugrave", "217"}, {"Uacute", "218"}, {"Ucirc", "219"}, {"Uuml", "220"}, {"Yacute", "221"}, {"THORN", "222"}, {"szlig", "223"}, {"agrave", "224"}, {"aacute", "225"}, {"acirc", "226"}, {"atilde", "227"}, {"auml", "228"}, {"aring", "229"}, {"aelig", "230"}, {"ccedil", "231"}, {"egrave", "232"}, {"eacute", "233"}, {"ecirc", "234"}, {"euml", "235"}, {"igrave", "236"}, {"iacute", "237"}, {"icirc", "238"}, {"iuml", "239"}, {"eth", "240"}, {"ntilde", "241"}, {"ograve", "242"}, {"oacute", "243"}, {"ocirc", "244"}, {"otilde", "245"}, {"ouml", "246"}, {"divide", "247"}, {"oslash", "248"}, {"ugrave", "249"}, {"uacute", "250"}, {"ucirc", "251"}, {"uuml", "252"}, {"yacute", "253"}, {"thorn", "254"}, {"yuml", "255"}};
    static final String[][] HTML40_ARRAY = new String[][]{{"fnof", "402"}, {"Alpha", "913"}, {"Beta", "914"}, {"Gamma", "915"}, {"Delta", "916"}, {"Epsilon", "917"}, {"Zeta", "918"}, {"Eta", "919"}, {"Theta", "920"}, {"Iota", "921"}, {"Kappa", "922"}, {"Lambda", "923"}, {"Mu", "924"}, {"Nu", "925"}, {"Xi", "926"}, {"Omicron", "927"}, {"Pi", "928"}, {"Rho", "929"}, {"Sigma", "931"}, {"Tau", "932"}, {"Upsilon", "933"}, {"Phi", "934"}, {"Chi", "935"}, {"Psi", "936"}, {"Omega", "937"}, {"alpha", "945"}, {"beta", "946"}, {"gamma", "947"}, {"delta", "948"}, {"epsilon", "949"}, {"zeta", "950"}, {"eta", "951"}, {"theta", "952"}, {"iota", "953"}, {"kappa", "954"}, {"lambda", "955"}, {"mu", "956"}, {"nu", "957"}, {"xi", "958"}, {"omicron", "959"}, {"pi", "960"}, {"rho", "961"}, {"sigmaf", "962"}, {"sigma", "963"}, {"tau", "964"}, {"upsilon", "965"}, {"phi", "966"}, {"chi", "967"}, {"psi", "968"}, {"omega", "969"}, {"thetasym", "977"}, {"upsih", "978"}, {"piv", "982"}, {"bull", "8226"}, {"hellip", "8230"}, {"prime", "8242"}, {"Prime", "8243"}, {"oline", "8254"}, {"frasl", "8260"}, {"weierp", "8472"}, {"image", "8465"}, {"real", "8476"}, {"trade", "8482"}, {"alefsym", "8501"}, {"larr", "8592"}, {"uarr", "8593"}, {"rarr", "8594"}, {"darr", "8595"}, {"harr", "8596"}, {"crarr", "8629"}, {"lArr", "8656"}, {"uArr", "8657"}, {"rArr", "8658"}, {"dArr", "8659"}, {"hArr", "8660"}, {"forall", "8704"}, {"part", "8706"}, {"exist", "8707"}, {"empty", "8709"}, {"nabla", "8711"}, {"isin", "8712"}, {"notin", "8713"}, {"ni", "8715"}, {"prod", "8719"}, {"sum", "8721"}, {"minus", "8722"}, {"lowast", "8727"}, {"radic", "8730"}, {"prop", "8733"}, {"infin", "8734"}, {"ang", "8736"}, {"and", "8743"}, {"or", "8744"}, {"cap", "8745"}, {"cup", "8746"}, {"int", "8747"}, {"there4", "8756"}, {"sim", "8764"}, {"cong", "8773"}, {"asymp", "8776"}, {"ne", "8800"}, {"equiv", "8801"}, {"le", "8804"}, {"ge", "8805"}, {"sub", "8834"}, {"sup", "8835"}, {"sube", "8838"}, {"supe", "8839"}, {"oplus", "8853"}, {"otimes", "8855"}, {"perp", "8869"}, {"sdot", "8901"}, {"lceil", "8968"}, {"rceil", "8969"}, {"lfloor", "8970"}, {"rfloor", "8971"}, {"lang", "9001"}, {"rang", "9002"}, {"loz", "9674"}, {"spades", "9824"}, {"clubs", "9827"}, {"hearts", "9829"}, {"diams", "9830"}, {"OElig", "338"}, {"oelig", "339"}, {"Scaron", "352"}, {"scaron", "353"}, {"Yuml", "376"}, {"circ", "710"}, {"tilde", "732"}, {"ensp", "8194"}, {"emsp", "8195"}, {"thinsp", "8201"}, {"zwnj", "8204"}, {"zwj", "8205"}, {"lrm", "8206"}, {"rlm", "8207"}, {"ndash", "8211"}, {"mdash", "8212"}, {"lsquo", "8216"}, {"rsquo", "8217"}, {"sbquo", "8218"}, {"ldquo", "8220"}, {"rdquo", "8221"}, {"bdquo", "8222"}, {"dagger", "8224"}, {"Dagger", "8225"}, {"permil", "8240"}, {"lsaquo", "8249"}, {"rsaquo", "8250"}, {"euro", "8364"}};
    public static final Entities XML;
    public static final Entities HTML32;
    public static final Entities HTML40;
    private final EntityMap map;

    static void fillWithHtml40Entities(Entities entities) {
        entities.addEntities(BASIC_ARRAY);
        entities.addEntities(ISO8859_1_ARRAY);
        entities.addEntities(HTML40_ARRAY);
    }

    public Entities() {
        this.map = new LookupEntityMap();
    }

    Entities(EntityMap emap) {
        this.map = emap;
    }

    public void addEntities(String[][] entityArray) {
        for (int i2 = 0; i2 < entityArray.length; ++i2) {
            this.addEntity(entityArray[i2][0], Integer.parseInt(entityArray[i2][1]));
        }
    }

    public void addEntity(String name, int value) {
        this.map.add(name, value);
    }

    public String entityName(int value) {
        return this.map.name(value);
    }

    public int entityValue(String name) {
        return this.map.value(name);
    }

    public String escape(String str) {
        StringWriter stringWriter = this.createStringWriter(str);
        try {
            this.escape(stringWriter, str);
        }
        catch (IOException e2) {
            throw new UnhandledException(e2);
        }
        return stringWriter.toString();
    }

    public void escape(Writer writer, String str) throws IOException {
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = str.charAt(i2);
            String entityName = this.entityName(c2);
            if (entityName == null) {
                if (c2 > '\u007f') {
                    writer.write("&#");
                    writer.write(Integer.toString(c2, 10));
                    writer.write(59);
                    continue;
                }
                writer.write(c2);
                continue;
            }
            writer.write(38);
            writer.write(entityName);
            writer.write(59);
        }
    }

    public String unescape(String str) {
        int firstAmp = str.indexOf(38);
        if (firstAmp < 0) {
            return str;
        }
        StringWriter stringWriter = this.createStringWriter(str);
        try {
            this.doUnescape(stringWriter, str, firstAmp);
        }
        catch (IOException e2) {
            throw new UnhandledException(e2);
        }
        return stringWriter.toString();
    }

    private StringWriter createStringWriter(String str) {
        return new StringWriter((int)((double)str.length() + (double)str.length() * 0.1));
    }

    public void unescape(Writer writer, String str) throws IOException {
        int firstAmp = str.indexOf(38);
        if (firstAmp < 0) {
            writer.write(str);
            return;
        }
        this.doUnescape(writer, str, firstAmp);
    }

    private void doUnescape(Writer writer, String str, int firstAmp) throws IOException {
        writer.write(str, 0, firstAmp);
        int len = str.length();
        for (int i2 = firstAmp; i2 < len; ++i2) {
            char c2 = str.charAt(i2);
            if (c2 == '&') {
                int nextIdx = i2 + 1;
                int semiColonIdx = str.indexOf(59, nextIdx);
                if (semiColonIdx == -1) {
                    writer.write(c2);
                    continue;
                }
                int amphersandIdx = str.indexOf(38, i2 + 1);
                if (amphersandIdx != -1 && amphersandIdx < semiColonIdx) {
                    writer.write(c2);
                    continue;
                }
                String entityContent = str.substring(nextIdx, semiColonIdx);
                int entityValue = -1;
                int entityContentLen = entityContent.length();
                if (entityContentLen > 0) {
                    if (entityContent.charAt(0) == '#') {
                        if (entityContentLen > 1) {
                            char isHexChar = entityContent.charAt(1);
                            try {
                                switch (isHexChar) {
                                    case 'X': 
                                    case 'x': {
                                        entityValue = Integer.parseInt(entityContent.substring(2), 16);
                                        break;
                                    }
                                    default: {
                                        entityValue = Integer.parseInt(entityContent.substring(1), 10);
                                    }
                                }
                                if (entityValue > 65535) {
                                    entityValue = -1;
                                }
                            }
                            catch (NumberFormatException e2) {
                                entityValue = -1;
                            }
                        }
                    } else {
                        entityValue = this.entityValue(entityContent);
                    }
                }
                if (entityValue == -1) {
                    writer.write(38);
                    writer.write(entityContent);
                    writer.write(59);
                } else {
                    writer.write(entityValue);
                }
                i2 = semiColonIdx;
                continue;
            }
            writer.write(c2);
        }
    }

    static {
        Entities xml = new Entities();
        xml.addEntities(BASIC_ARRAY);
        xml.addEntities(APOS_ARRAY);
        XML = xml;
        Entities html32 = new Entities();
        html32.addEntities(BASIC_ARRAY);
        html32.addEntities(ISO8859_1_ARRAY);
        HTML32 = html32;
        Entities html40 = new Entities();
        Entities.fillWithHtml40Entities(html40);
        HTML40 = html40;
    }

    static class BinaryEntityMap
    extends ArrayEntityMap {
        public BinaryEntityMap() {
        }

        public BinaryEntityMap(int growBy) {
            super(growBy);
        }

        private int binarySearch(int key) {
            int low = 0;
            int high = this.size - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int midVal = this.values[mid];
                if (midVal < key) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > key) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        public void add(String name, int value) {
            this.ensureCapacity(this.size + 1);
            int insertAt = this.binarySearch(value);
            if (insertAt > 0) {
                return;
            }
            insertAt = -(insertAt + 1);
            System.arraycopy(this.values, insertAt, this.values, insertAt + 1, this.size - insertAt);
            this.values[insertAt] = value;
            System.arraycopy(this.names, insertAt, this.names, insertAt + 1, this.size - insertAt);
            this.names[insertAt] = name;
            ++this.size;
        }

        public String name(int value) {
            int index = this.binarySearch(value);
            if (index < 0) {
                return null;
            }
            return this.names[index];
        }
    }

    static class ArrayEntityMap
    implements EntityMap {
        protected final int growBy;
        protected int size = 0;
        protected String[] names;
        protected int[] values;

        public ArrayEntityMap() {
            this.growBy = 100;
            this.names = new String[this.growBy];
            this.values = new int[this.growBy];
        }

        public ArrayEntityMap(int growBy) {
            this.growBy = growBy;
            this.names = new String[growBy];
            this.values = new int[growBy];
        }

        public void add(String name, int value) {
            this.ensureCapacity(this.size + 1);
            this.names[this.size] = name;
            this.values[this.size] = value;
            ++this.size;
        }

        protected void ensureCapacity(int capacity) {
            if (capacity > this.names.length) {
                int newSize = Math.max(capacity, this.size + this.growBy);
                String[] newNames = new String[newSize];
                System.arraycopy(this.names, 0, newNames, 0, this.size);
                this.names = newNames;
                int[] newValues = new int[newSize];
                System.arraycopy(this.values, 0, newValues, 0, this.size);
                this.values = newValues;
            }
        }

        public String name(int value) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (this.values[i2] != value) continue;
                return this.names[i2];
            }
            return null;
        }

        public int value(String name) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (!this.names[i2].equals(name)) continue;
                return this.values[i2];
            }
            return -1;
        }
    }

    static class LookupEntityMap
    extends PrimitiveEntityMap {
        private String[] lookupTable;
        private final int LOOKUP_TABLE_SIZE = 256;

        LookupEntityMap() {
        }

        public String name(int value) {
            if (value < 256) {
                return this.lookupTable()[value];
            }
            return super.name(value);
        }

        private String[] lookupTable() {
            if (this.lookupTable == null) {
                this.createLookupTable();
            }
            return this.lookupTable;
        }

        private void createLookupTable() {
            this.lookupTable = new String[256];
            for (int i2 = 0; i2 < 256; ++i2) {
                this.lookupTable[i2] = super.name(i2);
            }
        }
    }

    static class TreeEntityMap
    extends MapIntMap {
        public TreeEntityMap() {
            super(new TreeMap(), new TreeMap());
        }
    }

    static class HashEntityMap
    extends MapIntMap {
        public HashEntityMap() {
            super(new HashMap(), new HashMap());
        }
    }

    static abstract class MapIntMap
    implements EntityMap {
        protected final Map mapNameToValue;
        protected final Map mapValueToName;

        MapIntMap(Map nameToValue, Map valueToName) {
            this.mapNameToValue = nameToValue;
            this.mapValueToName = valueToName;
        }

        public void add(String name, int value) {
            this.mapNameToValue.put(name, new Integer(value));
            this.mapValueToName.put(new Integer(value), name);
        }

        public String name(int value) {
            return (String)this.mapValueToName.get(new Integer(value));
        }

        public int value(String name) {
            Object value = this.mapNameToValue.get(name);
            if (value == null) {
                return -1;
            }
            return (Integer)value;
        }
    }

    static class PrimitiveEntityMap
    implements EntityMap {
        private final Map mapNameToValue = new HashMap();
        private final IntHashMap mapValueToName = new IntHashMap();

        PrimitiveEntityMap() {
        }

        public void add(String name, int value) {
            this.mapNameToValue.put(name, new Integer(value));
            this.mapValueToName.put(value, name);
        }

        public String name(int value) {
            return (String)this.mapValueToName.get(value);
        }

        public int value(String name) {
            Object value = this.mapNameToValue.get(name);
            if (value == null) {
                return -1;
            }
            return (Integer)value;
        }
    }

    static interface EntityMap {
        public void add(String var1, int var2);

        public String name(int var1);

        public int value(String var1);
    }
}

