/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.util.BlockCompressedInputStream;
import org.broad.tribble.util.SeekableStreamFactory;

public class ParsingUtils {
    private static Logger log = Logger.getLogger(ParsingUtils.class);

    public static BufferedReader openBufferedReader(String path) throws IOException {
        InputStream stream = ParsingUtils.openInputStream(path);
        return new BufferedReader(new InputStreamReader(stream));
    }

    public static AsciiLineReader openAsciiReader(String path) throws IOException {
        InputStream stream = ParsingUtils.openInputStream(path);
        return new AsciiLineReader(stream);
    }

    public static InputStream openInputStream(String path) throws IOException {
        InputStream inputStream;
        if (path.startsWith("ftp:")) {
            throw new RuntimeException("FTP streams not supported.");
        }
        if (path.startsWith("http:") || path.startsWith("https:")) {
            inputStream = SeekableStreamFactory.getStreamFor(path);
        } else {
            File file = new File(path);
            inputStream = new FileInputStream(file);
        }
        if (path.endsWith("gz")) {
            return new BlockCompressedInputStream(inputStream);
        }
        return inputStream;
    }

    public static <T> String join(String separator, Collection<T> objects) {
        if (objects.isEmpty()) {
            return "";
        }
        Iterator<T> iter = objects.iterator();
        StringBuilder ret = new StringBuilder(iter.next().toString());
        while (iter.hasNext()) {
            ret.append(separator);
            ret.append(iter.next().toString());
        }
        return ret.toString();
    }

    public static <T extends Comparable> List<T> sortList(Collection<T> list) {
        ArrayList<T> ret = new ArrayList<T>();
        ret.addAll(list);
        Collections.sort(ret);
        return ret;
    }

    public static <T extends Comparable<T>, V> String sortedString(Map<T, V> c2) {
        ArrayList<T> t = new ArrayList<T>(c2.keySet());
        Collections.sort(t);
        ArrayList<String> pairs = new ArrayList<String>();
        for (Comparable k2 : t) {
            pairs.add(k2 + "=" + c2.get(k2));
        }
        return "{" + ParsingUtils.join(", ", pairs.toArray(new String[pairs.size()])) + "}";
    }

    public static String join(String separator, String[] strings) {
        return ParsingUtils.join(separator, strings, 0, strings.length);
    }

    public static String join(String separator, String[] strings, int start, int end) {
        if (end - start == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder(strings[start]);
        for (int i2 = start + 1; i2 < end; ++i2) {
            ret.append(separator);
            ret.append(strings[i2]);
        }
        return ret.toString();
    }

    public static int split(String aString, String[] tokens, char delim) {
        return ParsingUtils.split(aString, tokens, delim, false);
    }

    public static int split(String aString, String[] tokens, char delim, boolean condenseTrailingTokens) {
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int end = aString.indexOf(delim);
        if (end < 0) {
            tokens[nTokens++] = aString;
            return nTokens;
        }
        while (end > 0 && nTokens < maxTokens) {
            tokens[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
        }
        if (condenseTrailingTokens && nTokens == maxTokens) {
            tokens[nTokens - 1] = tokens[nTokens - 1] + delim + aString.substring(start);
        } else if (nTokens < maxTokens) {
            String trailingString = aString.substring(start);
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static String trim(String str, char ch) {
        int end;
        int start;
        char[] array = str.toCharArray();
        for (start = 0; start < array.length && array[start] == ch; ++start) {
        }
        for (end = array.length - 1; end > start && array[end] == ch; --end) {
        }
        return str.substring(start, end + 1);
    }

    public static int splitWhitespace(String aString, String[] tokens) {
        int end;
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int tabEnd = aString.indexOf(9);
        int spaceEnd = aString.indexOf(32);
        int n2 = tabEnd < 0 ? spaceEnd : (end = spaceEnd < 0 ? tabEnd : Math.min(spaceEnd, tabEnd));
        while (end > 0 && nTokens < maxTokens) {
            tokens[nTokens++] = aString.substring(start, end);
            for (start = end + 1; start < aString.length() && aString.charAt(start) == ' '; ++start) {
            }
            tabEnd = aString.indexOf(9, start);
            spaceEnd = aString.indexOf(32, start);
            end = tabEnd < 0 ? spaceEnd : (spaceEnd < 0 ? tabEnd : Math.min(spaceEnd, tabEnd));
        }
        if (nTokens < maxTokens) {
            String trailingString = aString.substring(start);
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(Iterable<T> iterable) {
        Iterator<T> iter = iterable.iterator();
        if (!iter.hasNext()) {
            return true;
        }
        Comparable t = (Comparable)iter.next();
        while (iter.hasNext()) {
            Comparable t2 = (Comparable)iter.next();
            if (t.compareTo(t2) > 0) {
                return false;
            }
            t = t2;
        }
        return true;
    }
}

