/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.interval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.broad.tribble.index.AbstractIndex;
import org.broad.tribble.index.Block;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.index.interval.Interval;
import org.broad.tribble.index.interval.IntervalTree;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.LittleEndianOutputStream;

public class IntervalTreeIndex
extends AbstractIndex {
    public IntervalTreeIndex() {
    }

    public IntervalTreeIndex(String featureFile) {
        super(featureFile);
    }

    @Override
    public Class getIndexClass() {
        return ChrIndex.class;
    }

    @Override
    protected int getType() {
        return IndexFactory.IndexType.INTERVAL_TREE.getHeaderValue();
    }

    public void insert(String chr, Interval interval) {
        ChrIndex chrIdx = (ChrIndex)this.chrIndeces.get(chr);
        if (chrIdx == null) {
            chrIdx = new ChrIndex(chr);
            this.chrIndeces.put(chr, chrIdx);
        }
        chrIdx.insert(interval);
    }

    protected void setChrIndex(List<ChrIndex> indicies) {
        for (ChrIndex index : indicies) {
            this.chrIndeces.put(index.getName(), index);
        }
    }

    public void printTree() {
        for (String chr : this.chrIndeces.keySet()) {
            System.out.println(chr + ":");
            ChrIndex chrIdx = (ChrIndex)this.chrIndeces.get(chr);
            chrIdx.printTree();
            System.out.println();
        }
    }

    public static class ChrIndex
    implements org.broad.tribble.index.ChrIndex {
        IntervalTree tree;
        String name;

        public ChrIndex() {
        }

        public ChrIndex(String name) {
            this.name = name;
            this.tree = new IntervalTree();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void insert(Interval iv) {
            this.tree.insert(iv);
        }

        @Override
        public List<Block> getBlocks() {
            return null;
        }

        @Override
        public List<Block> getBlocks(int start, int end) {
            List<Interval> intervals = this.tree.findOverlapping(new Interval(start, end));
            if (intervals == null || intervals.size() == 0) {
                return new ArrayList<Block>();
            }
            Block[] blocks = new Block[intervals.size()];
            int idx = 0;
            for (Interval iv : intervals) {
                blocks[idx++] = iv.getBlock();
            }
            Arrays.sort(blocks, new Comparator<Block>(){

                @Override
                public int compare(Block b1, Block b2) {
                    return b1.getStartPosition() - b2.getStartPosition() < 1L ? -1 : (b1.getStartPosition() - b2.getStartPosition() > 1L ? 1 : 0);
                }
            });
            ArrayList<Block> consolidatedBlocks = new ArrayList<Block>(blocks.length);
            Block lastBlock = blocks[0];
            consolidatedBlocks.add(lastBlock);
            for (int i2 = 1; i2 < blocks.length; ++i2) {
                Block block = blocks[i2];
                if (block.getStartPosition() < lastBlock.getEndPosition() + 1000L) {
                    lastBlock.setEndPosition(block.getEndPosition());
                    continue;
                }
                lastBlock = block;
                consolidatedBlocks.add(lastBlock);
            }
            return consolidatedBlocks;
        }

        public void printTree() {
            System.out.println(this.tree.toString());
        }

        @Override
        public void write(LittleEndianOutputStream dos) throws IOException {
            dos.writeString(this.name);
            List<Interval> intervals = this.tree.getIntervals();
            dos.writeInt(intervals.size());
            for (Interval interval : intervals) {
                dos.writeInt(interval.start);
                dos.writeInt(interval.end);
                dos.writeLong(interval.getBlock().getStartPosition());
                dos.writeInt(interval.getBlock().getSize());
            }
        }

        @Override
        public void read(LittleEndianInputStream dis) throws IOException {
            this.tree = new IntervalTree();
            this.name = dis.readString();
            int nIntervals = dis.readInt();
            while (nIntervals-- > 0) {
                int start = dis.readInt();
                int end = dis.readInt();
                long pos = dis.readLong();
                int size = dis.readInt();
                Interval iv = new Interval(start, end, new Block(pos, size));
                this.tree.insert(iv);
            }
        }
    }
}

