/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import net.sf.samtools.SAMFileReader;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.goby.GobyAlignmentQueryReader;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.BAMHttpQueryReader;
import org.broad.igv.sam.reader.BAMQueryReader;
import org.broad.igv.sam.reader.BAMRemoteQueryReader;
import org.broad.igv.sam.reader.GeraldQueryReader;
import org.broad.igv.sam.reader.MergedAlignmentReader;
import org.broad.igv.sam.reader.SamQueryTextReader;
import org.broad.igv.util.IGVHttpClientUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class SamQueryReaderFactory {
    private static Logger log = Logger.getLogger(SamQueryReaderFactory.class);

    public static AlignmentQueryReader getReader(String path, boolean requireIndex) throws IOException {
        return SamQueryReaderFactory.getReader(new ResourceLocator(path), requireIndex);
    }

    public static AlignmentQueryReader getReader(ResourceLocator locator) throws IOException {
        return SamQueryReaderFactory.getReader(locator, true);
    }

    public static AlignmentQueryReader getReader(ResourceLocator locator, boolean requireIndex) throws IOException {
        String pathLowerCase = locator.getPath().toLowerCase();
        AlignmentQueryReader reader = null;
        String samFile = locator.getPath();
        if (pathLowerCase.endsWith(".sam")) {
            reader = new SamQueryTextReader(samFile, requireIndex);
        } else if (pathLowerCase.endsWith("sorted.txt") || pathLowerCase.endsWith(".aligned") || pathLowerCase.endsWith(".aligned.txt") || pathLowerCase.endsWith("bedz") || pathLowerCase.endsWith("bed") || pathLowerCase.endsWith("psl") || pathLowerCase.endsWith("pslx")) {
            reader = new GeraldQueryReader(samFile, requireIndex);
        } else if (pathLowerCase.endsWith(".bam")) {
            if (locator.isLocal()) {
                reader = new BAMQueryReader(new File(samFile));
            } else if (IGVHttpClientUtils.isURL(locator.getPath().toLowerCase())) {
                try {
                    reader = new BAMHttpQueryReader(locator, requireIndex);
                }
                catch (MalformedURLException e2) {
                    log.error("", e2);
                    throw new DataLoadException("Error loading BAM file: " + e2.toString(), locator.getPath());
                }
            } else {
                reader = new BAMRemoteQueryReader(locator);
            }
        } else if (pathLowerCase.endsWith(".bam.list")) {
            reader = locator.getServerURL() != null ? new BAMRemoteQueryReader(locator) : SamQueryReaderFactory.getMergedReader(locator.getPath(), requireIndex);
        } else if (locator.isLocal() && GobyAlignmentQueryReader.supportsFileType(locator.getPath())) {
            try {
                reader = new GobyAlignmentQueryReader(locator.getPath());
            }
            catch (IOException e3) {
                throw new RuntimeException("Cannot load Goby alignment " + locator.getPath(), e3);
            }
        } else {
            throw new RuntimeException("Cannot find reader for aligment file: " + locator.getPath());
        }
        return reader;
    }

    static MergedAlignmentReader getMergedReader(String listFile, boolean requireIndex) {
        ArrayList<AlignmentQueryReader> readers = new ArrayList<AlignmentQueryReader>();
        BufferedReader reader = null;
        try {
            reader = ParsingUtils.openBufferedReader(listFile);
            String nextLine = null;
            while ((nextLine = reader.readLine()) != null) {
                String f2 = nextLine.trim();
                readers.add(SamQueryReaderFactory.getReader(f2, requireIndex));
            }
            MergedAlignmentReader mergedAlignmentReader = new MergedAlignmentReader(readers);
            return mergedAlignmentReader;
        }
        catch (IOException e2) {
            log.error("Error parsing " + listFile, e2);
            throw new RuntimeException("Error parsing: " + listFile + " (" + e2.toString() + ")");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e3) {}
            }
        }
    }

    static {
        SAMFileReader.setDefaultValidationStringency(SAMFileReader.ValidationStringency.SILENT);
    }
}

