/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.GenomeDescriptor;
import org.broad.igv.ui.util.MessageUtils;

public class Genome {
    private static Logger log = Logger.getLogger(Genome.class);
    private Map<String, String> chrAliasTable;
    private String id;
    private String formatVersion;
    private LinkedHashMap<String, Chromosome> chromosomeMap;
    private List<String> chromosomeNames;
    private long length = -1L;
    private String annotationURL;
    private Map<String, Long> cumulativeOffsets = new HashMap<String, Long>();
    public static final int MAX_WHOLE_GENOME = 10000;
    GenomeDescriptor descriptor;

    public Genome(GenomeDescriptor descriptor) {
        this.descriptor = descriptor;
        this.id = descriptor.getId();
        this.initAnnotationURL();
        this.chrAliasTable = new HashMap<String, String>();
    }

    private void initAnnotationURL() {
        if (this.id != null) {
            // empty if block
        }
    }

    public String getChromosomeAlias(String str) {
        if (this.chrAliasTable == null || str == null) {
            return str;
        }
        if (this.chrAliasTable.containsKey(str)) {
            return this.chrAliasTable.get(str);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUserDefinedAliases() {
        File aliasFile = new File(Globals.getGenomeCacheDirectory(), this.id + "_alias.tab");
        if (aliasFile.exists()) {
            if (this.chrAliasTable == null) {
                this.chrAliasTable = new HashMap<String, String>();
            }
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(aliasFile));
                this.loadChrAliases(br);
            }
            catch (Exception e2) {
                log.error("Error loading chr alias table", e2);
                MessageUtils.showMessage("<html>Error loading chromosome alias table.  Aliases will not be avaliable<br>" + e2.toString());
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
        }
    }

    public void loadChrAliases(BufferedReader br) throws IOException {
        String nextLine = "";
        while ((nextLine = br.readLine()) != null) {
            String[] kv = nextLine.split("\t");
            if (kv.length <= 1) continue;
            this.chrAliasTable.put(kv[0], kv[1]);
        }
    }

    public void setChromosomeMap(LinkedHashMap<String, Chromosome> chromosomeMap, boolean chromosomesAreOrdered) {
        this.chromosomeMap = chromosomeMap;
        this.chromosomeNames = new LinkedList<String>(chromosomeMap.keySet());
        if (!chromosomesAreOrdered) {
            Collections.sort(this.chromosomeNames, new ChromosomeComparator());
        }
        for (String name : this.chromosomeNames) {
            String alias;
            if (name.endsWith(".fa")) {
                alias = name.substring(0, name.length() - 3);
                this.chrAliasTable.put(alias, name);
            }
            if (name.startsWith("gi|")) {
                alias = Genome.getNCBIName(name);
                this.chrAliasTable.put(alias, name);
                Chromosome chromosome = chromosomeMap.get(name);
                continue;
            }
            if (name.toLowerCase().startsWith("chr")) {
                this.chrAliasTable.put(name.substring(3), name);
                continue;
            }
            this.chrAliasTable.put("chr" + name, name);
        }
        if (this.id.startsWith("hg") || this.id.equalsIgnoreCase("1kg_ref")) {
            this.chrAliasTable.put("23", "chrX");
            this.chrAliasTable.put("24", "chrY");
            this.chrAliasTable.put("MT", "chrM");
        } else if (this.id.startsWith("mm")) {
            this.chrAliasTable.put("21", "chrX");
            this.chrAliasTable.put("22", "chrY");
            this.chrAliasTable.put("MT", "chrM");
        } else if (this.id.equals("b37")) {
            this.chrAliasTable.put("chrM", "MT");
            this.chrAliasTable.put("chrX", "23");
            this.chrAliasTable.put("chrY", "24");
        }
    }

    public static String getNCBIName(String name) {
        String[] tokens = name.split("\\|");
        return tokens[tokens.length - 1];
    }

    public String getHomeChromosome() {
        if (this.getChromosomeNames().size() == 1 || this.chromosomeNames.size() > 10000) {
            return this.getChromosomeNames().get(0);
        }
        return "All";
    }

    public Chromosome getChromosome(String chrName) {
        return this.chromosomeMap.get(this.getChromosomeAlias(chrName));
    }

    public List<String> getChromosomeNames() {
        return this.chromosomeNames;
    }

    public Collection<Chromosome> getChromosomes() {
        return this.chromosomeMap.values();
    }

    public long getLength() {
        if (this.length < 0L) {
            this.length = 0L;
            for (Chromosome chr : this.chromosomeMap.values()) {
                this.length += (long)chr.getLength();
            }
        }
        return this.length;
    }

    public long getCumulativeOffset(String chr) {
        Long cumOffset = this.cumulativeOffsets.get(chr);
        if (cumOffset == null) {
            long offset = 0L;
            for (String c2 : this.getChromosomeNames()) {
                if (chr.equals(c2)) break;
                offset += (long)this.getChromosome(c2).getLength();
            }
            cumOffset = new Long(offset);
            this.cumulativeOffsets.put(chr, cumOffset);
        }
        return cumOffset;
    }

    public int getGenomeCoordinate(String chr, int locationBP) {
        return (int)((this.getCumulativeOffset(chr) + (long)locationBP) / 1000L);
    }

    public ChromosomeCoordinate getChromosomeCoordinate(int genomeKBP) {
        long cumOffset = 0L;
        for (String c2 : this.chromosomeNames) {
            int chrLen = this.getChromosome(c2).getLength();
            if ((cumOffset + (long)chrLen) / 1000L > (long)genomeKBP) {
                int bp = (int)((long)(genomeKBP * 1000) - cumOffset);
                return new ChromosomeCoordinate(c2, bp);
            }
            cumOffset += (long)chrLen;
        }
        String c3 = this.chromosomeNames.get(this.chromosomeNames.size() - 1);
        int bp = (int)((long)genomeKBP - cumOffset) * 1000;
        return new ChromosomeCoordinate(c3, bp);
    }

    public String getId() {
        return this.id;
    }

    public String getAnnotationURL() {
        return this.annotationURL;
    }

    public String getNextChrName(String chr) {
        List<String> chrList = this.getChromosomeNames();
        for (int i2 = 0; i2 < chrList.size() - 1; ++i2) {
            if (!chrList.get(i2).equals(chr)) continue;
            return chrList.get(i2 + 1);
        }
        return null;
    }

    public String getPrevChrName(String chr) {
        List<String> chrList = this.getChromosomeNames();
        for (int i2 = chrList.size() - 1; i2 > 0; --i2) {
            if (!chrList.get(i2).equals(chr)) continue;
            return chrList.get(i2 - 1);
        }
        return null;
    }

    public void setAnnotationURL(String annotationURL) {
        this.annotationURL = annotationURL;
    }

    public static class ChromosomeComparator
    implements Comparator<String> {
        @Override
        public int compare(String chr1, String chr2) {
            try {
                int idx2;
                if (chr1.equals("chrM") || chr1.equals("MT")) {
                    return 1;
                }
                if (chr2.equals("chrM") || chr2.equals("MT")) {
                    return -1;
                }
                int idx1 = this.findDigitIndex(chr1);
                if (idx1 == (idx2 = this.findDigitIndex(chr2))) {
                    String alpha2;
                    String alpha1 = idx1 == -1 ? chr1 : chr1.substring(0, idx1);
                    int alphaCmp = alpha1.compareTo(alpha2 = idx2 == -1 ? chr2 : chr2.substring(0, idx2));
                    if (alphaCmp != 0) {
                        return alphaCmp;
                    }
                    int dig1 = Integer.parseInt(chr1.substring(idx1));
                    int dig2 = Integer.parseInt(chr2.substring(idx2));
                    return dig1 - dig2;
                }
                if (idx1 == -1) {
                    return 1;
                }
                if (idx2 == -1) {
                    return -1;
                }
                return idx1 - idx2;
            }
            catch (Exception numberFormatException) {
                return 0;
            }
        }

        int findDigitIndex(String chr) {
            int n2 = chr.length() - 1;
            if (!Character.isDigit(chr.charAt(n2))) {
                return -1;
            }
            for (int i2 = n2 - 1; i2 > 0; --i2) {
                if (Character.isDigit(chr.charAt(i2))) continue;
                return i2 + 1;
            }
            return 0;
        }
    }

    public static class ChromosomeCoordinate {
        private String chr;
        private int coordinate;

        public ChromosomeCoordinate(String chr, int coordinate) {
            this.chr = chr;
            this.coordinate = coordinate;
        }

        public String getChr() {
            return this.chr;
        }

        public int getCoordinate() {
            return this.coordinate;
        }
    }
}

