/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdf5lib;

import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

public class HDFNativeData {
    public static synchronized native int[] byteToInt(byte[] var0);

    public static synchronized native float[] byteToFloat(byte[] var0);

    public static synchronized native short[] byteToShort(byte[] var0);

    public static synchronized native long[] byteToLong(byte[] var0);

    public static synchronized native double[] byteToDouble(byte[] var0);

    public static synchronized native int[] byteToInt(int var0, int var1, byte[] var2);

    public static synchronized int byteToInt(byte[] byArray, int n2) {
        int[] nArray = new int[1];
        nArray = HDFNativeData.byteToInt(n2, 1, byArray);
        return nArray[0];
    }

    public static synchronized native short[] byteToShort(int var0, int var1, byte[] var2);

    public static synchronized short byteToShort(byte[] byArray, int n2) {
        short[] sArray = new short[1];
        sArray = HDFNativeData.byteToShort(n2, 1, byArray);
        return sArray[0];
    }

    public static synchronized native float[] byteToFloat(int var0, int var1, byte[] var2);

    public static synchronized float byteToFloat(byte[] byArray, int n2) {
        float[] fArray = new float[1];
        fArray = HDFNativeData.byteToFloat(n2, 1, byArray);
        return fArray[0];
    }

    public static synchronized native long[] byteToLong(int var0, int var1, byte[] var2);

    public static synchronized long byteToLong(byte[] byArray, int n2) {
        long[] lArray = new long[1];
        lArray = HDFNativeData.byteToLong(n2, 1, byArray);
        return lArray[0];
    }

    public static synchronized native double[] byteToDouble(int var0, int var1, byte[] var2);

    public static synchronized double byteToDouble(byte[] byArray, int n2) {
        double[] dArray = new double[1];
        dArray = HDFNativeData.byteToDouble(n2, 1, byArray);
        return dArray[0];
    }

    public static synchronized native byte[] intToByte(int var0, int var1, int[] var2);

    public static synchronized native byte[] shortToByte(int var0, int var1, short[] var2);

    public static synchronized native byte[] floatToByte(int var0, int var1, float[] var2);

    public static synchronized native byte[] longToByte(int var0, int var1, long[] var2);

    public static synchronized native byte[] doubleToByte(int var0, int var1, double[] var2);

    public static synchronized native byte[] byteToByte(byte var0);

    public static synchronized byte[] byteToByte(Byte by) {
        return HDFNativeData.byteToByte((byte)by);
    }

    public static synchronized native byte[] intToByte(int var0);

    public static synchronized byte[] intToByte(Integer n2) {
        return HDFNativeData.intToByte((int)n2);
    }

    public static synchronized native byte[] shortToByte(short var0);

    public static synchronized byte[] shortToByte(Short s) {
        return HDFNativeData.shortToByte((short)s);
    }

    public static synchronized native byte[] floatToByte(float var0);

    public static synchronized byte[] floatToByte(Float f2) {
        return HDFNativeData.floatToByte(f2.floatValue());
    }

    public static synchronized native byte[] longToByte(long var0);

    public static synchronized byte[] longToByte(Long l2) {
        return HDFNativeData.longToByte((long)l2);
    }

    public static synchronized native byte[] doubleToByte(double var0);

    public static synchronized byte[] doubleToByte(Double d2) {
        return HDFNativeData.doubleToByte((double)d2);
    }

    public static synchronized Object byteToNumber(byte[] byArray, Object object) throws HDF5Exception {
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        Number number = null;
        if (string.equals("java.lang.Integer")) {
            int[] nArray = HDFNativeData.byteToInt(0, 1, byArray);
            number = new Integer(nArray[0]);
        } else if (string.equals("java.lang.Byte")) {
            number = new Byte(byArray[0]);
        } else if (string.equals("java.lang.Short")) {
            short[] sArray = HDFNativeData.byteToShort(0, 1, byArray);
            number = new Short(sArray[0]);
        } else if (string.equals("java.lang.Float")) {
            float[] fArray = HDFNativeData.byteToFloat(0, 1, byArray);
            number = new Float(fArray[0]);
        } else if (string.equals("java.lang.Long")) {
            long[] lArray = HDFNativeData.byteToLong(0, 1, byArray);
            number = new Long(lArray[0]);
        } else if (string.equals("java.lang.Double")) {
            double[] dArray = HDFNativeData.byteToDouble(0, 1, byArray);
            number = new Double(dArray[0]);
        } else {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("byteToNumber: setfield bad type: " + object + " " + string);
            throw hDF5JavaException;
        }
        return number;
    }

    static {
        int n2 = HDF5Constants.H5P_DEFAULT;
        int[] nArray = new int[4];
        try {
            H5.H5Pget_version(n2, nArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

