/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.AbstractIntListIterator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntStack;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntList
extends AbstractIntCollection
implements IntList,
IntStack {
    protected AbstractIntList() {
    }

    protected void ensureIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int index, int k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(int k2) {
        this.add(this.size(), k2);
        return true;
    }

    @Override
    public int removeInt(int i2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int set(int index, int k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends Integer> c2) {
        this.ensureIndex(index);
        int n2 = c2.size();
        if (n2 == 0) {
            return false;
        }
        Iterator<? extends Integer> i2 = c2.iterator();
        while (n2-- != 0) {
            this.add(index++, i2.next());
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c2) {
        return this.addAll(this.size(), c2);
    }

    @Override
    @Deprecated
    public IntListIterator intListIterator() {
        return this.listIterator();
    }

    @Override
    @Deprecated
    public IntListIterator intListIterator(int index) {
        return this.listIterator(index);
    }

    @Override
    public IntListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public IntListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public IntListIterator listIterator(final int index) {
        return new AbstractIntListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            public boolean hasNext() {
                return this.pos < AbstractIntList.this.size();
            }

            public boolean hasPrevious() {
                return this.pos > 0;
            }

            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractIntList.this.getInt(this.last);
            }

            public int previousInt() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractIntList.this.getInt(this.pos);
            }

            public int nextIndex() {
                return this.pos;
            }

            public int previousIndex() {
                return this.pos - 1;
            }

            public void add(int k2) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractIntList.this.add(this.pos++, k2);
                this.last = -1;
            }

            public void set(int k2) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractIntList.this.set(this.last, k2);
            }

            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractIntList.this.removeInt(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    @Override
    public boolean contains(int k2) {
        return this.indexOf(k2) >= 0;
    }

    @Override
    public int indexOf(int k2) {
        IntListIterator i2 = this.listIterator();
        while (i2.hasNext()) {
            int e2 = i2.nextInt();
            if (k2 != e2) continue;
            return i2.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int k2) {
        IntListIterator i2 = this.listIterator(this.size());
        while (i2.hasPrevious()) {
            int e2 = i2.previousInt();
            if (k2 != e2) continue;
            return i2.nextIndex();
        }
        return -1;
    }

    @Override
    public void size(int size) {
        int i2 = this.size();
        if (size > i2) {
            while (i2++ < size) {
                this.add(0);
            }
        } else {
            while (i2-- != size) {
                this.remove(i2);
            }
        }
    }

    @Override
    public IntList subList(int from, int to) {
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new IntSubList(this, from, to);
    }

    @Override
    @Deprecated
    public IntList intSubList(int from, int to) {
        return this.subList(from, to);
    }

    @Override
    public void removeElements(int from, int to) {
        this.ensureIndex(to);
        IntListIterator i2 = this.listIterator(from);
        int n2 = to - from;
        if (n2 < 0) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        while (n2-- != 0) {
            i2.nextInt();
            i2.remove();
        }
    }

    @Override
    public void addElements(int index, int[] a2, int offset, int length) {
        this.ensureIndex(index);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a2.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a2.length + ")");
        }
        while (length-- != 0) {
            this.add(index++, a2[offset++]);
        }
    }

    @Override
    public void addElements(int index, int[] a2) {
        this.addElements(index, a2, 0, a2.length);
    }

    @Override
    public void getElements(int from, int[] a2, int offset, int length) {
        IntListIterator i2 = this.listIterator(from);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a2.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a2.length + ")");
        }
        if (from + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (from + length) + ") is greater than list size (" + this.size() + ")");
        }
        while (length-- != 0) {
            a2[offset++] = i2.nextInt();
        }
    }

    private boolean valEquals(Object a2, Object b2) {
        return a2 == null ? b2 == null : a2.equals(b2);
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof List)) {
            return false;
        }
        List l2 = (List)o2;
        int s = this.size();
        if (s != l2.size()) {
            return false;
        }
        IntListIterator i1 = this.listIterator();
        ListIterator i2 = l2.listIterator();
        while (s-- != 0) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Integer> l2) {
        if (l2 == this) {
            return 0;
        }
        if (l2 instanceof IntList) {
            IntListIterator i1 = this.listIterator();
            IntListIterator i2 = ((IntList)l2).listIterator();
            while (i1.hasNext() && i2.hasNext()) {
                int r;
                int e2;
                int e1 = i1.nextInt();
                if ((e1 < (e2 = i2.nextInt()) ? -1 : (r = e1 == e2 ? 0 : 1)) == 0) continue;
                return r;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        IntListIterator i1 = this.listIterator();
        ListIterator<? extends Integer> i2 = l2.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r = ((Comparable)i1.next()).compareTo(i2.next());
            if (r == 0) continue;
            return r;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    @Override
    public int hashCode() {
        IntListIterator i2 = this.iterator();
        int h2 = 1;
        int s = this.size();
        while (s-- != 0) {
            int k2 = i2.nextInt();
            h2 = 31 * h2 + k2;
        }
        return h2;
    }

    @Override
    public void push(int o2) {
        this.add(o2);
    }

    @Override
    public int popInt() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeInt(this.size() - 1);
    }

    @Override
    public int topInt() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getInt(this.size() - 1);
    }

    @Override
    public int peekInt(int i2) {
        return this.getInt(this.size() - 1 - i2);
    }

    @Override
    public boolean rem(int k2) {
        int index = this.indexOf(k2);
        if (index == -1) {
            return false;
        }
        this.removeInt(index);
        return true;
    }

    @Override
    public boolean remove(Object o2) {
        return this.rem((Integer)o2);
    }

    @Override
    public boolean addAll(int index, IntCollection c2) {
        return this.addAll(index, (Collection<? extends Integer>)c2);
    }

    @Override
    public boolean addAll(int index, IntList l2) {
        return this.addAll(index, (IntCollection)l2);
    }

    @Override
    public boolean addAll(IntCollection c2) {
        return this.addAll(this.size(), c2);
    }

    @Override
    public boolean addAll(IntList l2) {
        return this.addAll(this.size(), l2);
    }

    @Override
    public void add(int index, Integer ok) {
        this.add(index, (int)ok);
    }

    @Override
    public Integer set(int index, Integer ok) {
        return this.set(index, (int)ok);
    }

    @Override
    public Integer get(int index) {
        return this.getInt(index);
    }

    @Override
    public int indexOf(Object ok) {
        return this.indexOf((Integer)ok);
    }

    @Override
    public int lastIndexOf(Object ok) {
        return this.lastIndexOf((Integer)ok);
    }

    @Override
    public Integer remove(int index) {
        return this.removeInt(index);
    }

    @Override
    public void push(Integer o2) {
        this.push((int)o2);
    }

    @Override
    public Integer pop() {
        return this.popInt();
    }

    @Override
    public Integer top() {
        return this.topInt();
    }

    @Override
    public Integer peek(int i2) {
        return this.peekInt(i2);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        IntListIterator i2 = this.iterator();
        int n2 = this.size();
        boolean first = true;
        s.append("[");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            int k2 = i2.nextInt();
            s.append(String.valueOf(k2));
        }
        s.append("]");
        return s.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntSubList
    extends AbstractIntList
    implements Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final IntList l;
        protected final int from;
        protected int to;
        private static final boolean ASSERTS = false;

        public IntSubList(IntList l2, int from, int to) {
            this.l = l2;
            this.from = from;
            this.to = to;
        }

        private void assertRange() {
        }

        @Override
        public boolean add(int k2) {
            this.l.add(this.to, k2);
            ++this.to;
            return true;
        }

        @Override
        public void add(int index, int k2) {
            this.ensureIndex(index);
            this.l.add(this.from + index, k2);
            ++this.to;
        }

        @Override
        public boolean addAll(int index, Collection<? extends Integer> c2) {
            this.ensureIndex(index);
            this.to += c2.size();
            return this.l.addAll(this.from + index, c2);
        }

        @Override
        public int getInt(int index) {
            this.ensureRestrictedIndex(index);
            return this.l.getInt(this.from + index);
        }

        @Override
        public int removeInt(int index) {
            this.ensureRestrictedIndex(index);
            --this.to;
            return this.l.removeInt(this.from + index);
        }

        @Override
        public int set(int index, int k2) {
            this.ensureRestrictedIndex(index);
            return this.l.set(this.from + index, k2);
        }

        @Override
        public void clear() {
            this.removeElements(0, this.size());
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int from, int[] a2, int offset, int length) {
            this.ensureIndex(from);
            if (from + length > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + from + length + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + from, a2, offset, length);
        }

        @Override
        public void removeElements(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            this.l.removeElements(this.from + from, this.from + to);
            this.to -= to - from;
        }

        @Override
        public void addElements(int index, int[] a2, int offset, int length) {
            this.ensureIndex(index);
            this.l.addElements(this.from + index, a2, offset, length);
            this.to += length;
        }

        @Override
        public IntListIterator listIterator(final int index) {
            this.ensureIndex(index);
            return new AbstractIntListIterator(){
                int pos;
                int last;
                {
                    this.pos = index;
                    this.last = -1;
                }

                public boolean hasNext() {
                    return this.pos < IntSubList.this.size();
                }

                public boolean hasPrevious() {
                    return this.pos > 0;
                }

                public int nextInt() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return IntSubList.this.l.getInt(IntSubList.this.from + this.last);
                }

                public int previousInt() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return IntSubList.this.l.getInt(IntSubList.this.from + this.pos);
                }

                public int nextIndex() {
                    return this.pos;
                }

                public int previousIndex() {
                    return this.pos - 1;
                }

                public void add(int k2) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    IntSubList.this.add(this.pos++, k2);
                    this.last = -1;
                }

                public void set(int k2) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    IntSubList.this.set(this.last, k2);
                }

                public void remove() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    IntSubList.this.removeInt(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1;
                }
            };
        }

        @Override
        public IntList subList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            return new IntSubList(this, from, to);
        }

        @Override
        public boolean rem(int k2) {
            int index = this.indexOf(k2);
            if (index == -1) {
                return false;
            }
            --this.to;
            this.l.removeInt(this.from + index);
            return true;
        }

        @Override
        public boolean remove(Object o2) {
            return this.rem((Integer)o2);
        }

        @Override
        public boolean addAll(int index, IntCollection c2) {
            this.ensureIndex(index);
            this.to += c2.size();
            return this.l.addAll(this.from + index, c2);
        }

        @Override
        public boolean addAll(int index, IntList l2) {
            this.ensureIndex(index);
            this.to += l2.size();
            return this.l.addAll(this.from + index, l2);
        }
    }
}

