/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.ButtonPanel;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SizeRequirements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ButtonPanelLayout
implements LayoutManager2,
Serializable {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    private Container _target;
    private transient SizeRequirements[] _xChildren;
    private transient SizeRequirements[] _yChildren;
    private transient SizeRequirements _xTotal;
    private transient SizeRequirements _yTotal;
    private List<Component> _affirmativeButtons = new Vector<Component>(13);
    private List<Component> _cancelButtons = new Vector<Component>(13);
    private List<Component> _helpButtons = new Vector<Component>(13);
    private List<Component> _otherButtons = new Vector<Component>(13);
    int _minWidth;
    int _maxWidth;
    int _groupGap = 10;
    int _buttonGap = 6;
    private int _sizeConstraint = 1;
    private String _buttonOrder = "ACO";
    private String _oppositeButtonOrder = "H";
    private int _minButtonWidth = 75;
    private int _axis = 0;
    private int _alignment = 11;

    public ButtonPanelLayout(Container container, int n2, int n3, int n4, String string, String string2, int n5, int n6) {
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3) {
            throw new AWTError("Invalid axis");
        }
        this._axis = n2;
        this._target = container;
        this._alignment = n3;
        this._sizeConstraint = n4;
        this._buttonOrder = string;
        this._oppositeButtonOrder = string2;
        this._buttonGap = n5;
        this._groupGap = n6;
    }

    @Override
    public synchronized void invalidateLayout(Container container) {
        this.checkContainer(container);
        this._xChildren = null;
        this._yChildren = null;
        this._xTotal = null;
        this._yTotal = null;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        if (this._affirmativeButtons.contains(component)) {
            this._affirmativeButtons.remove(component);
        }
        if (this._cancelButtons.contains(component)) {
            this._cancelButtons.remove(component);
        }
        if (this._helpButtons.contains(component)) {
            this._helpButtons.remove(component);
        }
        if (this._otherButtons.contains(component)) {
            this._otherButtons.remove(component);
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if ("AFFIRMATIVE".equals(object) && !this._affirmativeButtons.contains(component)) {
            this._affirmativeButtons.add(component);
        }
        if ("CANCEL".equals(object) && !this._cancelButtons.contains(component)) {
            this._cancelButtons.add(component);
        }
        if ("HELP".equals(object) && !this._helpButtons.contains(component)) {
            this._helpButtons.add(component);
        }
        if ("ALTERNATIVE".equals(object) && !this._otherButtons.contains(component)) {
            this._otherButtons.add(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension;
        Serializable serializable = this;
        synchronized (serializable) {
            this.checkContainer(container);
            this.checkRequests();
            dimension = new Dimension(this._xTotal.preferred, this._yTotal.preferred);
        }
        serializable = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)serializable).left + (long)((Insets)serializable).right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)serializable).top + (long)((Insets)serializable).bottom, Integer.MAX_VALUE);
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension;
        Serializable serializable = this;
        synchronized (serializable) {
            this.checkContainer(container);
            this.checkRequests();
            dimension = new Dimension(this._xTotal.minimum, this._yTotal.minimum);
        }
        serializable = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)serializable).left + (long)((Insets)serializable).right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)serializable).top + (long)((Insets)serializable).bottom, Integer.MAX_VALUE);
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension maximumLayoutSize(Container container) {
        Dimension dimension;
        Serializable serializable = this;
        synchronized (serializable) {
            this.checkContainer(container);
            this.checkRequests();
            dimension = new Dimension(this._xTotal.maximum, this._yTotal.maximum);
        }
        serializable = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)serializable).left + (long)((Insets)serializable).right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)serializable).top + (long)((Insets)serializable).bottom, Integer.MAX_VALUE);
        return dimension;
    }

    @Override
    public synchronized float getLayoutAlignmentX(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this._xTotal.alignment;
    }

    @Override
    public synchronized float getLayoutAlignmentY(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this._yTotal.alignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        this.checkContainer(container);
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        ComponentOrientation componentOrientation = container.getComponentOrientation();
        int n2 = this.resolveAxis(this._axis, componentOrientation);
        boolean bl = componentOrientation.isLeftToRight();
        int n3 = this._alignment;
        if (this._alignment == 10) {
            n3 = bl ? 2 : 4;
        } else if (this._alignment == 11) {
            n3 = bl ? 4 : 2;
        }
        ButtonPanelLayout buttonPanelLayout = this;
        synchronized (buttonPanelLayout) {
            this.checkRequests();
            this.resetBounds();
            if (n2 == 0) {
                int n4 = insets.top;
                if (n3 == 0) {
                    char c2;
                    int n5;
                    Dimension dimension2 = this.preferredLayoutSize(container);
                    int n6 = (dimension.width + dimension2.width) / 2;
                    for (n5 = 0; n5 < this.getButtonOrder().length(); ++n5) {
                        c2 = this.getButtonOrder().charAt(this.getButtonOrder().length() - n5 - 1);
                        if (c2 == 'A' || c2 == 'a') {
                            n6 = this.layoutButtonsRightAlign(this._affirmativeButtons, n6, n4, dimension);
                            continue;
                        }
                        if (c2 == 'C' || c2 == 'c') {
                            n6 = this.layoutButtonsRightAlign(this._cancelButtons, n6, n4, dimension);
                            continue;
                        }
                        if (c2 == 'H' || c2 == 'h') {
                            n6 = this.layoutButtonsRightAlign(this._helpButtons, n6, n4, dimension);
                            continue;
                        }
                        if (c2 != 'O' && c2 != 'o') continue;
                        n6 = this.layoutButtonsRightAlign(this._otherButtons, n6, n4, dimension);
                    }
                    n6 = (dimension.width - dimension2.width) / 2;
                    for (n5 = 0; n5 < this.getOppositeButtonOrder().length(); ++n5) {
                        c2 = this.getOppositeButtonOrder().charAt(n5);
                        if (c2 == 'A' || c2 == 'a') {
                            n6 = this.layoutButtonsLeftAlign(this._affirmativeButtons, n6, n4, dimension);
                            continue;
                        }
                        if (c2 == 'C' || c2 == 'c') {
                            n6 = this.layoutButtonsLeftAlign(this._cancelButtons, n6, n4, dimension);
                            continue;
                        }
                        if (c2 == 'H' || c2 == 'h') {
                            n6 = this.layoutButtonsLeftAlign(this._helpButtons, n6, n4, dimension);
                            continue;
                        }
                        if (c2 != 'O' && c2 != 'o') continue;
                        n6 = this.layoutButtonsLeftAlign(this._otherButtons, n6, n4, dimension);
                    }
                } else if (n3 == 4) {
                    char c3;
                    int n7;
                    int n8 = insets.left + dimension.width;
                    for (n7 = 0; n7 < this.getButtonOrder().length(); ++n7) {
                        c3 = this.getButtonOrder().charAt(bl ? this.getButtonOrder().length() - n7 - 1 : n7);
                        if (c3 == 'A' || c3 == 'a') {
                            n8 = this.layoutButtonsRightAlign(this._affirmativeButtons, n8, n4, dimension);
                            continue;
                        }
                        if (c3 == 'C' || c3 == 'c') {
                            n8 = this.layoutButtonsRightAlign(this._cancelButtons, n8, n4, dimension);
                            continue;
                        }
                        if (c3 == 'H' || c3 == 'h') {
                            n8 = this.layoutButtonsRightAlign(this._helpButtons, n8, n4, dimension);
                            continue;
                        }
                        if (c3 != 'O' && c3 != 'o') continue;
                        n8 = this.layoutButtonsRightAlign(this._otherButtons, n8, n4, dimension);
                    }
                    n8 = insets.left;
                    for (n7 = 0; n7 < this.getOppositeButtonOrder().length(); ++n7) {
                        c3 = this.getOppositeButtonOrder().charAt(bl ? n7 : this.getOppositeButtonOrder().length() - n7 - 1);
                        if (c3 == 'A' || c3 == 'a') {
                            n8 = this.layoutButtonsLeftAlign(this._affirmativeButtons, n8, n4, dimension);
                            continue;
                        }
                        if (c3 == 'C' || c3 == 'c') {
                            n8 = this.layoutButtonsLeftAlign(this._cancelButtons, n8, n4, dimension);
                            continue;
                        }
                        if (c3 == 'H' || c3 == 'h') {
                            n8 = this.layoutButtonsLeftAlign(this._helpButtons, n8, n4, dimension);
                            continue;
                        }
                        if (c3 != 'O' && c3 != 'o') continue;
                        n8 = this.layoutButtonsLeftAlign(this._otherButtons, n8, n4, dimension);
                    }
                } else if (n3 == 2) {
                    char c4;
                    int n9;
                    int n10 = insets.left;
                    for (n9 = 0; n9 < this.getButtonOrder().length(); ++n9) {
                        c4 = this.getButtonOrder().charAt(bl ? n9 : this.getButtonOrder().length() - n9 - 1);
                        if (c4 == 'A' || c4 == 'a') {
                            n10 = this.layoutButtonsLeftAlign(this._affirmativeButtons, n10, n4, dimension);
                            continue;
                        }
                        if (c4 == 'C' || c4 == 'c') {
                            n10 = this.layoutButtonsLeftAlign(this._cancelButtons, n10, n4, dimension);
                            continue;
                        }
                        if (c4 == 'H' || c4 == 'h') {
                            n10 = this.layoutButtonsLeftAlign(this._helpButtons, n10, n4, dimension);
                            continue;
                        }
                        if (c4 != 'O' && c4 != 'o') continue;
                        n10 = this.layoutButtonsLeftAlign(this._otherButtons, n10, n4, dimension);
                    }
                    n10 = insets.left + dimension.width;
                    for (n9 = 0; n9 < this.getOppositeButtonOrder().length(); ++n9) {
                        c4 = this.getOppositeButtonOrder().charAt(bl ? this.getOppositeButtonOrder().length() - n9 - 1 : n9);
                        if (c4 == 'A' || c4 == 'a') {
                            n10 = this.layoutButtonsRightAlign(this._affirmativeButtons, n10, n4, dimension);
                            continue;
                        }
                        if (c4 == 'C' || c4 == 'c') {
                            n10 = this.layoutButtonsRightAlign(this._cancelButtons, n10, n4, dimension);
                            continue;
                        }
                        if (c4 == 'H' || c4 == 'h') {
                            n10 = this.layoutButtonsRightAlign(this._helpButtons, n10, n4, dimension);
                            continue;
                        }
                        if (c4 != 'O' && c4 != 'o') continue;
                        n10 = this.layoutButtonsRightAlign(this._otherButtons, n10, n4, dimension);
                    }
                }
            } else {
                int n11 = insets.left;
                if (n3 == 1) {
                    char c5;
                    int n12;
                    int n13 = insets.top;
                    for (n12 = 0; n12 < this.getButtonOrder().length(); ++n12) {
                        c5 = this.getButtonOrder().charAt(n12);
                        if (c5 == 'A' || c5 == 'a') {
                            n13 = this.layoutButtonsTopAlign(this._affirmativeButtons, n11, n13, dimension);
                            continue;
                        }
                        if (c5 == 'C' || c5 == 'c') {
                            n13 = this.layoutButtonsTopAlign(this._cancelButtons, n11, n13, dimension);
                            continue;
                        }
                        if (c5 == 'H' || c5 == 'h') {
                            n13 = this.layoutButtonsTopAlign(this._helpButtons, n11, n13, dimension);
                            continue;
                        }
                        if (c5 != 'O' && c5 != 'o') continue;
                        n13 = this.layoutButtonsTopAlign(this._otherButtons, n11, n13, dimension);
                    }
                    n13 = insets.top + dimension.height;
                    for (n12 = 0; n12 < this.getOppositeButtonOrder().length(); ++n12) {
                        c5 = this.getOppositeButtonOrder().charAt(this.getOppositeButtonOrder().length() - n12 - 1);
                        if (c5 == 'A' || c5 == 'a') {
                            n13 = this.layoutButtonsBottomAlign(this._affirmativeButtons, n11, n13, dimension);
                            continue;
                        }
                        if (c5 == 'C' || c5 == 'c') {
                            n13 = this.layoutButtonsBottomAlign(this._cancelButtons, n11, n13, dimension);
                            continue;
                        }
                        if (c5 == 'H' || c5 == 'h') {
                            n13 = this.layoutButtonsBottomAlign(this._helpButtons, n11, n13, dimension);
                            continue;
                        }
                        if (c5 != 'O' && c5 != 'o') continue;
                        n13 = this.layoutButtonsBottomAlign(this._otherButtons, n11, n13, dimension);
                    }
                } else if (n3 == 3) {
                    char c6;
                    int n14;
                    int n15 = insets.top + dimension.height;
                    for (n14 = 0; n14 < this.getButtonOrder().length(); ++n14) {
                        c6 = this.getButtonOrder().charAt(this.getButtonOrder().length() - n14 - 1);
                        if (c6 == 'A' || c6 == 'a') {
                            n15 = this.layoutButtonsBottomAlign(this._affirmativeButtons, n11, n15, dimension);
                            continue;
                        }
                        if (c6 == 'C' || c6 == 'c') {
                            n15 = this.layoutButtonsBottomAlign(this._cancelButtons, n11, n15, dimension);
                            continue;
                        }
                        if (c6 == 'H' || c6 == 'h') {
                            n15 = this.layoutButtonsBottomAlign(this._helpButtons, n11, n15, dimension);
                            continue;
                        }
                        if (c6 != 'O' && c6 != 'o') continue;
                        n15 = this.layoutButtonsBottomAlign(this._otherButtons, n11, n15, dimension);
                    }
                    n15 = insets.top;
                    for (n14 = 0; n14 < this.getOppositeButtonOrder().length(); ++n14) {
                        c6 = this.getOppositeButtonOrder().charAt(n14);
                        if (c6 == 'A' || c6 == 'a') {
                            n15 = this.layoutButtonsTopAlign(this._affirmativeButtons, n11, n15, dimension);
                            continue;
                        }
                        if (c6 == 'C' || c6 == 'c') {
                            n15 = this.layoutButtonsTopAlign(this._cancelButtons, n11, n15, dimension);
                            continue;
                        }
                        if (c6 == 'H' || c6 == 'h') {
                            n15 = this.layoutButtonsTopAlign(this._helpButtons, n11, n15, dimension);
                            continue;
                        }
                        if (c6 != 'O' && c6 != 'o') continue;
                        n15 = this.layoutButtonsTopAlign(this._otherButtons, n11, n15, dimension);
                    }
                }
            }
        }
    }

    private int layoutButtonsRightAlign(List list, int n2, int n3, Dimension dimension) {
        boolean bl = false;
        for (int i2 = this._target.getComponentCount() - 1; i2 >= 0; --i2) {
            Component component = this._target.getComponent(i2);
            if (!component.isVisible() || !list.contains(component)) continue;
            if (bl) {
                n2 -= this._buttonGap;
            }
            bl = true;
            int n4 = component.getPreferredSize().width;
            int n5 = n4 > this._minWidth || this.shouldKeepPreferredWidth(component) ? n4 : this._minWidth;
            component.setBounds(n2 - n5, n3, n5, dimension.height);
            n2 -= n5;
        }
        if (list.size() != 0 && bl) {
            n2 -= this._groupGap;
        }
        return n2;
    }

    private int layoutButtonsLeftAlign(List<Component> list, int n2, int n3, Dimension dimension) {
        for (int i2 = 0; i2 < this._target.getComponentCount(); ++i2) {
            Component component = this._target.getComponent(i2);
            if (!component.isVisible() || !list.contains(component)) continue;
            boolean bl = true;
            int n4 = component.getPreferredSize().width;
            int n5 = n4 > this._minWidth || this.shouldKeepPreferredWidth(component) ? n4 : this._minWidth;
            component.setBounds(n2, n3, n5, dimension.height);
            n2 += n5;
            if (i2 == list.size() - 1 || !bl) continue;
            n2 += this._buttonGap;
        }
        if (list.size() != 0) {
            n2 += this._groupGap;
        }
        return n2;
    }

    private int layoutButtonsBottomAlign(List<Component> list, int n2, int n3, Dimension dimension) {
        boolean bl = false;
        for (int i2 = this._target.getComponentCount() - 1; i2 >= 0; --i2) {
            Component component = this._target.getComponent(i2);
            if (!component.isVisible() || !list.contains(component)) continue;
            bl = true;
            Dimension dimension2 = component.getPreferredSize();
            int n4 = dimension2.height;
            int n5 = dimension2.width;
            component.setBounds(this.shouldKeepPreferredWidth(component) ? dimension.width - n5 + n2 : n2, n3 - n4, this.shouldKeepPreferredWidth(component) ? n5 : dimension.width, n4);
            n3 -= n4;
            if (i2 == 0) continue;
            n3 -= this._buttonGap;
        }
        if (list.size() != 0 && bl) {
            n3 -= this._groupGap;
        }
        return n3;
    }

    private int layoutButtonsTopAlign(List<Component> list, int n2, int n3, Dimension dimension) {
        boolean bl = false;
        for (int i2 = 0; i2 < this._target.getComponentCount(); ++i2) {
            Component component = this._target.getComponent(i2);
            if (!component.isVisible() || !list.contains(component)) continue;
            bl = true;
            Dimension dimension2 = component.getPreferredSize();
            int n4 = dimension2.height;
            int n5 = dimension2.width;
            component.setBounds(this.shouldKeepPreferredWidth(component) ? dimension.width - n5 + n2 : n2, n3, this.shouldKeepPreferredWidth(component) ? n5 : dimension.width, n4);
            n3 += n4;
            if (i2 == list.size() - 1) continue;
            n3 += this._buttonGap;
        }
        if (list.size() != 0 && bl) {
            n3 += this._groupGap;
        }
        return n3;
    }

    private boolean shouldKeepPreferredWidth(Component component) {
        return component instanceof JComponent && Boolean.TRUE.equals(((JComponent)component).getClientProperty("keepPreferredWidth"));
    }

    void checkContainer(Container container) {
        if (this._target != container) {
            throw new AWTError("BorderPaneLayout can't be shared");
        }
        if (!(container instanceof ButtonPanel)) {
            throw new AWTError("Target is not a ButtonPanel");
        }
    }

    int getButtonCountof(List<Component> list) {
        int n2 = 0;
        for (Component component : list) {
            if (!component.isVisible()) continue;
            ++n2;
        }
        return n2;
    }

    void checkRequests() {
        int n2 = (this.getButtonCountof(this._affirmativeButtons) == 0 ? 0 : 1) + (this.getButtonCountof(this._otherButtons) == 0 ? 0 : 1) + (this.getButtonCountof(this._cancelButtons) == 0 ? 0 : 1) + (this.getButtonCountof(this._helpButtons) == 0 ? 0 : 1);
        int n3 = this.getButtonCountof(this._affirmativeButtons) + this.getButtonCountof(this._otherButtons) + this.getButtonCountof(this._cancelButtons) + this.getButtonCountof(this._helpButtons);
        if (this._xChildren == null || this._yChildren == null) {
            int n4;
            int n5;
            int n6;
            int n7 = n6 = this._target.getComponentCount();
            for (n5 = 0; n5 < n6; ++n5) {
                if (this._target.getComponent(n5).isVisible()) continue;
                --n7;
            }
            this._xChildren = new SizeRequirements[n7];
            this._yChildren = new SizeRequirements[n7];
            n5 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                Component component = this._target.getComponent(n4);
                if (!component.isVisible()) continue;
                Dimension dimension = component.getMinimumSize();
                Dimension dimension2 = component.getPreferredSize();
                Dimension serializable = component.getMaximumSize();
                this._xChildren[n5] = new SizeRequirements(dimension.width, dimension2.width, serializable.width, component.getAlignmentX());
                this._yChildren[n5] = new SizeRequirements(dimension.height, dimension2.height, serializable.height, component.getAlignmentY());
                if (this.shouldKeepPreferredWidth(this._target.getComponent(n4))) {
                    this._xChildren[n5].maximum = 0;
                }
                ++n5;
            }
            n4 = this.resolveAxis(this._axis, this._target.getComponentOrientation());
            if (n4 == 0) {
                int n8;
                this._xTotal = SizeRequirements.getTiledSizeRequirements(this._xChildren);
                this._yTotal = SizeRequirements.getAlignedSizeRequirements(this._yChildren);
                this._maxWidth = SizeRequirements.getAlignedSizeRequirements((SizeRequirements[])this._xChildren).maximum;
                if (this._sizeConstraint == 0) {
                    n8 = this.getMinButtonWidth();
                    if (this._maxWidth < n8) {
                        this._maxWidth = n8;
                    }
                    this._minWidth = this._maxWidth;
                } else {
                    n8 = this.getMinButtonWidth();
                    this._minWidth = n8 == 0 ? 75 : n8;
                }
                for (SizeRequirements sizeRequirements : this._xChildren) {
                    if (sizeRequirements.preferred >= this._minWidth) continue;
                    sizeRequirements.preferred = this._minWidth;
                }
                this._xTotal = SizeRequirements.getTiledSizeRequirements(this._xChildren);
                this._xTotal.preferred += (n2 - 1) * this._groupGap + (n3 - n2) * this._buttonGap;
                this._xTotal.minimum += (n2 - 1) * this._groupGap + (n3 - n2) * this._buttonGap;
            } else {
                this._xTotal = SizeRequirements.getAlignedSizeRequirements(this._xChildren);
                this._yTotal = SizeRequirements.getTiledSizeRequirements(this._yChildren);
                int n9 = this.getMinButtonWidth();
                this._maxWidth = n9 == 0 ? 75 : n9;
                this._minWidth = this._maxWidth;
                this._xTotal.preferred = this._maxWidth > this._xTotal.maximum ? this._maxWidth : this._xTotal.preferred;
                this._yTotal.preferred += (n2 - 1) * this._groupGap + (n3 - n2) * this._buttonGap;
                this._yTotal.minimum += (n2 - 1) * this._groupGap + (n3 - n2) * this._buttonGap;
            }
        }
    }

    private int resolveAxis(int n2, ComponentOrientation componentOrientation) {
        int n3 = n2 == 2 ? (componentOrientation.isHorizontal() ? 0 : 1) : (n2 == 3 ? (componentOrientation.isHorizontal() ? 1 : 0) : n2);
        return n3;
    }

    public int getGroupGap() {
        return this._groupGap;
    }

    public void setGroupGap(int n2) {
        this._groupGap = n2;
        this.invalidateLayout(this._target);
    }

    public int getButtonGap() {
        return this._buttonGap;
    }

    public void setButtonGap(int n2) {
        this._buttonGap = n2;
        this.invalidateLayout(this._target);
    }

    public int getSizeConstraint() {
        return this._sizeConstraint;
    }

    public void setSizeConstraint(int n2) {
        this._sizeConstraint = n2;
        this.invalidateLayout(this._target);
    }

    public int getMinButtonWidth() {
        return this._minButtonWidth;
    }

    public void setMinButtonWidth(int n2) {
        this._minButtonWidth = n2;
        this.invalidateLayout(this._target);
    }

    public String getButtonOrder() {
        if (this._buttonOrder == null) {
            return "";
        }
        return this._buttonOrder;
    }

    public void setButtonOrder(String string) {
        this._buttonOrder = string;
        this.invalidateLayout(this._target);
    }

    public String getOppositeButtonOrder() {
        if (this._oppositeButtonOrder == null) {
            return "";
        }
        return this._oppositeButtonOrder;
    }

    public void setOppositeButtonOrder(String string) {
        this._oppositeButtonOrder = string;
        this.invalidateLayout(this._target);
    }

    public int getAxis() {
        return this._axis;
    }

    public void setAxis(int n2) {
        this._axis = n2;
        this.invalidateLayout(this._target);
    }

    public int getAlignment() {
        return this._alignment;
    }

    public void setAlignment(int n2) {
        this._alignment = n2;
        this.invalidateLayout(this._target);
    }

    void resetBounds() {
        for (Component component : this._affirmativeButtons) {
            component.setBounds(0, 0, 0, 0);
        }
        for (Component component : this._cancelButtons) {
            component.setBounds(0, 0, 0, 0);
        }
        for (Component component : this._otherButtons) {
            component.setBounds(0, 0, 0, 0);
        }
        for (Component component : this._helpButtons) {
            component.setBounds(0, 0, 0, 0);
        }
    }
}

