/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.vcf;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineTranslator;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderVersion;
import org.broadinstitute.sting.utils.codecs.vcf.VCFNamedHeaderLine;

public class VCFFilterHeaderLine
extends VCFHeaderLine
implements VCFNamedHeaderLine {
    private String name;
    private String description;

    public VCFFilterHeaderLine(String name, String description) {
        super("FILTER", "");
        this.name = name;
        this.description = description;
        if (name == null || description == null) {
            throw new IllegalArgumentException(String.format("Invalid VCFCompoundHeaderLine: key=%s name=%s desc=%s", super.getKey(), name, description));
        }
    }

    protected VCFFilterHeaderLine(String line, VCFHeaderVersion version) {
        super("FILTER", "");
        Map<String, String> mapping = VCFHeaderLineTranslator.parseLine(version, line, Arrays.asList("ID", "Description"));
        this.name = mapping.get("ID");
        this.description = mapping.get("Description");
        if (this.description == null && ALLOW_UNBOUND_DESCRIPTIONS) {
            this.description = UNBOUND_DESCRIPTION;
        }
    }

    @Override
    protected String toStringEncoding() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("ID", this.name);
        map.put("Description", this.description);
        return "FILTER=" + VCFHeaderLine.toStringEncoding(map);
    }

    @Override
    public boolean equals(Object o2) {
        if (!(o2 instanceof VCFFilterHeaderLine)) {
            return false;
        }
        VCFFilterHeaderLine other = (VCFFilterHeaderLine)o2;
        return this.name.equals(other.name) && this.description.equals(other.description);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

