/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.vcf;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.session.SessionReader;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.PackedFeatures;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TribbleFeatureSource;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.vcf.VCFMenu;
import org.broad.igv.vcf.VCFRenderer;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class VCFTrack
extends FeatureTrack {
    private static Logger log = Logger.getLogger(VCFTrack.class);
    private static final Color OFF_WHITE = new Color(170, 170, 170);
    private static final int GROUP_BORDER_WIDTH = 3;
    private static final Color BAND1_COLOR = new Color(245, 245, 245);
    private static final Color BAND2_COLOR = Color.white;
    private static Map<String, String> REFERENCE_SAMPLE_GROUP_MAP = new HashMap<String, String>();
    private static LinkedHashMap<String, List<String>> REFERENCE_GROUP_SAMPLE_MAP;
    private boolean enableMethylationRateSupport;
    private static final Color borderGray;
    private static final int DEFAULT_EXPANDED_GENOTYPE_HEIGHT = 15;
    private final int DEFAULT_SQUISHED_GENOTYPE_HEIGHT = 4;
    private static final int DEFAULT_VARIANT_BAND_HEIGHT = 25;
    private static final int MAX_FILTER_LINES = 15;
    private VCFRenderer renderer = new VCFRenderer(this);
    private int squishedHeight = 4;
    private int top;
    private int variantBandHeight = 25;
    LinkedHashMap<String, List<String>> samplesByGroups = new LinkedHashMap();
    List<String> allSamples;
    List<String> groupNames;
    int sampleCount;
    private boolean grouped;
    private boolean hasGroups;
    private ColorMode coloring = ColorMode.GENOTYPE;
    private boolean hideAncestral = false;
    private boolean hideFiltered = false;
    private boolean renderID = true;
    private static float[] dash;
    DecimalFormat numFormat = new DecimalFormat("#.###");
    Feature selectedVariant;
    private String previousGroupId;
    static Map<String, String> fullNames;

    public boolean isEnableMethylationRateSupport() {
        return this.enableMethylationRateSupport;
    }

    public static void addSampleGroups(LinkedHashMap<String, List<String>> map) {
        REFERENCE_GROUP_SAMPLE_MAP = map;
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String family = entry.getKey();
            for (String sample : entry.getValue()) {
                REFERENCE_SAMPLE_GROUP_MAP.put(sample, family);
            }
        }
    }

    public VCFTrack(ResourceLocator locator, TribbleFeatureSource source) {
        super(locator, source);
        VCFHeader header = (VCFHeader)source.getHeader();
        if (header.getFormatHeaderLine("MR") != null && header.getFormatHeaderLine("GB") != null) {
            this.enableMethylationRateSupport = true;
            this.coloring = ColorMode.METHYLATION_RATE;
        }
        this.allSamples = new ArrayList<String>(header.getGenotypeSamples());
        this.sampleCount = this.allSamples.size();
        for (String sample : this.allSamples) {
            List<String> sampleList;
            String key = REFERENCE_SAMPLE_GROUP_MAP.get(sample);
            if (key == null) {
                key = "Other";
            }
            if ((sampleList = this.samplesByGroups.get(key)) == null) {
                sampleList = new ArrayList<String>();
                this.samplesByGroups.put(key, sampleList);
            }
            sampleList.add(sample);
        }
        this.initGroups();
        this.setupGroupsFromAttributes();
        this.setDisplayMode(Track.DisplayMode.EXPANDED);
        this.setRenderID(false);
        int cnt = Math.max(1, this.sampleCount);
        int beta = 100000;
        int visWindow = Math.min(500000, beta / cnt * 1000);
        this.setVisibilityWindow(visWindow);
    }

    private void setupGroupsFromAttributes() {
        AttributeManager manager = AttributeManager.getInstance();
        String groupByAttributeId = IGV.getInstance().getTrackManager().getGroupByAttribute();
        if (groupByAttributeId == null || groupByAttributeId.equals(this.previousGroupId)) {
            return;
        }
        this.samplesByGroups.clear();
        REFERENCE_GROUP_SAMPLE_MAP = new LinkedHashMap();
        for (String sample : this.allSamples) {
            String sampleGroup = manager.getAttribute(sample, groupByAttributeId);
            List<String> sampleList = this.samplesByGroups.get(sampleGroup);
            if (sampleList == null) {
                sampleList = new ArrayList<String>();
                this.samplesByGroups.put(sampleGroup, sampleList);
            }
            sampleList.add(sample);
            REFERENCE_GROUP_SAMPLE_MAP.put(sampleGroup, sampleList);
        }
        this.previousGroupId = groupByAttributeId;
        this.initGroups();
    }

    private void initGroups() {
        this.grouped = this.samplesByGroups.size() > 1;
        boolean bl = this.hasGroups = this.samplesByGroups.size() > 1;
        if (this.grouped && REFERENCE_GROUP_SAMPLE_MAP != null) {
            this.sortGroups();
        }
    }

    private void sortGroups() {
        final HashMap<String, Integer> groupRank = new HashMap<String, Integer>();
        int idx = 0;
        for (String family : REFERENCE_GROUP_SAMPLE_MAP.keySet()) {
            groupRank.put(family, idx++);
        }
        this.groupNames = new ArrayList<String>(this.samplesByGroups.keySet());
        Collections.sort(this.groupNames, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int r1 = groupRank.containsKey(s1) ? (Integer)groupRank.get(s1) : Integer.MAX_VALUE;
                int r2 = groupRank.containsKey(s2) ? (Integer)groupRank.get(s2) : Integer.MAX_VALUE;
                return r1 - r2;
            }
        });
        LinkedHashMap<String, List<String>> newSamples = new LinkedHashMap<String, List<String>>();
        for (String family : this.groupNames) {
            List<String> sampleList = this.samplesByGroups.get(family);
            if (sampleList == null || sampleList.size() <= 0) continue;
            List<String> referenceGroup = REFERENCE_GROUP_SAMPLE_MAP.get(family);
            if (referenceGroup != null) {
                final HashMap<String, Integer> rank = new HashMap<String, Integer>();
                for (int i2 = 0; i2 < referenceGroup.size(); ++i2) {
                    rank.put(referenceGroup.get(i2), i2);
                    Collections.sort(sampleList, new Comparator<String>(){

                        @Override
                        public int compare(String s1, String s2) {
                            int r1 = rank.containsKey(s1) ? (Integer)rank.get(s1) : Integer.MAX_VALUE;
                            int r2 = rank.containsKey(s2) ? (Integer)rank.get(s2) : Integer.MAX_VALUE;
                            return r1 - r2;
                        }
                    });
                }
            }
            newSamples.put(family, sampleList);
        }
        this.samplesByGroups = newSamples;
    }

    public int getGenotypeBandHeight() {
        switch (this.getDisplayMode()) {
            case SQUISHED: {
                return this.getSquishedHeight();
            }
            case COLLAPSED: {
                return 0;
            }
        }
        return 15;
    }

    @Override
    public int getHeight() {
        int groupCount = this.samplesByGroups.size();
        if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED || groupCount == 0) {
            return this.variantBandHeight;
        }
        int margins = (groupCount - 1) * 3;
        return this.variantBandHeight + margins + this.sampleCount * this.getGenotypeBandHeight();
    }

    @Override
    public int getPreferredHeight() {
        return this.getHeight();
    }

    @Override
    public void setHeight(int height) {
        Track.DisplayMode displayMode = this.getDisplayMode();
        if (displayMode == Track.DisplayMode.COLLAPSED) {
            return;
        }
        int groupCount = this.samplesByGroups.size();
        int margins = (groupCount - 1) * 3;
        int expandedHeight = this.variantBandHeight + margins + this.sampleCount * this.getGenotypeBandHeight();
        if (height < expandedHeight) {
            this.setDisplayMode(Track.DisplayMode.SQUISHED);
            this.squishedHeight = Math.max(1, (height - this.variantBandHeight - margins) / this.sampleCount);
        } else if (displayMode != Track.DisplayMode.EXPANDED) {
            this.setDisplayMode(Track.DisplayMode.EXPANDED);
        }
    }

    @Override
    public void setDisplayMode(Track.DisplayMode mode) {
        super.setDisplayMode(mode);
    }

    @Override
    protected void renderFeatureImpl(RenderContext context, Rectangle trackRectangle, PackedFeatures packedFeatures) {
        int bottomY;
        int variantBandY;
        List features;
        Graphics2D g2D = context.getGraphics();
        this.top = trackRectangle.y;
        int left = trackRectangle.x;
        int right = (int)trackRectangle.getMaxX();
        Rectangle visibleRectangle = context.getVisibleRect();
        Rectangle rect = new Rectangle(trackRectangle);
        rect.height = this.getGenotypeBandHeight();
        rect.y = trackRectangle.y + this.variantBandHeight;
        this.colorBackground(g2D, rect, visibleRectangle, false);
        if (this.top > visibleRectangle.y && (double)this.top < visibleRectangle.getMaxY()) {
            g2D.drawLine(left, this.top + 1, right, this.top + 1);
        }
        if ((features = packedFeatures.getFeatures()).size() > 0) {
            double locScale = context.getScale();
            double origin = context.getOrigin();
            int lastPX = -1;
            double pXMin = rect.getMinX();
            double pXMax = rect.getMaxX();
            for (Feature feature : features) {
                boolean isSelected;
                int end;
                int dX;
                int start;
                int pX;
                VariantContext variant = (VariantContext)feature;
                if (this.hideFiltered && variant.isFiltered() || (double)((pX = (int)(((double)(start = variant.getStart() - 1) - origin) / locScale)) + (dX = (int)Math.max(2.0, (double)((end = variant.getEnd()) - start) / locScale))) < pXMin) continue;
                if ((double)pX > pXMax) break;
                int w = dX;
                int x = pX;
                if (w < 3) {
                    w = 3;
                    --x;
                }
                if (pX + dX <= lastPX) continue;
                rect.y = this.top;
                rect.height = this.variantBandHeight;
                if (rect.intersects(visibleRectangle)) {
                    this.renderer.renderVariantBand(variant, rect, x, w, context, this.hideFiltered);
                }
                if (this.getDisplayMode() != Track.DisplayMode.COLLAPSED) {
                    rect.y += rect.height;
                    rect.height = this.getGenotypeBandHeight();
                    if (this.grouped) {
                        for (Map.Entry<String, List<String>> entry : this.samplesByGroups.entrySet()) {
                            for (String sample : entry.getValue()) {
                                if (rect.intersects(visibleRectangle)) {
                                    this.renderer.renderGenotypeBandSNP(variant, context, rect, x, w, sample, this.coloring, this.hideFiltered);
                                }
                                rect.y += rect.height;
                            }
                            g2D.setColor(OFF_WHITE);
                            g2D.fillRect(rect.x, rect.y, rect.width, 3);
                            rect.y += 3;
                        }
                    } else {
                        for (String sample : this.allSamples) {
                            if (rect.intersects(visibleRectangle)) {
                                this.renderer.renderGenotypeBandSNP(variant, context, rect, x, w, sample, this.coloring, this.hideFiltered);
                            }
                            rect.y += rect.height;
                        }
                    }
                }
                boolean bl = isSelected = this.selectedVariant != null && this.selectedVariant == variant;
                if (isSelected) {
                    Graphics2D selectionGraphics = context.getGraphic2DForColor(Color.black);
                    selectionGraphics.drawRect(x, this.top, w, this.getHeight());
                }
                lastPX = pX + dX;
            }
        } else {
            rect.height = this.variantBandHeight;
            rect.y = trackRectangle.y;
            g2D.setColor(Color.gray);
            GraphicUtils.drawCenteredText("No Variants Found", trackRectangle, g2D);
        }
        if (this.allSamples.size() > 0 && (variantBandY = trackRectangle.y + this.variantBandHeight) >= visibleRectangle.y && (double)variantBandY <= visibleRectangle.getMaxY()) {
            Graphics2D borderGraphics = context.getGraphic2DForColor(Color.black);
            borderGraphics.drawLine(left, variantBandY, right, variantBandY);
        }
        if ((bottomY = trackRectangle.y + trackRectangle.height) >= visibleRectangle.y && (double)bottomY <= visibleRectangle.getMaxY()) {
            g2D.drawLine(left, bottomY, right, bottomY);
        }
    }

    @Override
    public void renderName(Graphics2D g2D, Rectangle trackRectangle, Rectangle visibleRectangle) {
        int variantBandY;
        int bottomY;
        int top = trackRectangle.y;
        int left = trackRectangle.x;
        int right = (int)trackRectangle.getMaxX();
        Rectangle rect = new Rectangle(trackRectangle);
        g2D.setFont(FontManager.getFont(this.fontSize));
        g2D.setColor(BAND2_COLOR);
        if (top > visibleRectangle.y && (double)top < visibleRectangle.getMaxY()) {
            g2D.drawLine(left, top + 1, right, top + 1);
        }
        g2D.setColor(Color.black);
        rect.height = this.variantBandHeight;
        if (rect.intersects(visibleRectangle)) {
            GraphicUtils.drawWrappedText(this.getName(), rect, g2D, false);
        }
        if (this.grouped) {
            g2D.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width, rect.y + rect.height - 1);
        }
        rect.y += rect.height;
        rect.height = this.getGenotypeBandHeight();
        if (this.getDisplayMode() != Track.DisplayMode.COLLAPSED) {
            this.colorBackground(g2D, rect, visibleRectangle, true);
        }
        if ((bottomY = trackRectangle.y + trackRectangle.height) >= visibleRectangle.y && (double)bottomY <= visibleRectangle.getMaxY()) {
            g2D.setColor(borderGray);
            g2D.drawLine(left, bottomY, right, bottomY);
        }
        if (this.allSamples.size() > 0 && (variantBandY = trackRectangle.y + this.variantBandHeight) >= visibleRectangle.y && (double)variantBandY <= visibleRectangle.getMaxY()) {
            g2D.setColor(Color.black);
            g2D.drawLine(left, variantBandY, right, variantBandY);
        }
    }

    private void colorBackground(Graphics2D g2D, Rectangle bandRectangle, Rectangle visibleRectangle, boolean renderNames) {
        if (this.getDisplayMode() == Track.DisplayMode.SQUISHED && this.squishedHeight < 4) {
            return;
        }
        boolean coloredLast = true;
        Rectangle textRectangle = new Rectangle(bandRectangle);
        --textRectangle.height;
        int bandFontSize = Math.min(this.fontSize, (int)bandRectangle.getHeight() - 1);
        Font font = FontManager.getFont(bandFontSize);
        Font oldFont = g2D.getFont();
        g2D.setFont(font);
        if (this.grouped) {
            for (List<String> sampleList : this.samplesByGroups.values()) {
                for (String sample : sampleList) {
                    if (coloredLast) {
                        g2D.setColor(BAND1_COLOR);
                        coloredLast = false;
                    } else {
                        g2D.setColor(BAND2_COLOR);
                        coloredLast = true;
                    }
                    if (bandRectangle.intersects(visibleRectangle)) {
                        g2D.fillRect(bandRectangle.x, bandRectangle.y, bandRectangle.width, bandRectangle.height);
                        if (renderNames && bandRectangle.height >= 3) {
                            String printName = sample;
                            textRectangle.y = bandRectangle.y + 1;
                            g2D.setColor(Color.black);
                            GraphicUtils.drawWrappedText(printName, bandRectangle, g2D, false);
                        }
                    }
                    bandRectangle.y += bandRectangle.height;
                }
                g2D.setColor(OFF_WHITE);
                g2D.fillRect(bandRectangle.x, bandRectangle.y, bandRectangle.width, 3);
                bandRectangle.y += 3;
            }
        } else {
            for (String sample : this.allSamples) {
                if (coloredLast) {
                    g2D.setColor(BAND1_COLOR);
                    coloredLast = false;
                } else {
                    g2D.setColor(BAND2_COLOR);
                    coloredLast = true;
                }
                if (bandRectangle.intersects(visibleRectangle)) {
                    g2D.fillRect(bandRectangle.x, bandRectangle.y, bandRectangle.width, bandRectangle.height);
                    if (renderNames && bandRectangle.height >= 3) {
                        String printName = sample;
                        textRectangle.y = bandRectangle.y + 1;
                        g2D.setColor(Color.black);
                        g2D.setFont(font);
                        GraphicUtils.drawWrappedText(printName, bandRectangle, g2D, false);
                    }
                }
                bandRectangle.y += bandRectangle.height;
            }
        }
        g2D.setFont(oldFont);
    }

    public void setRenderID(boolean value) {
        this.renderID = value;
    }

    public boolean getRenderID() {
        return this.renderID;
    }

    public void setHideAncestral(boolean value) {
        this.hideAncestral = value;
    }

    public boolean getHideFiltered() {
        return this.hideFiltered;
    }

    public void setHideFiltered(boolean value) {
        this.hideFiltered = value;
    }

    public boolean getHideAncestral() {
        return this.hideAncestral;
    }

    public ColorMode getColorMode() {
        return this.coloring;
    }

    public void setColorMode(ColorMode mode) {
        this.coloring = mode;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        VariantContext variant = (VariantContext)this.getFeatureAt(chr, position + 1.0, y, frame);
        if (variant != null) {
            if (y < this.top + this.variantBandHeight) {
                return this.getVariantToolTip(variant);
            }
            String sample = null;
            if (this.grouped) {
                int groupHeight = 3 * this.getGenotypeBandHeight() + 3;
                int groupNumber = Math.min(this.groupNames.size() - 1, (y - this.top - this.variantBandHeight) / groupHeight);
                String group = this.groupNames.get(groupNumber);
                List<String> sampleList = this.samplesByGroups.get(group);
                int sampleNumber = (y - this.top - this.variantBandHeight - groupNumber * groupHeight) / this.getGenotypeBandHeight();
                if (sampleNumber >= 0 && sampleNumber < sampleList.size()) {
                    sample = sampleList.get(sampleNumber);
                }
            } else {
                int sampleNumber = (y - this.top - this.variantBandHeight) / this.getGenotypeBandHeight();
                if (sampleNumber >= 0 && sampleNumber < this.allSamples.size()) {
                    sample = this.allSamples.get(sampleNumber);
                }
            }
            return this.getSampleToolTip(sample, variant);
        }
        return null;
    }

    private String getVariantToolTip(VariantContext variant) {
        String id = variant.getAttributeAsString("ID");
        StringBuffer toolTip = new StringBuffer();
        toolTip.append("Chr:" + variant.getChr());
        toolTip.append("<br>Position:" + variant.getStart());
        toolTip.append("<br>ID: " + id);
        toolTip.append("<br>Reference: " + variant.getReference().toString());
        Set<Allele> alternates = variant.getAlternateAlleles();
        if (alternates.size() > 0) {
            toolTip.append("<br>Alternate: " + alternates.toString());
        }
        toolTip.append("<br>Qual: " + this.numFormat.format(variant.getPhredScaledQual()));
        toolTip.append("<br>Type: " + (Object)((Object)variant.getType()));
        if (variant.isFiltered()) {
            toolTip.append("<br>Is Filtered Out: Yes</b>");
            toolTip = toolTip.append(this.getFilterTooltip(variant));
        } else {
            toolTip.append("<br>Is Filtered Out: No</b><br>");
        }
        toolTip.append("<br><b>Alleles:</b>");
        toolTip.append(this.getAlleleToolTip(this.getZygosityCounts(variant)));
        double af = this.getAlleleFreq(variant);
        if (af < 0.0 && variant.getSampleNames().size() > 0) {
            af = this.getAlleleFraction(variant);
        }
        toolTip.append("<br>Allele Frequency: " + (af >= 0.0 ? this.numFormat.format(af) : "Unknown") + "<br>");
        if (variant.getSampleNames().size() > 0) {
            double afrac = this.getAlleleFraction(variant);
            toolTip = toolTip.append("<br>Minor Allele Fraction: " + this.numFormat.format(afrac) + "<br>");
        }
        toolTip.append("<br><b>Genotypes:</b>");
        toolTip.append(this.getGenotypeToolTip(this.getZygosityCounts(variant)) + "<br>");
        toolTip.append(this.getVariantInfo(variant) + "<br>");
        return toolTip.toString();
    }

    protected String getVariantInfo(VariantContext variant) {
        Set<String> keys = variant.getAttributes().keySet();
        if (keys.size() > 0) {
            String toolTip = "<br><b>Variant Attributes</b>";
            int count = 0;
            String k2 = "AF";
            String afValue = variant.getAttributeAsString(k2);
            if (afValue != null && afValue.length() > 0 && !afValue.equals("null")) {
                toolTip = toolTip.concat("<br>" + VCFTrack.getFullName(k2) + ": " + variant.getAttributeAsString(k2));
            }
            if ((afValue = variant.getAttributeAsString(k2 = "GMAF")) != null && afValue.length() > 0 && !afValue.equals("null")) {
                toolTip = toolTip.concat("<br>" + VCFTrack.getFullName(k2) + ": " + variant.getAttributeAsString(k2));
            }
            for (String key : keys) {
                ++count;
                if (key.equals("AF") || key.equals("GMAF")) continue;
                if (count > 15) {
                    toolTip = toolTip.concat("<br>....");
                    break;
                }
                toolTip = toolTip.concat("<br>" + VCFTrack.getFullName(key) + ": " + variant.getAttributeAsString(key));
            }
            return toolTip;
        }
        return " ";
    }

    private String getSampleInfo(Genotype genotype) {
        Set<String> keys = genotype.getAttributes().keySet();
        if (keys.size() > 0) {
            String tooltip = "<br><b>Sample Attributes</b>";
            for (String key : keys) {
                try {
                    tooltip = tooltip.concat("<br>" + VCFTrack.getFullName(key) + ": " + genotype.getAttributeAsString(key));
                }
                catch (IllegalArgumentException iae) {
                    tooltip = tooltip.concat("<br>" + key + ": " + genotype.getAttributeAsString(key));
                }
            }
            return tooltip;
        }
        return null;
    }

    public void clearSelectedVariant() {
        this.selectedVariant = null;
    }

    public List<String> getAllSamples() {
        return this.allSamples;
    }

    public void setAllSamples(List<String> samples) {
        this.allSamples = samples;
    }

    public boolean isGrouped() {
        return this.grouped;
    }

    public void setGrouped(boolean grouped) {
        this.grouped = grouped;
    }

    public boolean isHasGroups() {
        return this.hasGroups;
    }

    public int getSquishedHeight() {
        return this.squishedHeight;
    }

    public void setSquishedHeight(int squishedHeight) {
        this.squishedHeight = squishedHeight;
    }

    static String getFullName(String key) {
        return fullNames.containsKey(key) ? fullNames.get(key) : key;
    }

    private String getSampleToolTip(String sample, VariantContext variant) {
        String id = variant.getAttributeAsString("ID");
        StringBuffer toolTip = new StringBuffer();
        toolTip = toolTip.append("Chr:" + variant.getChr());
        toolTip = toolTip.append("<br>Position:" + variant.getStart());
        toolTip = toolTip.append("<br>ID: " + id + "<br>");
        toolTip = toolTip.append("<br><b>Sample Information</b>");
        toolTip = toolTip.append("<br>Sample: " + sample);
        toolTip = toolTip.append("<br>Position:" + variant.getStart());
        Genotype genotype = variant.getGenotype(sample);
        if (genotype != null) {
            toolTip = toolTip.append("<br>Bases: " + genotype.getGenotypeString());
            toolTip = toolTip.append("<br>Quality: " + this.numFormat.format(genotype.getPhredScaledQual()));
            toolTip = toolTip.append("<br>Type: " + (Object)((Object)genotype.getType()));
        }
        if (variant.isFiltered()) {
            toolTip = toolTip.append("<br>Is Filtered Out: Yes</b>");
            toolTip = toolTip.append(this.getFilterTooltip(variant));
        } else {
            toolTip = toolTip.append("<br>Is Filtered Out: No</b><br>");
        }
        if (genotype != null) {
            toolTip = toolTip.append(this.getSampleInfo(genotype) + "<br>");
        }
        return toolTip.toString();
    }

    private String getFilterTooltip(VariantContext variant) {
        Set<String> filters = variant.getFilters();
        String toolTip = "<br>";
        for (String filter : filters) {
            toolTip = toolTip.concat("- " + filter + "<br>");
        }
        return toolTip;
    }

    public double getAlleleFreq(VariantContext variant) {
        double alleleFreq = Double.parseDouble(variant.getAttributeAsString("AF", "-1"));
        if (alleleFreq < 0.0) {
            alleleFreq = Double.parseDouble(variant.getAttributeAsString("GMAF", "-1"));
        }
        return alleleFreq;
    }

    public double getAlleleFraction(VariantContext variant) {
        ZygosityCount counts = this.getZygosityCounts(variant);
        int total = counts.getHomVar() + counts.getHet() + counts.getHomRef();
        return total == 0 ? -1.0 : ((double)counts.getHomVar() + (double)counts.getHet() / 2.0) / (double)total;
    }

    public double getAllelePercent(VariantContext variant) {
        double af = this.getAlleleFraction(variant);
        return af < 0.0 ? this.getAlleleFreq(variant) : af;
    }

    public ZygosityCount getZygosityCounts(VariantContext variant) {
        ZygosityCount zc = new ZygosityCount();
        for (String sample : this.allSamples) {
            Genotype genotype = variant.getGenotype(sample);
            zc.incrementCount(genotype);
        }
        return zc;
    }

    private String getAlleleToolTip(ZygosityCount counts) {
        double noCall = counts.getNoCall() * 2;
        double aNum = (counts.getHet() + counts.getHomRef() + counts.getHomVar()) * 2;
        double aCount = (counts.getHomVar() * 2 + counts.getHet()) * 2;
        String toolTip = "<br>No Call: " + (int)noCall;
        toolTip = toolTip.concat("<br>Allele Num: " + (int)aNum);
        toolTip = toolTip.concat("<br>Allele Count: " + (int)aCount);
        return toolTip;
    }

    private String getGenotypeToolTip(ZygosityCount counts) {
        int noCall = counts.getNoCall();
        int homRef = counts.getHomRef();
        int nonVar = noCall + homRef;
        int het = counts.getHet();
        int homVar = counts.getHomVar();
        int var = het + homVar;
        String toolTip = "<br>Non Variant: " + nonVar;
        toolTip = toolTip.concat("<br> - No Call: " + noCall);
        toolTip = toolTip.concat("<br> - Hom Ref: " + homRef);
        toolTip = toolTip.concat("<br>Variant: " + var);
        toolTip = toolTip.concat("<br> - Het: " + het);
        toolTip = toolTip.concat("<br> - Hom Var: " + homVar);
        return toolTip;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        VariantContext f2 = null;
        if (te.getFrame() != null && te.getFrame().getName() != null) {
            f2 = (VariantContext)this.getFeatureClosest(te.getChromosomePosition(), te.getMouseEvent().getY(), te.getFrame());
            this.selectedVariant = f2;
            IGV.getInstance().doRefresh();
        }
        return new VCFMenu(this, f2);
    }

    @Override
    public void refreshData(long timestamp) {
        super.refreshData(timestamp);
        this.setupGroupsFromAttributes();
    }

    public static void refresh() {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                IGV.getInstance().doRefresh();
            }
        });
    }

    @Override
    public Map<String, String> getPersistentState() {
        Map<String, String> attributes = super.getPersistentState();
        attributes.put(SessionReader.SessionAttribute.RENDER_NAME.getText(), String.valueOf(this.renderID));
        ColorMode mode = this.getColorMode();
        if (mode != null) {
            attributes.put(SessionReader.SessionAttribute.COLOR_MODE.getText(), mode.toString());
        }
        if (this.squishedHeight != 4) {
            attributes.put("SQUISHED_ROW_HEIGHT", String.valueOf(this.squishedHeight));
        }
        return attributes;
    }

    @Override
    public void restorePersistentState(Map<String, String> attributes) {
        String squishedHeightText;
        String colorModeText;
        super.restorePersistentState(attributes);
        String rendername = attributes.get(SessionReader.SessionAttribute.RENDER_NAME.getText());
        if (rendername != null) {
            this.setRenderID(rendername.equalsIgnoreCase("true"));
        }
        if ((colorModeText = attributes.get(SessionReader.SessionAttribute.COLOR_MODE.getText())) != null) {
            try {
                this.setColorMode(ColorMode.valueOf(colorModeText));
            }
            catch (Exception e2) {
                log.error("Error interpreting display mode: " + colorModeText);
            }
        }
        if ((squishedHeightText = attributes.get("SQUISHED_ROW_HEIGHT")) != null) {
            try {
                this.squishedHeight = Integer.parseInt(squishedHeightText);
            }
            catch (Exception e3) {
                log.error("Error restoring squished height: " + squishedHeightText);
            }
        }
    }

    static {
        borderGray = new Color(200, 200, 200);
        dash = new float[]{4.0f, 1.0f};
        fullNames = new HashMap<String, String>();
        fullNames.put("AA", "Ancestral Allele");
        fullNames.put("AC", "Allele Count in Genotypes");
        fullNames.put("AN", "Total Alleles in Genotypes");
        fullNames.put("AF", "Allele Frequency");
        fullNames.put("DP", "Depth");
        fullNames.put("MQ", "Mapping Quality");
        fullNames.put("NS", "Number of Samples with Data");
        fullNames.put("BQ", "RMS Base Quality");
        fullNames.put("SB", "Strand Bias");
        fullNames.put("DB", "dbSNP Membership");
        fullNames.put("GQ", "Genotype Quality");
        fullNames.put("GL", "Genotype Likelihoods");
    }

    static class ZygosityCount {
        private int homVar = 0;
        private int het = 0;
        private int homRef = 0;
        private int noCall = 0;

        ZygosityCount() {
        }

        public void incrementCount(Genotype genotype) {
            if (genotype != null) {
                if (genotype.isHomVar()) {
                    ++this.homVar;
                } else if (genotype.isHet()) {
                    ++this.het;
                } else if (genotype.isHomRef()) {
                    ++this.homRef;
                } else {
                    ++this.noCall;
                }
            }
        }

        public int getHomVar() {
            return this.homVar;
        }

        public int getHet() {
            return this.het;
        }

        public int getHomRef() {
            return this.homRef;
        }

        public int getNoCall() {
            return this.noCall;
        }

        public int getTotalCall() {
            return this.homVar + this.homRef + this.het;
        }

        public int getVarCall() {
            return this.homVar + this.het;
        }

        public int getSampleCount() {
            return this.homVar + this.homRef + this.het + this.noCall;
        }
    }

    public static enum ColorMode {
        GENOTYPE,
        METHYLATION_RATE,
        ALLELE;

    }
}

