/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.vcf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;
import org.broad.igv.util.ColorUtilities;
import org.broad.igv.vcf.VCFTrack;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class VCFRenderer {
    private static Logger log = Logger.getLogger(VCFRenderer.class);
    private static float alphaValue = 0.2f;
    public static Color colorHomRef = new Color(235, 235, 235);
    public static Color colorHomRefAlpha = ColorUtilities.getCompositeColor(colorHomRef.getColorComponents(null), alphaValue);
    public static Color colorHomVar = new Color(0, 245, 255);
    public static Color colorHomVarAlpha = ColorUtilities.getCompositeColor(colorHomVar.getColorComponents(null), alphaValue);
    public static Color colorHet = Color.blue.brighter();
    public static Color colorHetAlpha = ColorUtilities.getCompositeColor(colorHet.getColorComponents(null), alphaValue);
    public static Color colorNoCall = Color.white;
    public static Color colorNoCallAlpha = ColorUtilities.getCompositeColor(colorNoCall.getColorComponents(null), alphaValue);
    public static final Color colorAlleleBand = Color.red;
    public static Color colorAlleleBandAlpha = ColorUtilities.getCompositeColor(colorAlleleBand.getColorComponents(null), alphaValue);
    public static final Color colorAlleleRef = Color.gray;
    public static Color colorAlleleRefAlpha = ColorUtilities.getCompositeColor(colorAlleleRef.getColorComponents(null), alphaValue);
    private static final Color blue = new Color(0, 0, 220);
    public static Color blueAlpha = ColorUtilities.getCompositeColor(blue.getColorComponents(null), alphaValue);
    private static int variantWidth = 3;
    static Map<Character, Color> nucleotideColors = new HashMap<Character, Color>();
    private static final Color DARK_GREEN = new Color(30, 120, 30);
    private VCFTrack track;

    public VCFRenderer(VCFTrack track) {
        this.track = track;
    }

    public void renderVariantBand(VariantContext variant, Rectangle bandRectangle, int pX0, int dX, RenderContext context, boolean hideFiltered) {
        Color refColor;
        int remainderHeight;
        int alleleBarHeight;
        boolean bottomMargin = false;
        int topMargin = 3;
        int bottomY = bandRectangle.y + bandRectangle.height - 0;
        int barHeight = bandRectangle.height - 3 - 0;
        boolean filtered = variant.isFiltered();
        Color alleleColor = filtered ? colorAlleleBandAlpha : colorAlleleBand;
        double allelePercent = Math.min(1.0, this.track.getAllelePercent(variant));
        if (allelePercent <= 0.0) {
            alleleBarHeight = 0;
            remainderHeight = barHeight;
            refColor = filtered ? colorAlleleRefAlpha : colorAlleleRef;
        } else {
            alleleBarHeight = (int)(allelePercent * (double)barHeight);
            remainderHeight = barHeight - alleleBarHeight;
            refColor = filtered ? blueAlpha : blue;
        }
        Graphics2D g2 = context.getGraphic2DForColor(alleleColor);
        g2.fillRect(pX0, bottomY - alleleBarHeight, dX, alleleBarHeight);
        g2 = context.getGraphic2DForColor(refColor);
        g2.fillRect(pX0, bottomY - alleleBarHeight - remainderHeight, dX, remainderHeight);
    }

    public void renderGenotypeBandSNP(VariantContext variant, RenderContext context, Rectangle bandRectangle, int pX0, int dX, String sampleName, VCFTrack.ColorMode coloring, boolean hideFiltered) {
        int pY = (int)bandRectangle.getY();
        int dY = (int)bandRectangle.getHeight();
        int tOffset = 6;
        int bOffset = 8;
        Graphics2D g2 = (Graphics2D)context.getGraphics().create();
        if (dX >= 10) {
            Font f2;
            if (dY > 24) {
                f2 = FontManager.getFont(1, Math.min(dX, 12));
                g2.setFont(f2);
            } else if (dY > 18) {
                f2 = FontManager.getFont(1, Math.min(dX, 8));
                tOffset = 4;
                bOffset = 5;
                g2.setFont(f2);
            }
        }
        boolean isFiltered = variant.isFiltered() && hideFiltered;
        Genotype genotype = variant.getGenotype(sampleName);
        if (genotype == null) {
            log.error("Now what?");
        } else {
            Color b1Color = Color.gray;
            Color b2Color = Color.gray;
            char b1 = ' ';
            char b2 = ' ';
            switch (coloring) {
                case GENOTYPE: {
                    b2Color = b1Color = this.getGenotypeColor(genotype, isFiltered);
                    break;
                }
                case ALLELE: {
                    List<Allele> alleleList = genotype.getAlleles();
                    if (alleleList.size() > 0) {
                        b1 = this.getFirstBase(alleleList.get(0));
                        b1Color = nucleotideColors.get(Character.valueOf(b1));
                    }
                    if (alleleList.size() <= 1) break;
                    b2 = this.getFirstBase(alleleList.get(1));
                    b2Color = nucleotideColors.get(Character.valueOf(b2));
                    break;
                }
                case METHYLATION_RATE: {
                    Double goodBaseCount = genotype.getAttributeAsDoubleNoException("GB");
                    Double value = genotype.getAttributeAsDoubleNoException("MR");
                    if (goodBaseCount < 10.0 || value == null) {
                        b2Color = b1Color = colorNoCall;
                        break;
                    }
                    float mr = (float)value.doubleValue();
                    b2Color = b1Color = this.convertMethylationRateToColor(mr /= 100.0f);
                    break;
                }
                default: {
                    b2Color = b1Color = colorNoCall;
                }
            }
            int y0 = this.track.getDisplayMode() == Track.DisplayMode.EXPANDED ? pY + 1 : pY;
            int h2 = Math.max(1, this.track.getDisplayMode() == Track.DisplayMode.EXPANDED ? dY - 2 : dY);
            if (coloring == VCFTrack.ColorMode.GENOTYPE) {
                g2.setColor(b1Color);
                g2.fillRect(pX0, y0, dX, h2);
            } else {
                g2.setColor(b1Color);
                g2.fillRect(pX0, y0, dX / 2, h2);
                g2.setColor(b2Color);
                g2.fillRect(pX0 + dX / 2, y0, dX / 2, h2);
            }
            if (dX >= 10 && dY >= 18) {
                if (b1Color == Color.blue) {
                    g2.setColor(Color.white);
                } else {
                    g2.setColor(Color.black);
                }
                this.drawCenteredText(g2, new char[]{b1}, pX0, pY - tOffset, dX, dY);
                this.drawCenteredText(g2, new char[]{b2}, pX0, pY + dY / 2 - bOffset, dX, dY);
            }
        }
    }

    private Color convertMethylationRateToColor(float mr) {
        if ((double)mr >= 0.25) {
            return Color.getHSBColor((mr - 0.25f) * 1.3333334f, 1.0f, 1.0f);
        }
        return new Color(1.0f - mr, 1.0f - mr, 1.0f - mr);
    }

    public char getFirstBase(Allele allele) {
        byte[] bases = allele.getBases();
        if (bases.length > 0) {
            return (char)bases[0];
        }
        return '.';
    }

    public Color getGenotypeColor(Genotype genotype, boolean isFiltered) {
        if (genotype.isNoCall()) {
            return isFiltered ? colorNoCallAlpha : colorNoCall;
        }
        if (genotype.isHomRef()) {
            return isFiltered ? colorHomRefAlpha : colorHomRef;
        }
        if (genotype.isHomVar()) {
            return isFiltered ? colorHomVarAlpha : colorHomVar;
        }
        if (genotype.isHet()) {
            return isFiltered ? colorHetAlpha : colorHet;
        }
        return Color.white;
    }

    private void drawCenteredText(Graphics2D g2, char[] chars, int x, int y, int w, int h2) {
        FontMetrics fm = g2.getFontMetrics();
        int msg_width = fm.charsWidth(chars, 0, 1);
        int ascent = fm.getMaxAscent();
        int descent = fm.getMaxDescent();
        int msgX = x + w / 2 - msg_width / 2;
        int msgY = y + h2 / 2 - descent / 2 + ascent / 2;
        g2.drawChars(chars, 0, 1, msgX, msgY);
    }

    static {
        nucleotideColors.put(Character.valueOf('A'), Color.GREEN);
        nucleotideColors.put(Character.valueOf('a'), Color.GREEN);
        nucleotideColors.put(Character.valueOf('C'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('c'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('T'), Color.RED);
        nucleotideColors.put(Character.valueOf('t'), Color.RED);
        nucleotideColors.put(Character.valueOf('G'), new Color(242, 182, 65));
        nucleotideColors.put(Character.valueOf('g'), new Color(242, 182, 65));
        nucleotideColors.put(Character.valueOf('N'), colorAlleleRef);
        nucleotideColors.put(Character.valueOf('n'), colorAlleleRef);
        nucleotideColors.put(Character.valueOf('.'), colorAlleleRef);
        nucleotideColors.put(null, Color.BLACK);
    }
}

