/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.vcf;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.vcf.VCFTrack;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class VCFMenu
extends IGVPopupMenu {
    private static Logger log = Logger.getLogger(VCFMenu.class);
    private VCFTrack track;
    Map<String, Genotype> sampleGenotypes;
    List<String> samples;
    static boolean depthSortingDirection;
    static boolean genotypeSortingDirection;
    static boolean sampleSortingDirection;
    static boolean qualitySortingDirection;

    public VCFMenu(VCFTrack vcfTrack, VariantContext variant) {
        JMenuItem item2;
        this.track = vcfTrack;
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                this.close();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                this.close();
            }

            private void close() {
                VCFMenu.this.track.clearSelectedVariant();
            }
        });
        this.samples = this.track.getAllSamples();
        if (this.samples != null && variant != null) {
            this.sampleGenotypes = new HashMap<String, Genotype>();
            for (String sample : this.samples) {
                Genotype genotype = variant.getGenotype(sample);
                if (genotype == null) continue;
                this.sampleGenotypes.put(sample, genotype);
            }
        }
        JLabel popupTitle = new JLabel("<html><b>" + this.track.getName(), 2);
        Font newFont = this.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        this.add(popupTitle);
        this.addSeparator();
        List<Track> selectedTracks = Arrays.asList(vcfTrack);
        this.add(TrackMenuUtils.getTrackRenameItem(selectedTracks));
        this.add(TrackMenuUtils.getChangeFontSizeItem(selectedTracks));
        this.addSeparator();
        JLabel colorByItem = new JLabel("<html>&nbsp;&nbsp;<b>Color By", 2);
        this.add(colorByItem);
        this.add(this.getColorByGenotype());
        this.add(this.getColorByAllele());
        if (this.track.isEnableMethylationRateSupport()) {
            this.add(this.getColorByMethylationRate());
        }
        if (this.track.isHasGroups()) {
            this.addSeparator();
            final JCheckBoxMenuItem groupedItem = new JCheckBoxMenuItem("Group");
            groupedItem.setSelected(this.track.isGrouped());
            groupedItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VCFMenu.this.track.setGrouped(groupedItem.isSelected());
                    IGV.getInstance().doRefresh();
                }
            });
            this.add(groupedItem);
            this.addSeparator();
        }
        this.addSeparator();
        for (JMenuItem item2 : this.getSortMenuItems(variant)) {
            this.add(item2);
            if (variant == null) {
                item2.setEnabled(false);
            }
            item2.setEnabled(!this.track.isGrouped());
        }
        this.addSeparator();
        JLabel displayHeading = new JLabel("Display Mode", 2);
        this.add(displayHeading);
        for (JMenuItem item3 : this.getDisplayModeItems()) {
            this.add(item3);
        }
        this.addSeparator();
        item2 = new JMenuItem("Change Squished Row Height...");
        item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int currentValue = VCFMenu.this.track.getSquishedHeight();
                int newValue = TrackMenuUtils.getIntValue("Squished row height", currentValue);
                if (newValue != Integer.MIN_VALUE) {
                    VCFMenu.this.track.setSquishedHeight(newValue);
                    IGV.getInstance().getContentPane().repaint();
                }
            }
        });
        this.add(item2);
        this.add(this.getHideFilteredItem());
        this.add(this.getFeatureVisibilityItem());
        this.addSeparator();
        this.add(TrackMenuUtils.getRemoveMenuItem(Arrays.asList(this.track)));
    }

    private JMenuItem getFeatureVisibilityItem() {
        JMenuItem item = new JMenuItem("Set Feature Visibility Window...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VCFMenu.this.changeVisibilityWindow();
                IGV.getInstance().getContentPane().repaint();
            }
        });
        return item;
    }

    private JMenuItem getColorByGenotype() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Genotype", this.track.getColorMode() == VCFTrack.ColorMode.GENOTYPE);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VCFMenu.this.track.setColorMode(VCFTrack.ColorMode.GENOTYPE);
                IGV.getInstance().getContentPane().repaint();
            }
        });
        return item;
    }

    private JMenuItem getColorByAllele() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Allele", this.track.getColorMode() == VCFTrack.ColorMode.ALLELE);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VCFMenu.this.track.setColorMode(VCFTrack.ColorMode.ALLELE);
                IGV.getInstance().getContentPane().repaint();
            }
        });
        return item;
    }

    private JMenuItem getColorByMethylationRate() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Methylation Rate", this.track.getColorMode() == VCFTrack.ColorMode.METHYLATION_RATE);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VCFMenu.this.track.setColorMode(VCFTrack.ColorMode.METHYLATION_RATE);
                IGV.getInstance().getContentPane().repaint();
            }
        });
        return item;
    }

    private JMenuItem getHideFilteredItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Suppress Filtered Sites", this.track.getHideFiltered());
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VCFMenu.this.track.setHideFiltered(!VCFMenu.this.track.getHideFiltered());
                IGV.getInstance().getContentPane().repaint();
            }
        });
        return item;
    }

    private JMenuItem getHideAncestralItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Suppress Ancestral Genotypes", this.track.getHideAncestral());
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VCFMenu.this.track.setHideAncestral(!VCFMenu.this.track.getHideAncestral());
                IGV.getInstance().getContentPane().repaint();
            }
        });
        return item;
    }

    public JMenuItem getGenotypeSortItem(VariantContext variant) {
        JMenuItem item = new JMenuItem("Sort By Genotype");
        try {
            variant.getAlleles();
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GenotypeComparator compare = new GenotypeComparator();
                    genotypeSortingDirection = !genotypeSortingDirection;
                    VCFMenu.this.sortSamples(compare);
                    IGV.getInstance().getContentPane().repaint();
                }
            });
        }
        catch (Exception e2) {
            item.setEnabled(false);
        }
        return item;
    }

    public JMenuItem getSampleNameSortItem(VariantContext variant) {
        JMenuItem item = new JMenuItem("Sort By Sample Name");
        try {
            variant.getAlleles();
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Comparator<String> compare = new Comparator<String>(){

                        @Override
                        public int compare(String o2, String o1) {
                            if (sampleSortingDirection) {
                                return o2.compareTo(o1);
                            }
                            return o1.compareTo(o2);
                        }
                    };
                    sampleSortingDirection = !sampleSortingDirection;
                    VCFMenu.this.sortSamples(compare);
                    IGV.getInstance().getContentPane().repaint();
                }
            });
        }
        catch (Exception e2) {
            item.setEnabled(false);
        }
        return item;
    }

    public JMenuItem getDepthSortItem(VariantContext variant) {
        JMenuItem item = new JMenuItem("Sort By Depth");
        try {
            String variantDepth = variant.getAttributeAsString("DP");
            int depth = Integer.valueOf(variantDepth);
            if (depth > -1) {
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        DepthComparator compare = new DepthComparator();
                        depthSortingDirection = !depthSortingDirection;
                        VCFMenu.this.sortSamples(compare);
                        IGV.getInstance().getContentPane().repaint();
                    }
                });
                return item;
            }
        }
        catch (Exception e2) {
            item.setEnabled(false);
        }
        return item;
    }

    public JMenuItem getQualitySortItem(VariantContext variant) {
        JMenuItem item = new JMenuItem("Sort By Quality");
        try {
            double quality = variant.getPhredScaledQual();
            if (quality > -1.0) {
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        QualityComparator compare = new QualityComparator();
                        qualitySortingDirection = !qualitySortingDirection;
                        VCFMenu.this.sortSamples(compare);
                        IGV.getInstance().getContentPane().repaint();
                    }
                });
            }
        }
        catch (Exception e2) {
            item.setEnabled(false);
        }
        return item;
    }

    public void changeVisibilityWindow() {
        int value = VCFMenu.getIntValue("Visibility Window", this.track.getVisibilityWindow());
        if (value > 0) {
            this.track.setVisibilityWindow(value);
        }
    }

    private static int getIntValue(String parameter, int value) {
        String height;
        while ((height = JOptionPane.showInputDialog(IGV.getMainFrame(), parameter + ": ", String.valueOf(value))) != null && !height.trim().equals("")) {
            try {
                value = Integer.parseInt(height);
                return value;
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(IGV.getMainFrame(), parameter + " must be an integer number.");
                continue;
            }
            break;
        }
        return Integer.MIN_VALUE;
    }

    private void sortSamples(Comparator<String> compare) {
        try {
            if (this.sampleGenotypes.size() > 1) {
                Collections.sort(this.samples, compare);
                this.track.setAllSamples(this.samples);
            }
        }
        catch (Exception e2) {
            log.error(e2);
        }
    }

    public Collection<JMenuItem> getSortMenuItems(Feature closestFeature) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        VariantContext variant = (VariantContext)closestFeature;
        items.add(this.getGenotypeSortItem(variant));
        items.add(this.getSampleNameSortItem(variant));
        items.add(this.getDepthSortItem(variant));
        items.add(this.getQualitySortItem(variant));
        return items;
    }

    public List<JMenuItem> getDisplayModeItems() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        ButtonGroup group = new ButtonGroup();
        Track.DisplayMode displayMode = this.track.getDisplayMode();
        JRadioButtonMenuItem m1 = new JRadioButtonMenuItem("Collapsed");
        m1.setSelected(displayMode == Track.DisplayMode.COLLAPSED);
        m1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VCFMenu.this.track.setDisplayMode(Track.DisplayMode.COLLAPSED);
                IGV.getInstance().doRefresh();
            }
        });
        JRadioButtonMenuItem m2 = new JRadioButtonMenuItem("Squished");
        m2.setSelected(displayMode == Track.DisplayMode.SQUISHED);
        m2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VCFMenu.this.track.setDisplayMode(Track.DisplayMode.SQUISHED);
                IGV.getInstance().doRefresh();
            }
        });
        JRadioButtonMenuItem m3 = new JRadioButtonMenuItem("Expanded");
        m3.setSelected(displayMode == Track.DisplayMode.EXPANDED);
        m3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VCFMenu.this.track.setDisplayMode(Track.DisplayMode.EXPANDED);
                IGV.getInstance().doRefresh();
            }
        });
        items.add(m1);
        items.add(m2);
        items.add(m3);
        group.add(m1);
        group.add(m2);
        group.add(m3);
        return items;
    }

    class QualityComparator
    implements Comparator<String> {
        QualityComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            double qual1 = VCFMenu.this.sampleGenotypes.get(s1).getPhredScaledQual();
            double qual2 = VCFMenu.this.sampleGenotypes.get(s2).getPhredScaledQual();
            if (qual2 == qual1) {
                return 0;
            }
            if (qual2 < qual1) {
                return qualitySortingDirection ? -1 : 1;
            }
            return qualitySortingDirection ? 1 : 1;
        }
    }

    class DepthComparator
    implements Comparator<String> {
        DepthComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            double depth2;
            double depth1;
            String readDepth1 = VCFMenu.this.sampleGenotypes.get(s1).getAttributeAsString("DP");
            String readDepth2 = VCFMenu.this.sampleGenotypes.get(s2).getAttributeAsString("DP");
            try {
                depth1 = Double.valueOf(readDepth1);
            }
            catch (Exception e2) {
                depth1 = -1.0;
            }
            try {
                depth2 = Double.valueOf(readDepth2);
            }
            catch (Exception e3) {
                depth2 = -1.0;
            }
            if (depth2 == depth1) {
                return 0;
            }
            if (depth2 < depth1) {
                return depthSortingDirection ? -1 : 1;
            }
            return depthSortingDirection ? 1 : 1;
        }
    }

    class GenotypeComparator
    implements Comparator<String> {
        GenotypeComparator() {
        }

        @Override
        public int compare(String e1, String e2) {
            int genotype1 = this.classifyGenotype(VCFMenu.this.sampleGenotypes.get(e1));
            int genotype2 = this.classifyGenotype(VCFMenu.this.sampleGenotypes.get(e2));
            if (genotype2 == genotype1) {
                return 0;
            }
            if (genotype2 > genotype1) {
                return genotypeSortingDirection ? 1 : -1;
            }
            return genotypeSortingDirection ? -1 : 1;
        }

        private int classifyGenotype(Genotype genotype) {
            if (genotype.isNoCall()) {
                return genotypeSortingDirection ? 1 : 10;
            }
            if (genotype.isHomVar()) {
                return 4;
            }
            if (genotype.isHet()) {
                return 3;
            }
            if (genotype.isHomRef()) {
                return genotypeSortingDirection ? 2 : 9;
            }
            return -1;
        }
    }
}

