/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.broad.igv.util.IGVHttpClientUtils;
import org.broad.tribble.util.URLHelper;

public class ApacheURLHelper
implements URLHelper {
    URL url;

    public ApacheURLHelper(URL url) {
        this.url = url;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public long getContentLength() throws IOException {
        return IGVHttpClientUtils.getContentLength(this.url);
    }

    @Override
    public InputStream openInputStreamForRange(long start, long end) throws IOException {
        String byteRange = "bytes=" + start + "-" + end;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Range", byteRange);
        return IGVHttpClientUtils.executeGet(this.url, params).getEntity().getContent();
    }

    @Override
    public boolean exists() {
        return IGVHttpClientUtils.resourceAvailable(this.url);
    }
}

