/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.gs.GSUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.LoginDialog;
import org.broad.igv.util.Utilities;
import org.broad.igv.util.ftp.FTPClient;
import org.broad.igv.util.ftp.FTPStream;
import org.broad.igv.util.ftp.FTPUtils;
import org.broad.igv.util.stream.ApacheURLHelper;
import org.broad.tribble.util.SeekableHTTPStream;

public class IGVHttpClientUtils {
    private static Logger log = Logger.getLogger(IGVHttpClientUtils.class);
    public static boolean byteRangeTested = false;
    public static boolean useByteRange = true;
    private static DefaultHttpClient client = IGVHttpClientUtils.createClient();
    private static IdleConnectionMonitorThread monitorThread;

    public static DefaultHttpClient createClient() {
        try {
            ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager();
            cm.setMaxTotal(100);
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = IGVHttpClientUtils.getDefaultTrustManager();
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx);
            ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            SchemeRegistry sr = cm.getSchemeRegistry();
            sr.register(new Scheme("https", ssf, 443));
            monitorThread = new IdleConnectionMonitorThread(cm);
            monitorThread.start();
            return new DefaultHttpClient(cm);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static X509TrustManager getDefaultTrustManager() {
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        return tm;
    }

    public static void shutdown() {
        client.getConnectionManager().shutdown();
        monitorThread.shutdown();
    }

    public static InputStream openConnectionStream(URL url) throws IOException {
        if (url.getProtocol().toLowerCase().equals("ftp")) {
            String userInfo = url.getUserInfo();
            String host = url.getHost();
            String file = url.getPath();
            FTPClient ftp = FTPUtils.connect(host, userInfo);
            ftp.pasv();
            ftp.retr(file);
            return new FTPStream(ftp);
        }
        HttpGet getMethod = new HttpGet(url.toExternalForm());
        HttpResponse response = IGVHttpClientUtils.execute(getMethod, url);
        return new EntityStreamWrapper(response);
    }

    public static boolean resourceAvailable(URL url) {
        HttpHead headMethod = null;
        HttpResponse response = null;
        try {
            headMethod = new HttpHead(url.toExternalForm());
            response = IGVHttpClientUtils.execute(headMethod, url);
            int statusCode = response.getStatusLine().getStatusCode();
            EntityUtils.consume(response.getEntity());
            return statusCode == 200;
        }
        catch (FileNotFoundException e2) {
            return false;
        }
        catch (Exception e3) {
            log.error("Error checking resoruce availability", e3);
            return false;
        }
    }

    public static String getHeaderField(URL url, String key) throws IOException {
        HttpHead headMethod = new HttpHead(url.toExternalForm());
        HttpResponse response = IGVHttpClientUtils.execute(headMethod, url);
        String value = response.getFirstHeader(key).getValue();
        EntityUtils.consume(response.getEntity());
        return value;
    }

    public static HttpResponse executeGet(URL url) throws IOException {
        HttpGet get = new HttpGet(url.toExternalForm());
        return IGVHttpClientUtils.execute(get, url);
    }

    public static HttpResponse executeGet(URL url, Map<String, String> headers) throws IOException {
        HttpGet get = new HttpGet(url.toExternalForm());
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            get.setHeader(entry.getKey(), entry.getValue());
        }
        return IGVHttpClientUtils.execute(get, url);
    }

    private static HttpResponse execute(HttpRequestBase method, URL url) throws IOException {
        try {
            HttpResponse response;
            int statusCode;
            if (GSUtils.isGenomeSpace(url)) {
                GSUtils.checkForCookie(client, url);
            }
            if ((statusCode = (response = client.execute(method)).getStatusLine().getStatusCode()) == 401) {
                client.getCredentialsProvider().clear();
                IGVHttpClientUtils.login(url);
                return IGVHttpClientUtils.execute(method, url);
            }
            if (statusCode == 404 || statusCode == 410) {
                method.abort();
                throw new FileNotFoundException("Resource not found: " + url.toString());
            }
            if (statusCode == 407) {
                method.abort();
                throw new RuntimeException("Error connecting. Proxy authentication required.");
            }
            if (statusCode >= 400) {
                method.abort();
                throw new RuntimeException("Error connecting.  Status code = " + statusCode);
            }
            return response;
        }
        catch (RuntimeException e2) {
            if (method != null) {
                method.abort();
            }
            throw e2;
        }
    }

    private static void login(URL url) {
        Frame owner = IGV.hasInstance() ? IGV.getMainFrame() : null;
        String userpass = IGVHttpClientUtils.getUserPass(owner);
        if (userpass == null) {
            throw new RuntimeException("Access denied:  " + url.toString());
        }
        UsernamePasswordCredentials GENOME_SPACE_CREDS = new UsernamePasswordCredentials(userpass);
        String host = GSUtils.isGenomeSpace(url) ? "identitytest.genomespace.org" : url.getHost();
        client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM), GENOME_SPACE_CREDS);
        if (GSUtils.isGenomeSpace(url)) {
            try {
                HttpGet httpget = new HttpGet("https://identitytest.genomespace.org:8443/identityServer/basic");
                BasicResponseHandler responseHandler = new BasicResponseHandler();
                String responseBody = client.execute((HttpUriRequest)httpget, responseHandler);
                if (responseBody != null && responseBody.length() > 0) {
                    String[] tokens = userpass.split(":");
                    String user = tokens[0];
                    GSUtils.saveLoginForSSO(responseBody, user);
                }
            }
            catch (IOException e2) {
                log.error("Error fetching GS token", e2);
            }
        }
    }

    public static String getUserPass(Frame owner) {
        LoginDialog dlg = new LoginDialog(owner);
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return null;
        }
        String userString = dlg.getUsername();
        String userPass = new String(dlg.getPassword());
        return userString + ":" + userPass;
    }

    public static long getContentLength(URL url) {
        String contentLengthString = "";
        try {
            contentLengthString = IGVHttpClientUtils.getHeaderField(url, "Content-Length");
            return Long.parseLong(contentLengthString);
        }
        catch (IOException e2) {
            log.error("Error getting content length from: " + url.toString(), e2);
            return -1L;
        }
        catch (NumberFormatException e3) {
            log.error("Error getting content length from: " + url.toString() + "\n" + "Content-length=" + contentLengthString);
            return -1L;
        }
    }

    public static long getContentLength(HttpResponse response) {
        String contentLengthString = "";
        try {
            contentLengthString = response.getFirstHeader("Content-Length").getValue();
            return Long.parseLong(contentLengthString);
        }
        catch (NumberFormatException e2) {
            log.error("Error getting content length from: " + contentLengthString + "\n" + "Content-length=" + contentLengthString);
            return -1L;
        }
    }

    public static boolean isURL(String string) {
        String lcString = string.toLowerCase();
        return lcString.startsWith("http://") || lcString.startsWith("https://") || lcString.startsWith("ftp://") || lcString.startsWith("file://");
    }

    public static boolean testByteRange() {
        try {
            String testURL = "http://www.broadinstitute.org/igvdata/byteRangeTest.txt";
            byte[] expectedBytes = new byte[]{107, 108, 109, 110, 111};
            SeekableHTTPStream str = new SeekableHTTPStream(new ApacheURLHelper(new URL(testURL)));
            str.seek(10L);
            byte[] buffer = new byte[5];
            str.read(buffer, 0, 5);
            for (int i2 = 0; i2 < buffer.length; ++i2) {
                if (buffer[i2] == expectedBytes[i2]) continue;
                return false;
            }
            return true;
        }
        catch (IOException e2) {
            log.error("Error while testing byte range ", e2);
            return false;
        }
    }

    public static boolean useByteRange() {
        useByteRange = PreferenceManager.getInstance().getAsBoolean("UseHttpByteRange");
        if (useByteRange && !byteRangeTested) {
            useByteRange = IGVHttpClientUtils.testByteRange();
            byteRangeTested = true;
        }
        return useByteRange;
    }

    public static void updateProxySettings() {
        int proxyPort;
        String pw = null;
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        boolean useProxy = prefMgr.getAsBoolean("PROXY.USE");
        String proxyHost = prefMgr.get("PROXY.HOST", null);
        try {
            proxyPort = Integer.parseInt(prefMgr.get("PROXY.PORT", "-1"));
        }
        catch (NumberFormatException e2) {
            proxyPort = -1;
        }
        boolean auth = prefMgr.getAsBoolean("PROXY.AUTHENTICATE");
        String user = prefMgr.get("PROXY.USERNAME", null);
        String pwString = prefMgr.get("PROXY.PW", null);
        if (pwString != null) {
            pw = Utilities.base64Decode(pwString);
        }
        if (useProxy) {
            if (proxyHost != null) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                client.getParams().setParameter("http.route.default-proxy", proxy);
                log.info("Proxy settings: " + proxyHost + ":" + proxyPort);
            }
            if (auth && pw != null) {
                client.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), new UsernamePasswordCredentials(user, pw));
            }
        } else {
            client.getParams().removeParameter("http.route.default-proxy");
        }
    }

    public static boolean downloadFile(String url, File outputFile) throws IOException {
        log.info("Downloading " + url + " to " + outputFile.getAbsolutePath());
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = client.execute(httpget);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            long contentLength = entity.getContentLength();
            log.info("Content length = " + contentLength);
            InputStream is = null;
            FileOutputStream out = null;
            try {
                is = entity.getContent();
                out = new FileOutputStream(outputFile);
                byte[] buf = new byte[65536];
                int downloaded = 0;
                int bytesRead = 0;
                while ((bytesRead = is.read(buf)) != -1) {
                    ((OutputStream)out).write(buf, 0, bytesRead);
                    downloaded += bytesRead;
                }
                log.info("Download complete.  Total bytes downloaded = " + downloaded);
            }
            catch (IOException e2) {
                httpget.abort();
                throw e2;
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (out != null) {
                    out.flush();
                    ((OutputStream)out).close();
                }
            }
            long fileLength = outputFile.length();
            log.info("File length = " + fileLength);
            return contentLength <= 0L || contentLength == fileLength;
        }
        return false;
    }

    static {
        client.getParams().setParameter("http.protocol.allow-circular-redirects", true);
        client.getParams().setParameter("http.useragent", Globals.applicationString());
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final ClientConnectionManager connMgr;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(ClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(60000L);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(300L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }

    public static class EntityStreamWrapper
    extends FilterInputStream {
        HttpResponse response;

        public EntityStreamWrapper(HttpResponse response) throws IOException {
            super(response.getEntity().getContent());
            this.response = response;
        }

        @Override
        public void close() throws IOException {
            EntityUtils.consume(this.response.getEntity());
            super.close();
        }
    }
}

