/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import jargs.gnu.CmdLineParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.broad.igv.Globals;
import org.broad.igv.feature.GFFParser;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.sam.reader.AlignmentIndexer;
import org.broad.igv.tdf.TDFUtils;
import org.broad.igv.tools.IgvToolsGui;
import org.broad.igv.tools.LaneCounter;
import org.broad.igv.tools.PreprocessingException;
import org.broad.igv.tools.Preprocessor;
import org.broad.igv.tools.UCSCUtils;
import org.broad.igv.tools.WigSummer;
import org.broad.igv.tools.WigToBed;
import org.broad.igv.tools.converters.ExpressionFormatter;
import org.broad.igv.tools.converters.GCTtoIGVConverter;
import org.broad.igv.tools.sort.Sorter;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.vcf.VCFtoBed;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.TribbleException;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.util.LittleEndianOutputStream;

public class IgvTools {
    static String version = "@VERSION";
    static String[] commandDocs = new String[]{"version print the version number", "sort    sort an alignment file by start position", "index   index an alignment file", "toTDF    convert an input file (cn, gct, wig) to tiled data format (tdf)", "count   compute coverage density for an alignment file"};
    public static final int MAX_RECORDS_IN_RAM = 500000;
    public static final int MAX_ZOOM = 7;
    public static final int WINDOW_SIZE = 25;
    public static final int EXT_FACTOR = 0;
    public static final Object PROBE_FILE = null;
    public static final int LINEAR_BIN_SIZE = 16000;
    public static final int INTERVAL_SIZE = 1000;
    public static final int LINEAR_INDEX = 1;
    public static final int INTERVAL_INDEX = 2;

    static String usageString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\nProgram: igvtools\n\n");
        buf.append("Usage: igvtools [command] [options] [arguments]\n\n");
        buf.append("Command:");
        for (String c2 : commandDocs) {
            buf.append(" " + c2 + "\n\t");
        }
        return buf.toString();
    }

    public static void main(String[] argv) throws IOException, PreprocessingException {
        RollingFileAppender appender = new RollingFileAppender();
        PatternLayout layout = new PatternLayout();
        layout.setConversionPattern("%p [%d{ISO8601}] [%F:%L]  %m%n");
        appender.setName("R");
        appender.setFile("igv.log");
        appender.setThreshold(Level.ALL);
        appender.setMaxFileSize("10KB");
        appender.setMaxBackupIndex(1);
        appender.setAppend(true);
        appender.activateOptions();
        appender.setLayout(layout);
        Logger.getRootLogger().addAppender(appender);
        Globals.setHeadless(true);
        new IgvTools().run(argv);
        System.out.println("Done");
        System.exit(1);
    }

    private void run(String[] argv) {
        block28: {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
            CmdLineParser.Option guiOption = parser.addBooleanOption('g', "gui");
            CmdLineParser.Option windowFunctions = parser.addStringOption('f', "windowFunctions");
            CmdLineParser.Option tmpDirOption = parser.addStringOption('t', "tmpDir");
            CmdLineParser.Option maxZoomOption = parser.addIntegerOption('z', "maxZoom");
            CmdLineParser.Option maxRecordsOption = parser.addIntegerOption('m', "maxRecords");
            CmdLineParser.Option probeFileOption = parser.addStringOption('p', "probeFile");
            CmdLineParser.Option windowSizeOption = parser.addIntegerOption('w', "windowSize");
            CmdLineParser.Option extFactorOption = parser.addIntegerOption('e', "extFactor");
            CmdLineParser.Option indexTypeOption = parser.addIntegerOption('i', "indexType");
            CmdLineParser.Option binSizeOption = parser.addIntegerOption('b', "binSize");
            CmdLineParser.Option outputDirOption = parser.addStringOption('o', "outputDir");
            CmdLineParser.Option coverageOptions = parser.addStringOption('a', "coverageOptions");
            CmdLineParser.Option colorOption = parser.addStringOption('c', "color");
            try {
                parser.parse(argv);
            }
            catch (CmdLineParser.OptionException e2) {
                System.err.println(e2.getMessage());
                return;
            }
            boolean help = (Boolean)parser.getOptionValue(helpOption, false);
            if (argv.length < 1 || help) {
                System.out.println(IgvTools.usageString());
                return;
            }
            boolean gui = (Boolean)parser.getOptionValue(guiOption, false);
            if (gui) {
                IgvTools.launchGUI();
                Runtime.getRuntime().halt(0);
            }
            String tmpDirName = (String)parser.getOptionValue(tmpDirOption);
            String[] nonOptionArgs = parser.getRemainingArgs();
            try {
                boolean isList;
                this.validateArgsLength(nonOptionArgs, 1);
                String command = nonOptionArgs[0].toLowerCase();
                if (command.equals("version")) {
                    System.out.println("Version " + version);
                    return;
                }
                this.validateArgsLength(nonOptionArgs, 2);
                String ifile = nonOptionArgs[1];
                boolean bl = isList = ifile.indexOf(",") > 0;
                if (!isList && !FileUtils.resourceExists(ifile)) {
                    throw new PreprocessingException("File not found: " + ifile);
                }
                int maxRecords = (Integer)parser.getOptionValue(maxRecordsOption, 500000);
                if (command.equals("count") || command.equals("totdf") || command.equals("tile")) {
                    this.validateArgsLength(nonOptionArgs, 4);
                    int windowSizeValue = (Integer)parser.getOptionValue(windowSizeOption, 25);
                    int maxZoomValue = (Integer)parser.getOptionValue(maxZoomOption, 7);
                    String ofile = nonOptionArgs[2];
                    String genomeId = nonOptionArgs[3];
                    boolean isGCT = Preprocessor.getExtension(ifile).endsWith("gct");
                    String wfsString = (String)parser.getOptionValue(windowFunctions);
                    Collection<WindowFunction> wfList = IgvTools.parseWFS(wfsString, isGCT);
                    String coverageOpt = (String)parser.getOptionValue(coverageOptions);
                    String trackLine = null;
                    String color = (String)parser.getOptionValue(colorOption);
                    if (color != null) {
                        trackLine = "track color=\"" + color + "\"";
                    }
                    if (command.equals("count")) {
                        int extFactorValue = (Integer)parser.getOptionValue(extFactorOption, 0);
                        this.doCount(ifile, ofile, genomeId, maxZoomValue, wfList, windowSizeValue, extFactorValue, coverageOpt, trackLine);
                    } else {
                        String probeFile = (String)parser.getOptionValue(probeFileOption, PROBE_FILE);
                        this.toTDF(ifile, ofile, probeFile, genomeId, maxZoomValue, wfList, tmpDirName, maxRecords);
                    }
                    break block28;
                }
                if (command.toLowerCase().equals("sort")) {
                    this.validateArgsLength(nonOptionArgs, 3);
                    String ofile = nonOptionArgs[2];
                    this.doSort(ifile, ofile, tmpDirName, maxRecords);
                    break block28;
                }
                if (command.equals("index")) {
                    int indexType = (Integer)parser.getOptionValue(indexTypeOption, 1);
                    int defaultBinSize = indexType == 1 ? 16000 : 1000;
                    int binSize = (Integer)parser.getOptionValue(binSizeOption, defaultBinSize);
                    String outputDir = (String)parser.getOptionValue(outputDirOption, null);
                    this.doIndex(ifile, outputDir, indexType, binSize);
                    break block28;
                }
                if (command.equals("wibtowig")) {
                    this.validateArgsLength(nonOptionArgs, 4);
                    File txtFile = new File(nonOptionArgs[1]);
                    File wibFile = new File(nonOptionArgs[2]);
                    File wigFile = new File(nonOptionArgs[3]);
                    String trackLine = nonOptionArgs.length > 4 ? nonOptionArgs[4] : null;
                    this.doWIBtoWIG(txtFile, wibFile, wigFile, trackLine);
                    break block28;
                }
                if (command.equals("splitgff")) {
                    this.validateArgsLength(nonOptionArgs, 3);
                    String outputDirectory = nonOptionArgs[2];
                    GFFParser.splitFileByType(ifile, outputDirectory);
                    break block28;
                }
                if (command.toLowerCase().equals("gcttoigv")) {
                    String genomeId;
                    Genome genome;
                    this.validateArgsLength(nonOptionArgs, 4);
                    String ofile = nonOptionArgs[2];
                    if (!ofile.endsWith(".igv")) {
                        ofile = ofile + ".igv";
                    }
                    if ((genome = IgvTools.loadGenome(genomeId = nonOptionArgs[3])) == null) {
                        throw new PreprocessingException("Genome could not be loaded: " + genomeId);
                    }
                    String probeFile = (String)parser.getOptionValue(probeFileOption, PROBE_FILE);
                    this.doGCTtoIGV(ifile, new File(ofile), probeFile, maxRecords, tmpDirName, genome);
                    break block28;
                }
                if (command.equals("formatexp")) {
                    this.validateArgsLength(nonOptionArgs, 3);
                    File inputFile = new File(nonOptionArgs[1]);
                    File outputFile = new File(nonOptionArgs[2]);
                    new ExpressionFormatter().convert(inputFile, outputFile);
                    break block28;
                }
                if (command.toLowerCase().equals("tdftobedgraph")) {
                    this.validateArgsLength(nonOptionArgs, 3);
                    String ofile = nonOptionArgs[2];
                    TDFUtils.tdfToBedgraph(ifile, ofile);
                    break block28;
                }
                if (command.equals("wigtobed")) {
                    this.validateArgsLength(nonOptionArgs, 2);
                    String inputFile = nonOptionArgs[1];
                    float hetThreshold = 0.17f;
                    if (nonOptionArgs.length > 2) {
                        hetThreshold = Float.parseFloat(nonOptionArgs[2]);
                    }
                    float homThreshold = 0.55f;
                    if (nonOptionArgs.length > 3) {
                        homThreshold = Float.parseFloat(nonOptionArgs[3]);
                    }
                    WigToBed.run(inputFile, hetThreshold, homThreshold);
                    break block28;
                }
                if (command.equals("vcftobed")) {
                    this.validateArgsLength(nonOptionArgs, 3);
                    String inputFile = nonOptionArgs[1];
                    String outputFile = nonOptionArgs[2];
                    VCFtoBed.convert(inputFile, outputFile);
                    break block28;
                }
                if (command.equals("lanecounter")) {
                    this.validateArgsLength(nonOptionArgs, 3);
                    Genome genome = IgvTools.loadGenome(nonOptionArgs[1]);
                    String bamFileList = nonOptionArgs[2];
                    String queryInterval = nonOptionArgs[3];
                    LaneCounter.run(genome, bamFileList, queryInterval);
                    break block28;
                }
                if (command.equals("sumwigs")) {
                    this.sumWigs(nonOptionArgs[1], nonOptionArgs[2]);
                    break block28;
                }
                throw new PreprocessingException("Unknown command: " + argv[0]);
            }
            catch (PreprocessingException e3) {
                System.err.println(e3.getMessage());
            }
            catch (IOException e4) {
                throw new PreprocessingException("Unexpected IO error: ", e4);
            }
        }
    }

    private void sumWigs(String inputString, String outputString) throws IOException {
        String[] tokens = inputString.split(",");
        ArrayList<File> in = new ArrayList<File>();
        for (String f2 : tokens) {
            in.add(new File(f2));
        }
        File out = new File(outputString);
        WigSummer.sumWigs(in, out);
    }

    private void doGCTtoIGV(String ifile, File ofile, String probefile, int maxRecords, String tmpDirName, Genome genome) throws IOException {
        File tmpDir = null;
        if (tmpDirName != null && tmpDirName.trim().length() > 0 && !(tmpDir = new File(tmpDirName)).exists()) {
            System.err.println("Error: tmp directory: " + tmpDir.getAbsolutePath() + " does not exist.");
            throw new PreprocessingException("Error: tmp directory: " + tmpDir.getAbsolutePath() + " does not exist.");
        }
        GCTtoIGVConverter.convert(new File(ifile), ofile, probefile, maxRecords, tmpDir, genome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toTDF(String ifile, String ofile, String probeFile, String genomeId, int maxZoomValue, Collection<WindowFunction> windowFunctions, String tmpDirName, int maxRecords) throws IOException, PreprocessingException {
        IgvTools.validateIsTilable(ifile);
        System.out.println("Tile.  File = " + ifile);
        System.out.println("Max zoom = " + maxZoomValue);
        if (probeFile != null && probeFile.trim().length() > 0) {
            System.out.println("Probe file = " + probeFile);
        }
        System.out.print("Window functions: ");
        for (WindowFunction wf : windowFunctions) {
            System.out.print(wf.toString() + " ");
        }
        System.out.println();
        Genome genome = IgvTools.loadGenome(genomeId);
        if (genome == null) {
            throw new PreprocessingException("Genome could not be loaded: " + genomeId);
        }
        File tmp = new File(ifile);
        int nLines = tmp.isDirectory() ? ParsingUtils.estimateLineCount(tmp) : ParsingUtils.estimateLineCount(ifile);
        File deleteme = null;
        if (this.isGCT(ifile)) {
            File tmpDir = null;
            if (tmpDirName != null && tmpDirName.length() > 0) {
                tmpDir = new File(tmpDirName);
                if (!tmpDir.exists() || !tmpDir.isDirectory()) {
                    throw new PreprocessingException("Specified tmp directory does not exist or is not directory: " + tmpDirName);
                }
            } else {
                tmpDir = new File(System.getProperty("java.io.tmpdir"), System.getProperty("user.name"));
            }
            if (!tmpDir.exists()) {
                tmpDir.mkdir();
            }
            String baseName = new File(ifile).getName();
            File igvFile = new File(tmpDir, baseName + ".igv");
            igvFile.deleteOnExit();
            this.doGCTtoIGV(ifile, igvFile, probeFile, maxRecords, tmpDirName, genome);
            tmp = igvFile;
            deleteme = igvFile;
        }
        File outputFile = new File(ofile);
        try {
            Preprocessor p2 = new Preprocessor(outputFile, genome, windowFunctions, nLines, null);
            if (tmp.isDirectory()) {
                for (File f2 : tmp.listFiles()) {
                    p2.preprocess(f2, maxZoomValue);
                }
            } else {
                p2.preprocess(tmp, maxZoomValue);
            }
            p2.finish();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            if (outputFile.exists()) {
                outputFile.delete();
            }
        }
        finally {
            if (deleteme != null && deleteme.exists()) {
                deleteme.delete();
            }
        }
        System.out.flush();
    }

    private boolean isGCT(String iFile) {
        String tmp = iFile;
        if (tmp.endsWith(".txt")) {
            tmp = tmp.substring(0, tmp.length() - 4);
        }
        if (tmp.endsWith(".gz")) {
            tmp = tmp.substring(0, tmp.length() - 3);
        }
        return tmp.endsWith(".gct") || tmp.endsWith(".tab");
    }

    public void doCount(String ifile, String ofile, String genomeId, int maxZoomValue, Collection<WindowFunction> windowFunctions, int windowSizeValue, int extFactorValue, String coverageOpt, String trackLine) throws IOException {
        System.out.println("Computing coverage.  File = " + ifile);
        System.out.println("Max zoom = " + maxZoomValue);
        System.out.println("Window size = " + windowSizeValue);
        System.out.print("Window functions: ");
        for (WindowFunction wf : windowFunctions) {
            System.out.print(wf.toString() + " ");
        }
        System.out.println();
        System.out.println("Ext factor = " + extFactorValue);
        Genome genome = IgvTools.loadGenome(genomeId);
        if (genome == null) {
            throw new PreprocessingException("Genome could not be loaded: " + genomeId);
        }
        File tdfFile = null;
        File wigFile = null;
        String[] files = ofile.split(",");
        if (files[0].endsWith("wig")) {
            wigFile = new File(files[0]);
        } else {
            tdfFile = new File(files[0]);
        }
        if (files.length > 1) {
            if (files[1].endsWith("wig")) {
                wigFile = new File(files[1]);
            } else if (files[1].endsWith("tdf")) {
                tdfFile = new File(files[1]);
            }
        }
        if (tdfFile != null && !tdfFile.getName().endsWith(".tdf")) {
            tdfFile = new File(tdfFile.getAbsolutePath() + ".tdf");
        }
        Preprocessor p2 = new Preprocessor(tdfFile, genome, windowFunctions, -1, null);
        p2.count(ifile, windowSizeValue, extFactorValue, maxZoomValue, wigFile, coverageOpt, trackLine);
        p2.finish();
        System.out.flush();
    }

    public void doWIBtoWIG(File txtFile, File wibFile, File wigFile, String trackLine) {
        UCSCUtils.convertWIBFile(txtFile, wibFile, wigFile, trackLine);
    }

    public void doPreprocessSeg(String[] argv, Genome genome) {
        int nArgs = argv.length - 1;
        String[] args = new String[nArgs];
        System.arraycopy(argv, 1, args, 0, nArgs);
    }

    public void doIndex(String ifile, int indexType, int binSize) throws IOException {
        this.doIndex(ifile, null, indexType, binSize);
    }

    public void doIndex(String ifile, String outputFileName, int indexType, int binSize) throws IOException {
        block10: {
            FeatureCodec codec;
            if (ifile.endsWith(".gz")) {
                System.out.println("Cannot index a gzipped file");
                throw new PreprocessingException("Cannot index a gzipped file");
            }
            if (outputFileName == null) {
                outputFileName = ifile;
            }
            if ((codec = CodecFactory.getCodec(ifile)) != null) {
                if (!outputFileName.endsWith(".idx")) {
                    outputFileName = outputFileName + ".idx";
                }
                try {
                    this.createTribbleIndex(ifile, new File(outputFileName), indexType, binSize, codec);
                }
                catch (TribbleException.MalformedFeatureFile e2) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("<html>Files must be sorted by start position prior to indexing.<br>");
                    buf.append(e2.getMessage());
                    buf.append("<br><br>Note: igvtools can be used to sort the file, select \"File > Run igvtools...\".");
                    MessageUtils.showMessage(buf.toString());
                }
            } else {
                if (!outputFileName.endsWith(".sai")) {
                    outputFileName = outputFileName + ".sai";
                }
                AlignmentIndexer indexer = AlignmentIndexer.getInstance(new File(ifile), null, null);
                File outputFile = new File(outputFileName);
                try {
                    indexer.createSamIndex(outputFile);
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                    if (!outputFile.exists()) break block10;
                    outputFile.delete();
                }
            }
        }
        System.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTribbleIndex(String ifile, File outputFile, int indexType, int binSize, FeatureCodec codec) throws IOException {
        File inputFile = new File(ifile);
        Index idx = null;
        idx = indexType == 1 ? IndexFactory.createLinearIndex(inputFile, codec, binSize) : IndexFactory.createIntervalIndex(inputFile, codec, binSize);
        if (idx != null) {
            String idxFile;
            if (outputFile != null) {
                idxFile = outputFile.getAbsolutePath();
            } else {
                ifile = ".idx";
                idxFile = ".idx";
            }
            FilterOutputStream stream = null;
            try {
                stream = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(idxFile)));
                idx.write((LittleEndianOutputStream)stream);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                File tmp = new File(idxFile);
                if (tmp.exists()) {
                    tmp.delete();
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
    }

    public void doSort(String ifile, String ofile, String tmpDirName, int maxRecords) {
        block4: {
            System.out.println("Sorting " + ifile + "  -> " + ofile);
            File inputFile = new File(ifile);
            File outputFile = new File(ofile);
            Sorter sorter = Sorter.getSorter(inputFile, outputFile);
            if (tmpDirName != null && tmpDirName.trim().length() > 0) {
                File tmpDir = new File(tmpDirName);
                if (!tmpDir.exists()) {
                    System.err.println("Error: tmp directory: " + tmpDir.getAbsolutePath() + " does not exist.");
                    throw new PreprocessingException("Error: tmp directory: " + tmpDir.getAbsolutePath() + " does not exist.");
                }
                sorter.setTmpDir(tmpDir);
            }
            sorter.setMaxRecords(maxRecords);
            try {
                sorter.run();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                if (!outputFile.exists()) break block4;
                outputFile.delete();
            }
        }
        System.out.println("Done");
        System.out.flush();
    }

    private void validateArgsLength(String[] nonOptionArgs, int len) throws PreprocessingException {
        if (nonOptionArgs.length < len) {
            throw new PreprocessingException(IgvTools.usageString());
        }
    }

    public static Genome loadGenome(String genomeFileOrID) throws IOException {
        String rootDir = FileUtils.getInstallDirectory();
        GenomeManager genomeManager = Globals.isHeadless() ? new GenomeManager() : IGV.getInstance().getGenomeManager();
        Genome genome = genomeManager.getCurrentGenome();
        if (genome != null && genome.getId().equals(genomeFileOrID)) {
            return genome;
        }
        File genomeFile = new File(genomeFileOrID);
        if (!genomeFile.exists()) {
            genomeFile = new File(rootDir, "genomes" + File.separator + genomeFileOrID + ".genome");
        }
        if (!genomeFile.exists()) {
            genomeFile = new File(rootDir, "genomes" + File.separator + genomeFileOrID);
        }
        if (!genomeFile.exists()) {
            genomeFile = new File(genomeFileOrID);
        }
        if (!genomeFile.exists()) {
            throw new PreprocessingException("Genome definition file not found for: " + genomeFileOrID);
        }
        genomeManager.loadGenomeFromLocalFile(genomeFile);
        genome = genomeManager.getCurrentGenome();
        if (genome == null) {
            throw new PreprocessingException("Error loading: " + genomeFileOrID);
        }
        return genome;
    }

    private static void validateIsTilable(String ifile) {
        String ext;
        File tmp = new File(ifile);
        if (tmp.isDirectory()) {
            File[] files = tmp.listFiles();
            if (files.length == 0) {
                throw new PreprocessingException("Tile command not supported for empty directory: " + ifile);
            }
            ifile = files[0].getName();
        }
        if (!((ext = Preprocessor.getExtension(ifile)).equals(".cn") || ext.equals(".igv") || ext.equals(".wig") || ifile.toLowerCase().endsWith("cpg.txt") || ext.equals(".ewig") || ext.equals(".cn") || ext.equals(".snp") || ext.equals(".xcn") || ext.equals(".gct") || ext.equals(".bedgraph") || Preprocessor.isAlignmentFile(ext))) {
            throw new PreprocessingException("Tile command not supported for files of type: " + ext);
        }
    }

    private static Collection<WindowFunction> parseWFS(String string, boolean isGCT) {
        if (string == null || string.length() == 0) {
            return isGCT ? Arrays.asList(WindowFunction.min, WindowFunction.mean, WindowFunction.max) : Arrays.asList(WindowFunction.mean);
        }
        String[] tokens = string.split(",");
        ArrayList<WindowFunction> funcs = new ArrayList<WindowFunction>(tokens.length);
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String wf = tokens[i2];
            if (wf.startsWith("p")) {
                wf = wf.replaceFirst("p", "percentile");
            }
            try {
                funcs.add(WindowFunction.valueOf(wf));
                continue;
            }
            catch (Exception e2) {
                System.err.println("Unrecognized window function: " + tokens[i2]);
            }
        }
        return funcs;
    }

    private static void launchGUI() {
        IgvToolsGui.main(null);
    }
}

