/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.data.CoverageDataSource;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.DataRangeDialog;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.FileChooserDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ColorUtilities;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.readers.AsciiLineReader;

public class CoverageTrack
extends AbstractTrack {
    private static Logger log = Logger.getLogger(CoverageTrack.class);
    private static Map<String, Set<Integer>> knownSnps;
    char[] nucleotides = new char[]{'a', 'c', 'g', 't', 'n'};
    public static Color lightBlue;
    private float[] bgColorComps = new float[3];
    private static final boolean DEFAULT_AUTOSCALE = true;
    private static final boolean DEFAULT_SHOW_REFERENCE = false;
    boolean showReference;
    boolean autoScale = true;
    private float snpThreshold;
    private boolean showAllSnps;
    AlignmentDataManager dataManager;
    CoverageDataSource dataSource;
    DataRenderer dataSourceRenderer;
    IntervalRenderer intervalRenderer;
    PreferenceManager prefs;
    JMenuItem dataRangeItem;
    JMenuItem autoscaleItem;
    Genome genome;
    static float[] colorComps;

    public CoverageTrack(String id, String name, Genome genome) {
        super(id, name);
        super.setDataRange(new DataRange(0.0f, 0.0f, 60.0f));
        this.genome = genome;
        this.intervalRenderer = new IntervalRenderer();
        this.setColor(AlignmentRenderer.grey1);
        AlignmentRenderer.grey1.getColorComponents(this.bgColorComps);
        this.prefs = PreferenceManager.getInstance();
        this.snpThreshold = this.prefs.getAsFloat("SAM.ALLELE_THRESHOLD");
        this.autoScale = true;
        this.showReference = false;
        this.showAllSnps = this.prefs.getAsBoolean("COVERAGE.SHOW_ALL_MISMATCHES");
        String snpsFile = this.prefs.get("KNOWN_SNPS_FILE", null);
        if (snpsFile != null && knownSnps == null) {
            CoverageTrack.loadKnownSnps(snpsFile);
        }
    }

    public void setDataManager(AlignmentDataManager dataManager) {
        this.dataManager = dataManager;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = (CoverageDataSource)dataSource;
        this.dataSourceRenderer = new BarChartRenderer();
        this.setDataRange(new DataRange(0.0f, 0.0f, 1.5f * (float)dataSource.getDataMax()));
    }

    @Override
    public void setDataRange(DataRange axisDefinition) {
        this.autoScale = false;
        super.setDataRange(axisDefinition);
    }

    public void rescale() {
        if (this.autoScale & this.dataManager != null) {
            for (AlignmentInterval interval : this.dataManager.getLoadedIntervals()) {
                this.rescaleInterval(interval);
            }
        }
    }

    public void rescale(ReferenceFrame frame) {
        this.rescaleInterval(this.dataManager.getLoadedInterval(frame));
    }

    private void rescaleInterval(AlignmentInterval interval) {
        if (interval != null) {
            int max = Math.max(10, interval.getMaxCount());
            DataRange.Type type = this.getDataRange().getType();
            super.setDataRange(new DataRange(0.0f, 0.0f, max));
            this.getDataRange().setType(type);
        }
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        int zoom;
        int end;
        int start;
        String chr;
        List<LocusScore> scores;
        float maxRange = PreferenceManager.getInstance().getAsFloat("SAM.MAX_VISIBLE_RANGE");
        float minVisibleScale = maxRange * 1000.0f / 700.0f;
        if (context.getScale() < (double)minVisibleScale) {
            AlignmentInterval interval = null;
            if (this.dataManager != null) {
                interval = this.dataManager.getLoadedInterval(context);
            }
            if (interval != null && interval.contains(context.getGenomeId(), context.getChr(), (int)context.getOrigin(), (int)context.getEndLocation())) {
                List<AlignmentCounts> counts = interval.getCounts();
                this.intervalRenderer.paint(context, rect, counts);
            }
        } else if (this.dataSource != null && (scores = this.dataSource.getSummaryScoresForRange(chr = context.getChr(), start = (int)context.getOrigin(), end = (int)context.getEndLocation(), zoom = context.getZoom())) != null) {
            this.dataSourceRenderer.render(scores, context, rect, (Track)this);
        }
        this.drawBorder(context, rect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawBorder(RenderContext context, Rectangle rect) {
        context.getGraphic2DForColor(Color.gray).drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
        DataRange range = this.getDataRange();
        if (range != null) {
            Graphics2D g2 = context.getGraphic2DForColor(Color.black);
            Font font = g2.getFont();
            Font smallFont = FontManager.getFont(8);
            try {
                g2.setFont(smallFont);
                String scale = "[" + (int)range.getMinimum() + " - " + (int)range.getMaximum() + "]";
                g2.drawString(scale, rect.x + 5, rect.y + 10);
            }
            finally {
                g2.setFont(font);
            }
        }
    }

    @Override
    public void setWindowFunction(WindowFunction type) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return null;
    }

    @Override
    public void setRendererClass(Class rc) {
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        float maxRange = PreferenceManager.getInstance().getAsFloat("SAM.MAX_VISIBLE_RANGE");
        float minVisibleScale = maxRange * 1000.0f / 700.0f;
        if (frame.getScale() < (double)minVisibleScale) {
            AlignmentInterval interval = this.dataManager.getLoadedInterval(frame);
            if (interval != null && interval.contains(chr, (int)position, (int)position)) {
                StringBuffer buf = new StringBuffer();
                int pos = (int)position - 1;
                int totalCount = interval.getTotalCount(pos);
                buf.append("Total count: " + totalCount + "<br>");
                for (char c2 : this.nucleotides) {
                    int negCount = interval.getNegCount(pos, (byte)c2);
                    int posCount = interval.getPosCount(pos, (byte)c2);
                    int count = negCount + posCount;
                    int percent = Math.round((float)count * 100.0f / (float)totalCount);
                    char cU = Character.toUpperCase(c2);
                    buf.append(cU + "      : " + count);
                    if (count == 0) {
                        buf.append("<br>");
                        continue;
                    }
                    buf.append("  (" + percent + "%,     " + posCount + "+,   " + negCount + "- )<br>");
                }
                return buf.toString();
            }
        } else {
            return this.getPrecomputedValueString(chr, position, frame);
        }
        return null;
    }

    private String getPrecomputedValueString(String chr, double position, ReferenceFrame frame) {
        if (this.dataSource == null) {
            return "";
        }
        int zoom = Math.max(0, frame.getZoom());
        List<LocusScore> scores = this.dataSource.getSummaryScoresForRange(chr, (int)position - 10, (int)position + 10, zoom);
        double bpPerPixel = frame.getScale();
        double minWidth = 2.0 * bpPerPixel;
        if (scores == null) {
            return "";
        }
        LocusScore score = (LocusScore)FeatureUtils.getFeatureAt(position, 0, scores);
        return score == null ? "" : "Mean count: " + score.getScore();
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, ReferenceFrame frame) {
        return 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadKnownSnps(String snpFile) {
        if (knownSnps != null) {
            return;
        }
        knownSnps = new HashMap<String, Set<Integer>>();
        AsciiLineReader reader = null;
        try {
            reader = ParsingUtils.openAsciiReader(new ResourceLocator(snpFile));
            String nextLine = "";
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens = nextLine.split("\t");
                String chr = tokens[0];
                Set<Integer> snps = knownSnps.get(chr);
                if (snps == null) {
                    snps = new HashSet<Integer>(10000);
                    knownSnps.put(chr, snps);
                }
                snps.add(new Integer(tokens[1]));
            }
        }
        catch (Exception e2) {
            knownSnps = null;
            log.error("", e2);
            MessageUtils.showMessage("Error loading snps file: " + snpFile + " (" + e2.toString() + ")");
        }
        finally {
            reader.close();
        }
    }

    private Color getShadedColor(int qual, Color color) {
        float alpha = 0.0f;
        int minQ = this.prefs.getAsInt("SAM.BASE_QUALITY_MIN");
        color.getRGBColorComponents(colorComps);
        if (qual < minQ) {
            alpha = 0.1f;
        } else {
            int maxQ = this.prefs.getAsInt("SAM.BASE_QUALITY_MAX");
            alpha = Math.max(0.1f, Math.min(1.0f, 0.1f + 0.9f * (float)(qual - minQ) / (float)(maxQ - minQ)));
        }
        alpha = (float)((int)(alpha * 10.0f + 0.5f)) / 10.0f;
        color = ColorUtilities.getCompositeColor(this.bgColorComps, colorComps, alpha);
        return color;
    }

    @Override
    public Map<String, String> getPersistentState() {
        Map<String, String> attributes = super.getPersistentState();
        if (this.dataSource != null) {
            attributes.put("path", this.dataSource.getPath());
        }
        this.prefs = PreferenceManager.getInstance();
        if (this.snpThreshold != this.prefs.getAsFloat("SAM.ALLELE_THRESHOLD")) {
            attributes.put("snpThreshold", String.valueOf(this.snpThreshold));
        }
        if (!this.autoScale) {
            attributes.put("autoScale", String.valueOf(this.autoScale));
        }
        if (this.showReference) {
            attributes.put("showReference", String.valueOf(this.showReference));
        }
        if (this.showAllSnps != this.prefs.getAsBoolean("COVERAGE.SHOW_ALL_MISMATCHES")) {
            attributes.put("showAllSnps", String.valueOf(this.showAllSnps));
        }
        return attributes;
    }

    @Override
    public void restorePersistentState(Map<String, String> attributes) {
        super.restorePersistentState(attributes);
        String value = attributes.get("path");
        if (value != null) {
            TDFReader reader = TDFReader.getReader(value);
            TDFDataSource ds = new TDFDataSource(reader, 0, "", this.genome);
            this.setDataSource(ds);
        }
        if ((value = attributes.get("snpThreshold")) != null) {
            this.snpThreshold = Float.parseFloat(value);
        }
        if ((value = attributes.get("autoScale")) != null) {
            this.autoScale = Boolean.parseBoolean(value);
        }
        if ((value = attributes.get("showReference")) != null) {
            this.showReference = Boolean.parseBoolean(value);
        }
        if ((value = attributes.get("showAllSnps")) != null) {
            this.showAllSnps = Boolean.parseBoolean(value);
        }
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu popupMenu = new IGVPopupMenu();
        JLabel popupTitle = new JLabel("  " + this.getName(), 0);
        Font newFont = popupMenu.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        if (popupTitle != null) {
            popupMenu.add(popupTitle);
        }
        popupMenu.addSeparator();
        ArrayList<Track> tmp = new ArrayList<Track>();
        tmp.add(this);
        popupMenu.add(TrackMenuUtils.getTrackRenameItem(tmp));
        this.addAutoscaleItem(popupMenu);
        this.addLogScaleItem(popupMenu);
        this.dataRangeItem = this.addDataRangeItem(popupMenu, tmp);
        this.dataRangeItem.setEnabled(!this.autoScale);
        this.addSnpTresholdItem(popupMenu);
        popupMenu.addSeparator();
        this.addLoadCoverageDataItem(popupMenu);
        popupMenu.addSeparator();
        popupMenu.add(TrackMenuUtils.getRemoveMenuItem(tmp));
        return popupMenu;
    }

    public JMenuItem addDataRangeItem(JPopupMenu menu, final Collection<Track> selectedTracks) {
        JMenuItem maxValItem = new JMenuItem("Set Data Range");
        maxValItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (selectedTracks.size() > 0) {
                    DataRange prevAxisDefinition = ((Track)selectedTracks.iterator().next()).getDataRange();
                    DataRangeDialog dlg = new DataRangeDialog(IGV.getMainFrame(), prevAxisDefinition);
                    dlg.setHideMid(true);
                    dlg.setVisible(true);
                    if (!dlg.isCanceled()) {
                        float min = Math.min(dlg.getMin(), dlg.getMax());
                        float max = Math.max(dlg.getMin(), dlg.getMax());
                        float mid = dlg.getBase();
                        if (mid < min) {
                            mid = min;
                        } else if (mid > max) {
                            mid = max;
                        }
                        DataRange dataRange = new DataRange(min, mid, max);
                        dataRange.setType(CoverageTrack.this.getDataRange().getType());
                        for (Track track : selectedTracks) {
                            track.setDataRange(dataRange);
                        }
                        IGV.getMainFrame().repaint();
                    }
                }
            }
        });
        menu.add(maxValItem);
        return maxValItem;
    }

    public JMenuItem addSnpTresholdItem(JPopupMenu menu) {
        JMenuItem maxValItem = new JMenuItem("Set allele frequency threshold...");
        maxValItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String value = JOptionPane.showInputDialog("Allele frequency threshold: ", (Object)Float.valueOf(CoverageTrack.this.snpThreshold));
                if (value == null) {
                    return;
                }
                try {
                    float tmp = Float.parseFloat(value);
                    CoverageTrack.this.snpThreshold = tmp;
                    IGV.getInstance().repaintDataPanels();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        menu.add(maxValItem);
        return maxValItem;
    }

    public void addLoadCoverageDataItem(JPopupMenu menu) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Load coverage data...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FileChooserDialog trackFileDialog = IGV.getInstance().getTrackFileChooser();
                trackFileDialog.setMultiSelectionEnabled(false);
                trackFileDialog.setVisible(true);
                if (!trackFileDialog.isCanceled()) {
                    File file = trackFileDialog.getSelectedFile();
                    String path = file.getAbsolutePath();
                    if (path.endsWith(".tdf") || path.endsWith(".tdf")) {
                        TDFReader reader = TDFReader.getReader(file.getAbsolutePath());
                        TDFDataSource ds = new TDFDataSource(reader, 0, CoverageTrack.this.getName() + " coverage", CoverageTrack.this.genome);
                        CoverageTrack.this.setDataSource(ds);
                        IGV.getInstance().repaintDataPanels();
                    } else {
                        MessageUtils.showMessage("Coverage data must be in .tdf format");
                    }
                }
            }
        });
        menu.add(item);
    }

    public void addAutoscaleItem(JPopupMenu menu) {
        this.autoscaleItem = new JCheckBoxMenuItem("Autoscale");
        this.autoscaleItem.setSelected(this.autoScale);
        this.autoscaleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CoverageTrack.this.autoScale = CoverageTrack.this.autoscaleItem.isSelected();
                CoverageTrack.this.dataRangeItem.setEnabled(!CoverageTrack.this.autoScale);
                if (CoverageTrack.this.autoScale) {
                    CoverageTrack.this.rescale();
                }
                IGV.getInstance().repaintDataPanels();
            }
        });
        menu.add(this.autoscaleItem);
    }

    public void addLogScaleItem(JPopupMenu menu) {
        final DataRange dataRange = this.getDataRange();
        final JCheckBoxMenuItem logScaleItem = new JCheckBoxMenuItem("Log scale");
        boolean logScale = dataRange.getType() == DataRange.Type.LOG;
        logScaleItem.setSelected(logScale);
        logScaleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DataRange.Type scaleType = logScaleItem.isSelected() ? DataRange.Type.LOG : DataRange.Type.LINEAR;
                dataRange.setType(scaleType);
                IGV.getInstance().repaintDataPanels();
            }
        });
        menu.add(logScaleItem);
    }

    static {
        lightBlue = new Color(0, 0, 150);
        colorComps = new float[3];
    }

    class IntervalRenderer {
        IntervalRenderer() {
        }

        private void paint(RenderContext context, Rectangle rect, List<AlignmentCounts> countList) {
            Graphics2D graphics = context.getGraphic2DForColor(AlignmentRenderer.grey1);
            DataRange range = CoverageTrack.this.getDataRange();
            double max = range.isLog() ? Math.log10(range.getMaximum()) : (double)range.getMaximum();
            int lastpX = -1;
            double rectX = rect.getX();
            double rectMaxX = rect.getMaxX();
            double rectY = rect.getY();
            double rectMaxY = rect.getMaxY();
            double rectHeight = rect.getHeight();
            double origin = context.getOrigin();
            double colorScaleMax = CoverageTrack.this.getColorScale().getMaximum();
            double scale = context.getScale();
            block0: for (AlignmentCounts alignmentCounts : countList) {
                int intervalStart;
                int intervalEnd = alignmentCounts.getEnd();
                for (int pos = intervalStart = alignmentCounts.getStart(); pos < intervalEnd; ++pos) {
                    int pY;
                    Set snps;
                    int pX = (int)(rectX + ((double)pos - origin) / scale);
                    int dX = Math.max(1, (int)(rectX + ((double)(pos + 1) - origin) / scale) - pX);
                    if (dX > 3) {
                        --dX;
                    }
                    if ((double)pX > rectMaxX) continue block0;
                    if (pX + dX < 0) continue;
                    char ref = Character.toLowerCase((char)alignmentCounts.getReference(pos));
                    boolean mismatch = false;
                    Set set = snps = knownSnps == null ? null : (Set)knownSnps.get(context.getChr());
                    if (snps == null || !snps.contains(pos + 1)) {
                        float threshold = CoverageTrack.this.snpThreshold * (float)alignmentCounts.getTotalQuality(pos);
                        if (ref > '\u0000') {
                            for (char c2 : CoverageTrack.this.nucleotides) {
                                if (c2 == ref || c2 == 'n' || !((float)alignmentCounts.getQuality(pos, (byte)c2) > threshold)) continue;
                                mismatch = true;
                                break;
                            }
                        }
                    }
                    if (pX <= lastpX && !mismatch) continue;
                    boolean strandOption = false;
                    if (strandOption) {
                        pY = (int)(rectY + rectMaxY) / 2;
                        int totalNegCount = alignmentCounts.getNegTotal(pos);
                        int height = (int)((double)totalNegCount * rectHeight / colorScaleMax);
                        if ((height = Math.min(height, rect.height / 2 - 1)) > 0) {
                            graphics.fillRect(pX, pY, dX, height);
                            if (mismatch || CoverageTrack.this.showAllSnps) {
                                for (char c3 : CoverageTrack.this.nucleotides) {
                                    if (c3 == ref) continue;
                                    pY = this.drawStrandBar(context, pos, rect, colorScaleMax, pY, pX, dX, c3, false, alignmentCounts);
                                }
                            }
                        }
                        pY = (int)(rectY + rectMaxY) / 2;
                        int totalPosCount = alignmentCounts.getPosTotal(pos);
                        height = (int)((double)totalPosCount * rectHeight / colorScaleMax);
                        height = Math.min(height, rect.height / 2 - 1);
                        int topY = pY - height;
                        if (height > 0) {
                            graphics.fillRect(pX, topY, dX, height);
                            if (mismatch || CoverageTrack.this.showAllSnps) {
                                for (char c4 : CoverageTrack.this.nucleotides) {
                                    if (c4 == ref) continue;
                                    pY = this.drawStrandBar(context, pos, rect, colorScaleMax, pY, pX, dX, c4, true, alignmentCounts);
                                }
                            }
                        }
                        pY = (int)(rectY + rectMaxY) / 2;
                        Graphics2D blackGraphics = context.getGraphic2DForColor(lightBlue);
                        blackGraphics.drawLine(0, pY, rect.width, pY);
                    } else {
                        pY = (int)rectMaxY - 1;
                        int totalCount = alignmentCounts.getTotalCount(pos);
                        double tmp = range.isLog() ? Math.log10(totalCount) / max : (double)totalCount / max;
                        int height = (int)(tmp * rectHeight);
                        height = Math.min(height, rect.height - 1);
                        int topY = pY - height;
                        if (height > 0) {
                            graphics.fillRect(pX, topY, dX, height);
                            if (mismatch || CoverageTrack.this.showAllSnps) {
                                for (char c5 : CoverageTrack.this.nucleotides) {
                                    if (c5 == ref && CoverageTrack.this.showAllSnps) continue;
                                    pY = this.drawBar(context, pos, rect, totalCount, max, pY, pX, dX, c5, alignmentCounts, range.isLog());
                                }
                            }
                        }
                    }
                    lastpX = pX;
                }
            }
        }

        int drawBar(RenderContext context, int pos, Rectangle rect, double totalCount, double max, int pY, int pX, int dX, char nucleotide, AlignmentCounts interval, boolean isLog) {
            int count = interval.getCount(pos, (byte)nucleotide);
            Color c2 = AlignmentRenderer.getNucleotideColors().get(Character.valueOf(nucleotide));
            if (CoverageTrack.this.showAllSnps) {
                int q = interval.getAvgQuality(pos, (byte)nucleotide);
                c2 = CoverageTrack.this.getShadedColor(q, c2);
            }
            Graphics2D tGraphics = context.getGraphic2DForColor(c2);
            double tmp = isLog ? (double)count / totalCount * Math.log10(totalCount) / max : (double)count / max;
            int height = (int)(tmp * rect.getHeight());
            height = Math.min(pY - rect.y, height);
            int baseY = pY - height;
            if (height > 0) {
                tGraphics.fillRect(pX, baseY, dX, height);
            }
            return baseY;
        }

        int drawStrandBar(RenderContext context, int pos, Rectangle rect, double maxCount, int pY, int pX, int dX, char nucleotide, boolean isPositive, AlignmentCounts interval) {
            int baseY;
            Color c2 = AlignmentRenderer.getNucleotideColors().get(Character.valueOf(nucleotide));
            Graphics2D tGraphics = context.getGraphic2DForColor(c2);
            int count = isPositive ? interval.getPosCount(pos, (byte)nucleotide) : interval.getNegCount(pos, (byte)nucleotide);
            int height = (int)Math.round((double)count * rect.getHeight() / maxCount);
            height = isPositive ? Math.min(pY - rect.y, height) : Math.min(rect.y + rect.height - pY, height);
            int n2 = baseY = isPositive ? pY - height : pY;
            if (height > 0) {
                tGraphics.fillRect(pX, baseY, dX, height);
            }
            return isPositive ? baseY : baseY + height;
        }
    }
}

