/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BPTreeNodeItem;

public class BPTreeLeafNodeItem
implements BPTreeNodeItem {
    private static Logger log = Logger.getLogger(BPTreeLeafNodeItem.class);
    private final boolean isLeafItem = true;
    private long leafIndex;
    private String chromKey;
    private int chromID;
    private int chromSize;

    public BPTreeLeafNodeItem(long leafIndex, String chromKey, int chromID, int chromSize) {
        this.leafIndex = leafIndex;
        this.chromKey = chromKey;
        this.chromID = chromID;
        this.chromSize = chromSize;
    }

    @Override
    public long getItemIndex() {
        return this.leafIndex;
    }

    @Override
    public boolean isLeafItem() {
        return true;
    }

    @Override
    public String getChromKey() {
        return this.chromKey;
    }

    @Override
    public boolean chromKeysMatch(String chromKey) {
        int thatKeyLength;
        String thisKey = this.chromKey;
        String thatKey = chromKey;
        int thisKeyLength = thisKey.length();
        if (thisKeyLength > (thatKeyLength = thatKey.length())) {
            thisKey = thisKey.substring(0, thatKeyLength);
        } else if (thatKeyLength > thisKeyLength) {
            thatKey = thatKey.substring(0, thisKeyLength);
        }
        return thisKey.compareTo(thatKey) == 0;
    }

    @Override
    public void print() {
        log.debug("B+ tree leaf node item number " + this.leafIndex);
        log.debug("Key value = " + this.chromKey);
        log.debug("ChromID = " + this.chromID);
        log.debug("Chromsize = " + this.chromSize);
    }

    public int getChromID() {
        return this.chromID;
    }

    public int getChromSize() {
        return this.chromSize;
    }
}

