/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdf5lib;

import java.io.Serializable;
import java.lang.reflect.Array;
import ncsa.hdf.hdf5lib.ArrayDescriptor;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

public class HDFArray {
    private Object _theArray = null;
    private ArrayDescriptor _desc = null;
    private byte[] _barray = null;

    public HDFArray(Object object) throws HDF5Exception {
        Serializable serializable;
        if (object == null) {
            serializable = new HDF5JavaException("HDFArray: array is null?: ");
        }
        if (!(serializable = object.getClass()).isArray()) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: not an array?: ");
            throw hDF5JavaException;
        }
        this._theArray = object;
        this._desc = new ArrayDescriptor(this._theArray);
        if (this._desc == null) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: internal error: array description failed?: ");
            throw hDF5JavaException;
        }
    }

    public byte[] emptyBytes() throws HDF5Exception {
        byte[] byArray = null;
        byArray = ArrayDescriptor.dims == 1 && ArrayDescriptor.NT == 'B' ? (byte[])this._theArray : new byte[ArrayDescriptor.totalSize];
        if (byArray == null) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: emptyBytes: allocation failed");
            throw hDF5JavaException;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] byteify() throws HDF5Exception {
        int n2;
        if (this._barray != null) {
            return this._barray;
        }
        if (this._theArray == null) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify not an array?: ");
            throw hDF5JavaException;
        }
        if (ArrayDescriptor.dims == 1) {
            if (ArrayDescriptor.NT == 'B') {
                this._barray = (byte[])this._theArray;
                return this._barray;
            }
            try {
                byte[] byArray;
                this._barray = new byte[ArrayDescriptor.totalSize];
                if (ArrayDescriptor.NT == 'I') {
                    byArray = HDFNativeData.intToByte(0, ArrayDescriptor.dimlen[1], (int[])this._theArray);
                } else if (ArrayDescriptor.NT == 'S') {
                    byArray = HDFNativeData.shortToByte(0, ArrayDescriptor.dimlen[1], (short[])this._theArray);
                } else if (ArrayDescriptor.NT == 'F') {
                    byArray = HDFNativeData.floatToByte(0, ArrayDescriptor.dimlen[1], (float[])this._theArray);
                } else if (ArrayDescriptor.NT == 'J') {
                    byArray = HDFNativeData.longToByte(0, ArrayDescriptor.dimlen[1], (long[])this._theArray);
                } else if (ArrayDescriptor.NT == 'D') {
                    byArray = HDFNativeData.doubleToByte(0, ArrayDescriptor.dimlen[1], (double[])this._theArray);
                } else {
                    if (ArrayDescriptor.NT != 'L') {
                        HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: unknown type of data?");
                        throw hDF5JavaException;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        byArray = this.ByteObjToByte((Byte[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        byArray = this.IntegerToByte((Integer[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        byArray = this.ShortToByte((Short[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        byArray = this.FloatObjToByte((Float[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        byArray = this.DoubleObjToByte((Double[])this._theArray);
                    } else {
                        if (!ArrayDescriptor.className.equals("java.lang.Long")) {
                            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: unknown type of Object?");
                            throw hDF5JavaException;
                        }
                        byArray = this.LongObjToByte((Long[])this._theArray);
                    }
                }
                System.arraycopy(byArray, 0, this._barray, 0, ArrayDescriptor.dimlen[1] * ArrayDescriptor.NTsize);
                return this._barray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify array too big?");
                throw hDF5JavaException;
            }
        }
        try {
            this._barray = new byte[ArrayDescriptor.totalSize];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify array too big?");
            throw hDF5JavaException;
        }
        Object object = this._theArray;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n3 >= ArrayDescriptor.totalSize) {
                if (n3 < ArrayDescriptor.totalSize) {
                    throw new InternalError(new String("HDFArray::byteify: Panic didn't complete all input data: n=  " + n3 + " size = " + ArrayDescriptor.totalSize));
                }
                break;
            }
            object = ArrayDescriptor.objs[0];
            n4 = n3 / ArrayDescriptor.bytetoindex[0];
            n4 %= ArrayDescriptor.dimlen[0];
            for (n2 = 0; n2 < ArrayDescriptor.dims; ++n2) {
                n4 = n3 / ArrayDescriptor.bytetoindex[n2];
                if ((n4 %= ArrayDescriptor.dimlen[n2]) == ArrayDescriptor.currentindex[n2]) {
                    object = ArrayDescriptor.objs[n2];
                    continue;
                }
                if (n4 > ArrayDescriptor.dimlen[n2] - 1) {
                    throw new IndexOutOfBoundsException("HDFArray: byteify index OOB?");
                }
                object = Array.get(object, n4);
                ArrayDescriptor.currentindex[n2] = n4;
                ArrayDescriptor.objs[n2] = object;
            }
            try {
                byte[] byArray;
                if (ArrayDescriptor.NT == 'J') {
                    byArray = HDFNativeData.longToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (long[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    byArray = HDFNativeData.longToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (long[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'I') {
                    byArray = HDFNativeData.intToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (int[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'S') {
                    byArray = HDFNativeData.shortToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (short[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'B') {
                    byArray = (byte[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1];
                } else if (ArrayDescriptor.NT == 'F') {
                    byArray = HDFNativeData.floatToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (float[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'D') {
                    byArray = HDFNativeData.doubleToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (double[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else {
                    if (ArrayDescriptor.NT != 'L') {
                        HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify unknown type not implemented?");
                        throw hDF5JavaException;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        byArray = this.ByteObjToByte((Byte[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        byArray = this.IntegerToByte((Integer[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        byArray = this.ShortToByte((Short[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        byArray = this.FloatObjToByte((Float[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        byArray = this.DoubleObjToByte((Double[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else {
                        if (!ArrayDescriptor.className.equals("java.lang.Long")) {
                            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify Object type not implemented?");
                            throw hDF5JavaException;
                        }
                        byArray = this.LongObjToByte((Long[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    }
                }
                System.arraycopy(byArray, 0, this._barray, n3, ArrayDescriptor.dimlen[ArrayDescriptor.dims] * ArrayDescriptor.NTsize);
                n3 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify array too big?");
                throw hDF5JavaException;
            }
        }
        n2 = 0;
        while (n2 < ArrayDescriptor.dims) {
            if (ArrayDescriptor.currentindex[n2] != ArrayDescriptor.dimlen[n2] - 1) {
                throw new InternalError(new String("Panic didn't complete all data: currentindex[" + n2 + "] = " + ArrayDescriptor.currentindex[n2] + " (should be " + (ArrayDescriptor.dimlen[n2] - 1) + " ?)"));
            }
            ++n2;
        }
        return this._barray;
    }

    public Object arrayify(byte[] byArray) throws HDF5Exception {
        int n2;
        if (this._theArray == null) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("arrayify: not an array?: ");
            throw hDF5JavaException;
        }
        if (Array.getLength(byArray) != ArrayDescriptor.totalSize) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("arrayify: array is wrong size?: ");
            throw hDF5JavaException;
        }
        this._barray = byArray;
        if (ArrayDescriptor.dims == 1) {
            try {
                if (ArrayDescriptor.NT == 'I') {
                    int[] nArray = HDFNativeData.byteToInt(this._barray);
                    System.arraycopy(nArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'S') {
                    short[] sArray = HDFNativeData.byteToShort(this._barray);
                    System.arraycopy(sArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'F') {
                    float[] fArray = HDFNativeData.byteToFloat(this._barray);
                    System.arraycopy(fArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'J') {
                    long[] lArray = HDFNativeData.byteToLong(this._barray);
                    System.arraycopy(lArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'D') {
                    double[] dArray = HDFNativeData.byteToDouble(this._barray);
                    System.arraycopy(dArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'B') {
                    System.arraycopy(this._barray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'L') {
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        Byte[] byteArray = this.ByteToByteObj(this._barray);
                        System.arraycopy(byteArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        Integer[] integerArray = this.ByteToInteger(this._barray);
                        System.arraycopy(integerArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        Short[] shortArray = this.ByteToShort(this._barray);
                        System.arraycopy(shortArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        Float[] floatArray = this.ByteToFloatObj(this._barray);
                        System.arraycopy(floatArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        Double[] doubleArray = this.ByteToDoubleObj(this._barray);
                        System.arraycopy(doubleArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Long")) {
                        Long[] longArray = this.ByteToLongObj(this._barray);
                        System.arraycopy(longArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    HDF5JavaException hDF5JavaException = new HDF5JavaException("arrayify:  Object type not implemented yet...");
                    throw hDF5JavaException;
                }
                HDF5JavaException hDF5JavaException = new HDF5JavaException("arrayify:  unknown type not implemented yet...");
                throw hDF5JavaException;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: arrayify array too big?");
                throw hDF5JavaException;
            }
        }
        Object object = this._theArray;
        int n3 = 0;
        int n4 = 0;
        while (n3 < ArrayDescriptor.totalSize) {
            object = ArrayDescriptor.objs[0];
            n4 = n3 / ArrayDescriptor.bytetoindex[0];
            n4 %= ArrayDescriptor.dimlen[0];
            for (n2 = 0; n2 < ArrayDescriptor.dims; ++n2) {
                n4 = n3 / ArrayDescriptor.bytetoindex[n2];
                if ((n4 %= ArrayDescriptor.dimlen[n2]) == ArrayDescriptor.currentindex[n2]) {
                    object = ArrayDescriptor.objs[n2];
                    continue;
                }
                if (n4 > ArrayDescriptor.dimlen[n2] - 1) {
                    System.out.println("out of bounds?");
                    return null;
                }
                object = Array.get(object, n4);
                ArrayDescriptor.currentindex[n2] = n4;
                ArrayDescriptor.objs[n2] = object;
            }
            try {
                Object object2;
                if (ArrayDescriptor.NT == 'J') {
                    object2 = HDFNativeData.byteToLong(n3, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                    n3 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n5 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n5] = ArrayDescriptor.currentindex[n5] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'I') {
                    object2 = HDFNativeData.byteToInt(n3, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                    n3 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n6 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n6] = ArrayDescriptor.currentindex[n6] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'S') {
                    object2 = HDFNativeData.byteToShort(n3, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                    n3 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n7 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n7] = ArrayDescriptor.currentindex[n7] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'B') {
                    System.arraycopy(this._barray, n3, ArrayDescriptor.objs[ArrayDescriptor.dims - 1], 0, ArrayDescriptor.dimlen[ArrayDescriptor.dims]);
                    n3 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    continue;
                }
                if (ArrayDescriptor.NT == 'F') {
                    object2 = HDFNativeData.byteToFloat(n3, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                    n3 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n8 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n8] = ArrayDescriptor.currentindex[n8] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'D') {
                    object2 = HDFNativeData.byteToDouble(n3, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                    n3 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n9 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n9] = ArrayDescriptor.currentindex[n9] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'L') {
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        object2 = this.ByteToByteObj(n3, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n3 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n10 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n10] = ArrayDescriptor.currentindex[n10] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        object2 = this.ByteToInteger(n3, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n3 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n11 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n11] = ArrayDescriptor.currentindex[n11] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        object2 = this.ByteToShort(n3, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n3 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n12 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n12] = ArrayDescriptor.currentindex[n12] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        object2 = this.ByteToFloatObj(n3, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n3 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n13 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n13] = ArrayDescriptor.currentindex[n13] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        object2 = this.ByteToDoubleObj(n3, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n3 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n14 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n14] = ArrayDescriptor.currentindex[n14] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Long")) {
                        object2 = this.ByteToLongObj(n3, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n3 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n15 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n15] = ArrayDescriptor.currentindex[n15] + 1;
                        continue;
                    }
                    object2 = new HDF5JavaException("HDFArray: unsupported Object type: " + ArrayDescriptor.NT);
                    throw object2;
                }
                object2 = new HDF5JavaException("HDFArray: unknown or unsupported type: " + ArrayDescriptor.NT);
                throw object2;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: arrayify array too big?");
                throw hDF5JavaException;
            }
        }
        if (n3 < ArrayDescriptor.totalSize) {
            throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all input data: n=  " + n3 + " size = " + ArrayDescriptor.totalSize));
        }
        for (n2 = 0; n2 <= ArrayDescriptor.dims - 2; ++n2) {
            if (ArrayDescriptor.currentindex[n2] == ArrayDescriptor.dimlen[n2] - 1) continue;
            throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all data: currentindex[" + n2 + "] = " + ArrayDescriptor.currentindex[n2] + " (should be " + (ArrayDescriptor.dimlen[n2] - 1) + "?"));
        }
        if (ArrayDescriptor.NT != 'B') {
            if (ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1] != ArrayDescriptor.dimlen[ArrayDescriptor.dims - 1]) {
                throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all data: currentindex[" + n2 + "] = " + ArrayDescriptor.currentindex[n2] + " (should be " + ArrayDescriptor.dimlen[n2] + "?"));
            }
        } else if (ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1] != ArrayDescriptor.dimlen[ArrayDescriptor.dims - 1] - 1) {
            throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all data: currentindex[" + n2 + "] = " + ArrayDescriptor.currentindex[n2] + " (should be " + (ArrayDescriptor.dimlen[n2] - 1) + "?"));
        }
        return this._theArray;
    }

    private byte[] IntegerToByte(Integer[] integerArray) {
        int n2 = Array.getLength(integerArray);
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = integerArray[i2];
        }
        return HDFNativeData.intToByte(0, n2, nArray);
    }

    private Integer[] ByteToInteger(byte[] byArray) {
        int[] nArray = HDFNativeData.byteToInt(byArray);
        int n2 = Array.getLength(nArray);
        Integer[] integerArray = new Integer[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            integerArray[i2] = new Integer(nArray[i2]);
        }
        return integerArray;
    }

    private Integer[] ByteToInteger(int n2, int n3, byte[] byArray) {
        int[] nArray = HDFNativeData.byteToInt(n2, n3, byArray);
        int n4 = Array.getLength(nArray);
        Integer[] integerArray = new Integer[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            integerArray[i2] = new Integer(nArray[i2]);
        }
        return integerArray;
    }

    private byte[] ShortToByte(Short[] shortArray) {
        int n2 = Array.getLength(shortArray);
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = shortArray[i2];
        }
        return HDFNativeData.shortToByte(0, n2, sArray);
    }

    private Short[] ByteToShort(byte[] byArray) {
        short[] sArray = HDFNativeData.byteToShort(byArray);
        int n2 = Array.getLength(sArray);
        Short[] shortArray = new Short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            shortArray[i2] = new Short(sArray[i2]);
        }
        return shortArray;
    }

    private Short[] ByteToShort(int n2, int n3, byte[] byArray) {
        short[] sArray = HDFNativeData.byteToShort(n2, n3, byArray);
        int n4 = Array.getLength(sArray);
        Short[] shortArray = new Short[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            shortArray[i2] = new Short(sArray[i2]);
        }
        return shortArray;
    }

    private byte[] ByteObjToByte(Byte[] byteArray) {
        int n2 = Array.getLength(byteArray);
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = byteArray[i2];
        }
        return byArray;
    }

    private Byte[] ByteToByteObj(byte[] byArray) {
        int n2 = Array.getLength(byArray);
        Byte[] byteArray = new Byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byteArray[i2] = new Byte(byArray[i2]);
        }
        return byteArray;
    }

    private Byte[] ByteToByteObj(int n2, int n3, byte[] byArray) {
        Byte[] byteArray = new Byte[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            byteArray[i2] = new Byte(byArray[i2]);
        }
        return byteArray;
    }

    private byte[] FloatObjToByte(Float[] floatArray) {
        int n2 = Array.getLength(floatArray);
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = floatArray[i2].floatValue();
        }
        return HDFNativeData.floatToByte(0, n2, fArray);
    }

    private Float[] ByteToFloatObj(byte[] byArray) {
        float[] fArray = HDFNativeData.byteToFloat(byArray);
        int n2 = Array.getLength(fArray);
        Float[] floatArray = new Float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            floatArray[i2] = new Float(fArray[i2]);
        }
        return floatArray;
    }

    private Float[] ByteToFloatObj(int n2, int n3, byte[] byArray) {
        float[] fArray = HDFNativeData.byteToFloat(n2, n3, byArray);
        int n4 = Array.getLength(fArray);
        Float[] floatArray = new Float[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            floatArray[i2] = new Float(fArray[i2]);
        }
        return floatArray;
    }

    private byte[] DoubleObjToByte(Double[] doubleArray) {
        int n2 = Array.getLength(doubleArray);
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = doubleArray[i2];
        }
        return HDFNativeData.doubleToByte(0, n2, dArray);
    }

    private Double[] ByteToDoubleObj(byte[] byArray) {
        double[] dArray = HDFNativeData.byteToDouble(byArray);
        int n2 = Array.getLength(dArray);
        Double[] doubleArray = new Double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            doubleArray[i2] = new Double(dArray[i2]);
        }
        return doubleArray;
    }

    private Double[] ByteToDoubleObj(int n2, int n3, byte[] byArray) {
        double[] dArray = HDFNativeData.byteToDouble(n2, n3, byArray);
        int n4 = Array.getLength(dArray);
        Double[] doubleArray = new Double[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            doubleArray[i2] = new Double(dArray[i2]);
        }
        return doubleArray;
    }

    private byte[] LongObjToByte(Long[] longArray) {
        int n2 = Array.getLength(longArray);
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = longArray[i2];
        }
        return HDFNativeData.longToByte(0, n2, lArray);
    }

    private Long[] ByteToLongObj(byte[] byArray) {
        long[] lArray = HDFNativeData.byteToLong(byArray);
        int n2 = Array.getLength(lArray);
        Long[] longArray = new Long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            longArray[i2] = new Long(lArray[i2]);
        }
        return longArray;
    }

    private Long[] ByteToLongObj(int n2, int n3, byte[] byArray) {
        long[] lArray = HDFNativeData.byteToLong(n2, n3, byArray);
        int n4 = Array.getLength(lArray);
        Long[] longArray = new Long[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            longArray[i2] = new Long(lArray[i2]);
        }
        return longArray;
    }
}

