/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.hic.data.Block;
import org.broad.igv.hic.data.DatasetReader;
import org.broad.igv.hic.tools.HiCTools;
import org.broad.igv.hic.tools.Preprocessor;

public class MatrixZoomData {
    private int chr1;
    private int chr2;
    private int zoom;
    private int binSize;
    private int blockBinCount;
    private int columnCount;
    private LinkedHashMap<Integer, Block> blocks;
    private Map<Integer, Preprocessor.IndexEntry> blockIndex;
    private DatasetReader reader;

    public MatrixZoomData(int chr1, int chr2, int binSize, int columnCount, int zoom) {
        this.chr1 = chr1;
        this.chr2 = chr2;
        this.binSize = binSize;
        this.columnCount = columnCount;
        this.zoom = zoom;
        int nBinsX = HiCTools.chromosomes[chr1].getSize() / binSize + 1;
        this.blockBinCount = nBinsX / columnCount + 1;
        this.blocks = new LinkedHashMap(columnCount * columnCount);
    }

    public MatrixZoomData(int chr1, int chr2, int binSize, int blockBinCount, int columnCount, int zoom, Map<Integer, Preprocessor.IndexEntry> blockIndex, DatasetReader reader) {
        this.chr1 = chr1;
        this.chr2 = chr2;
        this.binSize = binSize;
        this.columnCount = columnCount;
        this.zoom = zoom;
        this.blockBinCount = blockBinCount;
        this.blockIndex = blockIndex;
        this.blocks = new LinkedHashMap(blockIndex.size());
        this.reader = reader;
    }

    public void incrementCount(int pos1, int pos2) {
        int xBin = pos1 / this.getBinSize();
        int yBin = pos2 / this.getBinSize();
        if (this.chr1 == this.chr2) {
            int b1 = Math.min(xBin, yBin);
            int b2 = Math.max(xBin, yBin);
            xBin = b1;
            yBin = b2;
        }
        int blockCol = xBin / this.getBlockBinCount();
        int blockRow = yBin / this.getBlockBinCount();
        int blockNumber = this.getColumnCount() * blockRow + blockCol;
        Block block = this.blocks.get(blockNumber);
        if (block == null) {
            block = new Block(blockNumber);
            this.blocks.put(blockNumber, block);
        }
        block.incrementCount(xBin, yBin);
    }

    public void parsingComplete() {
        for (Block b2 : this.blocks.values()) {
            b2.parsingComplete();
        }
    }

    public int getBinSize() {
        return this.binSize;
    }

    public void setBinSize(int binSize) {
        this.binSize = binSize;
    }

    public int getChr1() {
        return this.chr1;
    }

    public int getChr2() {
        return this.chr2;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public int getBlockBinCount() {
        return this.blockBinCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Map<Integer, Block> getBlocks() {
        return this.blocks;
    }

    public List<Block> getBlocksOverlapping(int x1, int y1, int x2, int y2) {
        int col1 = x1 / this.getBlockBinCount();
        int row1 = y1 / this.getBlockBinCount();
        int col2 = x2 / this.getBlockBinCount();
        int row2 = y2 / this.getBlockBinCount();
        int maxSize = (col2 - col1 + 1) * (row2 - row1 + 1);
        ArrayList<Block> blockList = new ArrayList<Block>(maxSize);
        for (int r = row1; r <= row2; ++r) {
            for (int c2 = col1; c2 <= col2; ++c2) {
                int blockNumber = r * this.getColumnCount() + c2;
                Block b2 = this.getBlock(blockNumber);
                if (b2 == null) continue;
                blockList.add(b2);
            }
        }
        return blockList;
    }

    public Block getBlock(int blockNumber) {
        Preprocessor.IndexEntry idx;
        Block b2 = this.blocks.get(blockNumber);
        if (b2 == null && this.reader != null && this.blockIndex != null && (idx = this.blockIndex.get(blockNumber)) != null) {
            try {
                b2 = this.reader.readBlock(blockNumber, idx);
                this.blocks.put(blockNumber, b2);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return b2;
    }
}

