/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.data;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.hic.data.Block;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.hic.data.ContactRecord;
import org.broad.igv.hic.data.Dataset;
import org.broad.igv.hic.data.Matrix;
import org.broad.igv.hic.data.MatrixZoomData;
import org.broad.igv.hic.tools.Preprocessor;
import org.broad.igv.util.CompressionUtils;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;

public class DatasetReader {
    SeekableStream stream;
    Map<String, Preprocessor.IndexEntry> masterIndex = new HashMap<String, Preprocessor.IndexEntry>();

    public DatasetReader(SeekableStream stream) {
        this.stream = stream;
    }

    public Dataset read() throws FileNotFoundException {
        Dataset ds = new Dataset(this);
        try {
            LittleEndianInputStream dis = new LittleEndianInputStream(new BufferedInputStream(this.stream));
            long masterIndexPos = dis.readLong();
            int nchrs = dis.readInt();
            Chromosome[] chromosomes = new Chromosome[nchrs];
            for (int i2 = 0; i2 < nchrs; ++i2) {
                String name = dis.readString();
                int size = dis.readInt();
                chromosomes[i2] = new Chromosome(i2, name, size);
            }
            ds.setChromosomes(chromosomes);
            int nAttributes = dis.readInt();
            for (int i3 = 0; i3 < nAttributes; ++i3) {
                String key = dis.readString();
                String value = dis.readString();
            }
            this.readMasterIndex(masterIndexPos);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return ds;
    }

    private Map<String, Preprocessor.IndexEntry> readMasterIndex(long position) throws IOException {
        this.stream.seek(position);
        byte[] buffer = new byte[4];
        this.stream.readFully(buffer);
        LittleEndianInputStream dis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
        int nBytes = dis.readInt();
        buffer = new byte[nBytes];
        this.stream.readFully(buffer);
        dis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
        int nEntries = dis.readInt();
        for (int i2 = 0; i2 < nEntries; ++i2) {
            String key = dis.readString();
            long filePosition = dis.readLong();
            int sizeInBytes = dis.readInt();
            this.masterIndex.put(key, new Preprocessor.IndexEntry(filePosition, sizeInBytes));
        }
        return this.masterIndex;
    }

    public Matrix readMatrix(String key) throws IOException {
        Preprocessor.IndexEntry idx = this.masterIndex.get(key);
        if (idx == null) {
            return null;
        }
        byte[] buffer = new byte[idx.size];
        this.stream.seek(idx.position);
        this.stream.readFully(buffer);
        LittleEndianInputStream dis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
        int c1 = dis.readInt();
        int c2 = dis.readInt();
        int nZooms = dis.readInt();
        MatrixZoomData[] zd = new MatrixZoomData[nZooms];
        for (int i2 = 0; i2 < nZooms; ++i2) {
            int zoom = dis.readInt();
            int binSize = dis.readInt();
            int blockSize = dis.readInt();
            int blockColumnCount = dis.readInt();
            int nBlocks = dis.readInt();
            HashMap<Integer, Preprocessor.IndexEntry> blockIndex = new HashMap<Integer, Preprocessor.IndexEntry>(nBlocks);
            for (int b2 = 0; b2 < nBlocks; ++b2) {
                int blockNumber = dis.readInt();
                long filePosition = dis.readLong();
                int blockSizeInBytes = dis.readInt();
                blockIndex.put(blockNumber, new Preprocessor.IndexEntry(filePosition, blockSizeInBytes));
            }
            zd[i2] = new MatrixZoomData(c1, c2, binSize, blockSize, blockColumnCount, zoom, blockIndex, this);
        }
        Matrix m2 = new Matrix(c1, c2, zd);
        return m2;
    }

    public Block readBlock(int blockNumber, Preprocessor.IndexEntry idx) throws IOException {
        byte[] compressedBytes = new byte[idx.size];
        this.stream.seek(idx.position);
        this.stream.readFully(compressedBytes);
        byte[] buffer = CompressionUtils.decompress(compressedBytes);
        LittleEndianInputStream dis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
        int nRecords = dis.readInt();
        ContactRecord[] records = new ContactRecord[nRecords];
        for (int i2 = 0; i2 < nRecords; ++i2) {
            int bin1 = dis.readInt();
            int bin2 = dis.readInt();
            int counts = dis.readInt();
            records[i2] = new ContactRecord(blockNumber, bin1, bin2, counts);
        }
        return new Block(blockNumber, records);
    }
}

