/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.LoginDialog;
import org.broad.igv.util.ResourceLocator;

public class SampleInfoSQLReader {
    private static Logger log = Logger.getLogger(SampleInfoSQLReader.class);
    String sampleColumn = "SAMPLE_ID_ARRAY";

    public void load(ResourceLocator locator) {
        System.out.println("MySQL Connect Example.");
        Connection conn = null;
        PreferenceManager preferenceManager = PreferenceManager.getInstance();
        String db = preferenceManager.get("DB_NAME");
        String url = locator.getServerURL();
        String table = locator.getPath();
        LoginDialog dlg = new LoginDialog(IGV.getMainFrame(), false, db, false);
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            throw new RuntimeException("Must login to access" + db);
        }
        String userName = dlg.getUsername();
        String password = new String(dlg.getPassword());
        String driver = "com.mysql.jdbc.Driver";
        try {
            Class.forName(driver).newInstance();
            conn = DriverManager.getConnection(url, userName, password);
            System.out.println("Connected to the database");
            String query = locator.getDescription();
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(query);
            ResultSetMetaData metaData = rs.getMetaData();
            int nCol = metaData.getColumnCount();
            String[] columnNames = new String[nCol];
            for (int i2 = 0; i2 < nCol; ++i2) {
                columnNames[i2] = metaData.getColumnName(i2 + 1);
            }
            while (rs.next()) {
                String sample = rs.getString(this.sampleColumn);
                for (String col : columnNames) {
                    String value = rs.getString(col);
                    AttributeManager.getInstance().addAttribute(sample, col, value);
                }
            }
            System.out.println("Disconnected from database");
        }
        catch (Exception e2) {
            log.error("Error accessing database", e2);
            throw new RuntimeException(e2);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e3) {
                    log.error("Error closing sql connection", e3);
                }
            }
        }
    }
}

