/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.EmptyAlignmentIterator;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.ReadGroupFilter;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.LRUCache;
import org.broad.igv.util.RuntimeUtils;

public class CachingQueryReader {
    private static Logger log = Logger.getLogger(CachingQueryReader.class);
    private static final int KB = 1000;
    private static final int MITOCHONDRIA_TILE_SIZE = 1000;
    private static int DEFAULT_TILE_SIZE = 16000;
    private static int MAX_TILE_COUNT = 2;
    private static Set<WeakReference<CachingQueryReader>> activeReaders = Collections.synchronizedSet(new HashSet());
    private String cachedChr = "";
    private int tileSize = DEFAULT_TILE_SIZE;
    private AlignmentQueryReader reader;
    private boolean cancel = false;
    private LRUCache<Integer, AlignmentTile> cache;
    private boolean pairedEnd = false;

    private static void cancelReaders() {
        for (WeakReference<CachingQueryReader> readerRef : activeReaders) {
            CachingQueryReader reader = (CachingQueryReader)readerRef.get();
            if (reader == null) continue;
            reader.cancel = true;
        }
        log.debug("Readers canceled");
        activeReaders.clear();
    }

    public CachingQueryReader(AlignmentQueryReader reader) {
        this.reader = reader;
        this.cache = new LRUCache(this, MAX_TILE_COUNT);
        float fvw = PreferenceManager.getInstance().getAsFloat("SAM.MAX_VISIBLE_RANGE");
        this.tileSize = Math.min(DEFAULT_TILE_SIZE, (int)(fvw * 1000.0f));
    }

    public AlignmentQueryReader getWrappedReader() {
        return this.reader;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public Set<String> getSequenceNames() {
        return this.reader.getSequenceNames();
    }

    public SAMFileHeader getHeader() throws IOException {
        return this.reader.getHeader();
    }

    public CloseableIterator<Alignment> iterator() {
        return this.reader.iterator();
    }

    public boolean hasIndex() {
        return this.reader.hasIndex();
    }

    public CloseableIterator<Alignment> query(String sequence, int start, int end, List<AlignmentCounts> counts, int maxReadDepth, Map<String, PEStats> peStats) {
        int readDepthPlus;
        int endTile;
        int startTile = (start + 1) / this.getTileSize(sequence);
        List<AlignmentTile> tiles = this.getTiles(sequence, startTile, endTile = end / this.getTileSize(sequence), readDepthPlus = (int)(1.1 * (double)maxReadDepth), peStats);
        if (tiles.size() == 0) {
            return EmptyAlignmentIterator.getInstance();
        }
        int recordCount = tiles.get(0).getOverlappingRecords().size();
        for (AlignmentTile t : tiles) {
            recordCount += t.getContainedRecords().size();
        }
        ArrayList<Alignment> alignments = new ArrayList<Alignment>(recordCount);
        alignments.addAll(tiles.get(0).getOverlappingRecords());
        for (AlignmentTile t : tiles) {
            alignments.addAll(t.getContainedRecords());
            counts.add(t.getCounts());
        }
        return new TiledIterator(start, end, alignments);
    }

    public List<AlignmentTile> getTiles(String seq, int startTile, int endTile, int maxReadDepth, Map<String, PEStats> peStats) {
        if (!seq.equals(this.cachedChr)) {
            this.cache.clear();
            this.cachedChr = seq;
        }
        ArrayList<AlignmentTile> tiles = new ArrayList<AlignmentTile>(endTile - startTile + 1);
        ArrayList<AlignmentTile> tilesToLoad = new ArrayList<AlignmentTile>(endTile - startTile + 1);
        int tileSize = this.getTileSize(seq);
        for (int t = startTile; t <= endTile; ++t) {
            AlignmentTile tile = this.cache.get(t);
            if (tile == null) {
                int start = t * tileSize;
                int end = start + tileSize;
                tile = new AlignmentTile(seq, t, start, end, maxReadDepth);
            }
            tiles.add(tile);
            if (tile.isLoaded()) {
                boolean success;
                if (tilesToLoad.size() > 0 && !(success = this.loadTiles(seq, tilesToLoad, peStats))) {
                    return tiles;
                }
                tilesToLoad.clear();
                continue;
            }
            tilesToLoad.add(tile);
        }
        if (tilesToLoad.size() > 0) {
            this.loadTiles(seq, tilesToLoad, peStats);
        }
        return tiles;
    }

    private boolean loadTiles(String chr, List<AlignmentTile> tiles, Map<String, PEStats> peStats) {
        int end;
        assert (tiles.size() > 0);
        boolean filterFailedReads = PreferenceManager.getInstance().getAsBoolean("SAM.FILTER_FAILED_READS");
        ReadGroupFilter filter = ReadGroupFilter.getFilter();
        boolean showDuplicates = PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_DUPLICATES");
        int qualityThreshold = PreferenceManager.getInstance().getAsInt("SAM.QUALITY_THRESHOLD");
        if (log.isDebugEnabled()) {
            int first = tiles.get(0).getTileNumber();
            end = tiles.get(tiles.size() - 1).getTileNumber();
            log.debug("Loading tiles: " + first + "-" + end);
        }
        int start = tiles.get(0).start;
        end = tiles.get(tiles.size() - 1).end;
        CloseableIterator<Alignment> iter = null;
        int alignmentCount = 0;
        WeakReference<CachingQueryReader> ref = new WeakReference<CachingQueryReader>(this);
        try {
            HashMap<String, Alignment> mappedMates = new HashMap<String, Alignment>(1000);
            HashMap<String, Alignment> unmappedMates = new HashMap<String, Alignment>(1000);
            activeReaders.add(ref);
            iter = this.reader.query(chr, start, end, false);
            int tileSize = this.getTileSize(chr);
            while (iter != null && iter.hasNext()) {
                PEStats stats;
                int i2;
                if (this.cancel) {
                    boolean bl = false;
                    return bl;
                }
                Alignment record = (Alignment)iter.next();
                String readName = record.getReadName();
                if (record.isPaired()) {
                    this.pairedEnd = true;
                    if (record.isMapped()) {
                        if (!record.getMate().isMapped()) {
                            Alignment mate = (Alignment)unmappedMates.get(readName);
                            if (mate == null) {
                                mappedMates.put(readName, record);
                            } else {
                                record.setMateSequence(mate.getReadSequence());
                                unmappedMates.remove(readName);
                                mappedMates.remove(readName);
                            }
                        }
                    } else if (record.getMate().isMapped()) {
                        Alignment mappedMate = (Alignment)mappedMates.get(readName);
                        if (mappedMate == null) {
                            unmappedMates.put(readName, record);
                        } else {
                            mappedMate.setMateSequence(record.getReadSequence());
                            unmappedMates.remove(readName);
                            mappedMates.remove(readName);
                        }
                    }
                }
                if (!record.isMapped() || !showDuplicates && record.isDuplicate() || filterFailedReads && record.isVendorFailedRead() || record.getMappingQuality() < qualityThreshold || filter != null && filter.filterAlignment(record)) continue;
                int aStart = record.getAlignmentStart();
                int aEnd = record.getEnd();
                int idx0 = Math.max(0, (aStart - start) / tileSize);
                int idx1 = Math.min(tiles.size() - 1, (aEnd - start) / tileSize);
                for (i2 = idx0; i2 <= idx1; i2 += 1) {
                    AlignmentTile t = tiles.get(i2);
                    t.addRecord(record);
                }
                if (++alignmentCount % 1000 == 0) {
                    if (this.cancel) {
                        i2 = 0;
                        return i2 != 0;
                    }
                    IGV.getInstance().setStatusBarMessage("Reads loaded: " + alignmentCount);
                    if (!CachingQueryReader.checkMemory()) {
                        CachingQueryReader.cancelReaders();
                        i2 = 0;
                        return i2 != 0;
                    }
                }
                if (peStats == null || !record.isPaired() || !record.isProperPair()) continue;
                String lb = record.getLibrary();
                if (lb == null) {
                    lb = "null";
                }
                if ((stats = peStats.get(lb)) == null) {
                    stats = new PEStats(lb);
                    peStats.put(lb, stats);
                }
                stats.update(record);
            }
            if (peStats != null) {
                double minPercentile = PreferenceManager.getInstance().getAsFloat("SAM.MIN_ISIZE_MIN_PERCENTILE");
                double maxPercentile = PreferenceManager.getInstance().getAsFloat("SAM.ISIZE_MAX_PERCENTILE");
                for (PEStats stats : peStats.values()) {
                    stats.compute(minPercentile, maxPercentile);
                }
            }
            for (Alignment mappedMate : mappedMates.values()) {
                Alignment mate = (Alignment)unmappedMates.get(mappedMate.getReadName());
                if (mate == null) continue;
                mappedMate.setMateSequence(mate.getReadSequence());
            }
            mappedMates = null;
            unmappedMates = null;
            for (AlignmentTile t : tiles) {
                t.setLoaded(true);
                this.cache.put(t.getTileNumber(), t);
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable e2) {
            log.error("Error loading alignment data", e2);
            throw new DataLoadException("", "Error: " + e2.toString());
        }
        finally {
            this.cancel = false;
            activeReaders.remove(ref);
            if (iter != null) {
                iter.close();
            }
            IGV.getInstance().resetStatusMessage();
        }
    }

    private static synchronized boolean checkMemory() {
        if (RuntimeUtils.getAvailableMemoryFraction() < 0.2) {
            LRUCache.clearCaches();
            System.gc();
            if (RuntimeUtils.getAvailableMemoryFraction() < 0.2) {
                String msg = "Memory is low, reading terminating.";
                MessageUtils.showMessage(msg);
                return false;
            }
        }
        return true;
    }

    public int getTileSize(String chr) {
        if (chr.equals("M") || chr.equals("chrM") || chr.equals("MT") || chr.equals("chrMT")) {
            return 1000;
        }
        return this.tileSize;
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public boolean isPairedEnd() {
        return this.pairedEnd;
    }

    public static class AlignmentTile {
        private boolean loaded = false;
        private List<Alignment> containedRecords;
        private int end;
        private List<Alignment> overlappingRecords;
        private int start;
        private int tileNumber;
        private AlignmentCounts counts;
        int maxDepth;
        int e1;
        private Map<String, Alignment> currentBucket;
        private Map<String, Alignment> currentMates;
        private List<Alignment> overflows;
        private Set<String> pairedReadNames;
        private static final Random RAND = new Random(System.currentTimeMillis());

        AlignmentTile(String chr, int tileNumber, int start, int end, int maxDepth) {
            this.tileNumber = tileNumber;
            this.start = start;
            this.end = end;
            this.containedRecords = new ArrayList<Alignment>(16000);
            this.overlappingRecords = new ArrayList<Alignment>();
            this.counts = new AlignmentCounts(chr, start, end);
            this.maxDepth = maxDepth;
            this.e1 = -1;
            this.currentBucket = new HashMap<String, Alignment>(3 * maxDepth);
            this.currentMates = new HashMap<String, Alignment>(3 * maxDepth);
            this.pairedReadNames = new HashSet<String>(5 * maxDepth);
            this.overflows = new LinkedList<Alignment>();
        }

        public int getTileNumber() {
            return this.tileNumber;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public void addRecord(Alignment record) {
            if (record.getStart() > this.e1) {
                this.emptyBucket();
                this.e1 = record.getEnd();
            } else {
                this.e1 = Math.min(this.e1, record.getEnd());
            }
            String readName = record.getReadName();
            if (!this.currentBucket.containsKey(readName)) {
                this.currentBucket.put(readName, record);
            } else if (!this.currentMates.containsKey(readName)) {
                this.currentMates.put(readName, record);
            } else {
                this.overflows.add(record);
            }
            this.counts.incCounts(record);
        }

        private void emptyBucket() {
            List<Alignment> sampledRecords = this.sampleCurrentBucket();
            for (Alignment alignment : sampledRecords) {
                int aStart = alignment.getAlignmentStart();
                int aEnd = alignment.getEnd();
                if (aStart >= this.start && aStart < this.end) {
                    this.containedRecords.add(alignment);
                    continue;
                }
                if (aEnd < this.start || aStart >= this.start) continue;
                this.overlappingRecords.add(alignment);
            }
            this.currentBucket.clear();
            this.currentMates.clear();
            this.overflows.clear();
        }

        private List<Alignment> sampleCurrentBucket() {
            ArrayList<Alignment> sampledList = new ArrayList<Alignment>(this.maxDepth);
            if (this.currentBucket.size() + this.currentMates.size() + this.overflows.size() < this.maxDepth) {
                sampledList.addAll(this.currentBucket.values());
                sampledList.addAll(this.currentMates.values());
                sampledList.addAll(this.overflows);
            } else {
                ArrayList<String> added = new ArrayList<String>(this.pairedReadNames.size());
                for (String readName : this.pairedReadNames) {
                    if (!this.currentBucket.containsKey(readName)) continue;
                    sampledList.add(this.currentBucket.get(readName));
                    this.currentBucket.remove(readName);
                    added.add(readName);
                }
                this.pairedReadNames.removeAll(added);
                LinkedList<String> keys = new LinkedList<String>(this.currentBucket.keySet());
                while (sampledList.size() < this.maxDepth && keys.size() > 0) {
                    String key = (String)keys.remove(RAND.nextInt(keys.size()));
                    Alignment a2 = this.currentBucket.remove(key);
                    sampledList.add(a2);
                    if (!a2.isPaired() || !a2.getMate().isMapped()) continue;
                    Alignment m2 = this.currentMates.remove(key);
                    if (m2 != null) {
                        sampledList.add(m2);
                        continue;
                    }
                    this.pairedReadNames.add(key);
                }
                while (sampledList.size() < this.maxDepth && this.overflows.size() > 0) {
                    sampledList.add(this.overflows.remove(RAND.nextInt(this.overflows.size())));
                }
                Collections.sort(sampledList, new Comparator<Alignment>(){

                    @Override
                    public int compare(Alignment alignment, Alignment alignment1) {
                        return alignment.getStart() - alignment1.getStart();
                    }
                });
            }
            return sampledList;
        }

        public List<Alignment> getContainedRecords() {
            return this.containedRecords;
        }

        public List<Alignment> getOverlappingRecords() {
            return this.overlappingRecords;
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public void setLoaded(boolean loaded) {
            this.loaded = loaded;
            if (loaded) {
                this.emptyBucket();
                this.currentBucket = null;
                this.currentMates = null;
                this.pairedReadNames = null;
                this.overflows = null;
            }
        }

        public AlignmentCounts getCounts() {
            return this.counts;
        }
    }

    public class TiledIterator
    implements CloseableIterator<Alignment> {
        Iterator<Alignment> currentSamIterator;
        int end;
        Alignment nextRecord;
        int start;
        List<Alignment> alignments;

        TiledIterator(int start, int end, List<Alignment> alignments) {
            this.alignments = alignments;
            this.start = start;
            this.end = end;
            this.currentSamIterator = alignments.iterator();
            this.advanceToFirstRecord();
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.nextRecord != null;
        }

        @Override
        public Alignment next() {
            Alignment ret = this.nextRecord;
            this.advanceToNextRecord();
            return ret;
        }

        @Override
        public void remove() {
        }

        private void advanceToFirstRecord() {
            this.advanceToNextRecord();
        }

        private void advanceToNextRecord() {
            this.advance();
            while (this.nextRecord != null && this.nextRecord.getEnd() < this.start) {
                this.advance();
            }
        }

        private void advance() {
            if (this.currentSamIterator.hasNext()) {
                this.nextRecord = this.currentSamIterator.next();
                if (this.nextRecord.getAlignmentStart() > this.end) {
                    this.nextRecord = null;
                }
            } else {
                this.nextRecord = null;
            }
        }
    }
}

