/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.rank;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math.stat.descriptive.AbstractUnivariateStatistic;

public class Percentile
extends AbstractUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -8091216485095130416L;
    private double quantile = 0.0;

    public Percentile() {
        this(50.0);
    }

    public Percentile(double p2) {
        this.setQuantile(p2);
    }

    public double evaluate(double[] values, double p2) {
        this.test(values, 0, 0);
        return this.evaluate(values, 0, values.length, p2);
    }

    public double evaluate(double[] values, int start, int length) {
        return this.evaluate(values, start, length, this.quantile);
    }

    public double evaluate(double[] values, int begin, int length, double p2) {
        this.test(values, begin, length);
        if (p2 > 100.0 || p2 <= 0.0) {
            throw new IllegalArgumentException("invalid quantile value: " + p2);
        }
        if (length == 0) {
            return Double.NaN;
        }
        if (length == 1) {
            return values[begin];
        }
        double n2 = length;
        double pos = p2 * (n2 + 1.0) / 100.0;
        double fpos = Math.floor(pos);
        int intPos = (int)fpos;
        double dif = pos - fpos;
        double[] sorted = new double[length];
        System.arraycopy(values, begin, sorted, 0, length);
        Arrays.sort(sorted);
        if (pos < 1.0) {
            return sorted[0];
        }
        if (pos >= n2) {
            return sorted[length - 1];
        }
        double lower = sorted[intPos - 1];
        double upper = sorted[intPos];
        return lower + dif * (upper - lower);
    }

    public double getQuantile() {
        return this.quantile;
    }

    public void setQuantile(double p2) {
        if (p2 <= 0.0 || p2 > 100.0) {
            throw new IllegalArgumentException("Illegal quantile value: " + p2);
        }
        this.quantile = p2;
    }
}

