/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.alignments;

import edu.cornell.med.icb.goby.alignments.Alignments;
import edu.cornell.med.icb.goby.modes.UpgradeMode;
import edu.cornell.med.icb.goby.util.FileExtensionHelper;
import edu.cornell.med.icb.identifier.IndexedIdentifier;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractAlignmentReader
implements Closeable,
Iterator<Alignments.AlignmentEntry>,
Iterable<Alignments.AlignmentEntry> {
    protected IndexedIdentifier queryIdentifiers;
    protected int numberOfQueries;
    protected IndexedIdentifier targetIdentifiers;
    protected int numberOfTargets;
    protected int[] targetLengths;
    private boolean headerLoaded;
    protected boolean constantQueryLengths;
    protected int constantLength;
    protected int smallestQueryIndex;
    protected int largestQueryIndex;
    protected String alignerName;
    protected String alignerVersion;
    protected ObjectArrayList<String> sampleBasenames = new ObjectArrayList();

    protected AbstractAlignmentReader(boolean upgrade, String basename) {
        if (basename != null && upgrade) {
            UpgradeMode upgrader = new UpgradeMode();
            upgrader.setSilent(true);
            upgrader.upgrade(basename);
        }
    }

    public static String getBasename(String filename) {
        for (String ext : FileExtensionHelper.COMPACT_ALIGNMENT_FILE_EXTS) {
            if (!StringUtils.endsWith(filename, ext)) continue;
            return StringUtils.removeEnd(filename, ext);
        }
        return filename;
    }

    public static String[] getBasenames(String ... filenames) {
        ObjectArraySet result = new ObjectArraySet();
        ObjectArrayList unique = new ObjectArrayList();
        if (filenames != null) {
            for (String filename : filenames) {
                String newBasename = AbstractAlignmentReader.getBasename(filename);
                if (result.contains(newBasename)) continue;
                unique.add(newBasename);
                result.add(AbstractAlignmentReader.getBasename(filename));
            }
        }
        return unique.toArray(new String[unique.size()]);
    }

    public int getSmallestSplitQueryIndex() {
        return this.smallestQueryIndex;
    }

    public int getLargestSplitQueryIndex() {
        return this.largestQueryIndex;
    }

    public int getNumberOfQueries() {
        assert (this.isHeaderLoaded()) : "Header must be loaded to access number of queries";
        return Math.max(this.numberOfQueries, 0);
    }

    protected boolean isHeaderLoaded() {
        return this.headerLoaded;
    }

    protected void setHeaderLoaded(boolean headerLoaded) {
        this.headerLoaded = headerLoaded;
    }

    public abstract void readHeader() throws IOException;

    public final IndexedIdentifier getQueryIdentifiers() {
        assert (this.isHeaderLoaded()) : "Header must be loaded to access query identifiers";
        return this.queryIdentifiers;
    }

    public final IndexedIdentifier getTargetIdentifiers() {
        assert (this.isHeaderLoaded()) : "Header must be loaded to access target identifiers";
        return this.targetIdentifiers;
    }

    public int getNumberOfTargets() {
        assert (this.isHeaderLoaded()) : "Header must be loaded to access number of targets";
        return Math.max(0, this.numberOfTargets);
    }

    public final int getTargetLength(int targetIndex) {
        assert (this.isHeaderLoaded()) : "Header must be loaded to access target lengths";
        assert (this.targetLengths != null) : "Target lengths must exist in the header.";
        return this.targetLengths[targetIndex];
    }

    public final int[] getTargetLength() {
        assert (this.isHeaderLoaded()) : "Header must be loaded to access target lengths";
        return this.targetLengths;
    }

    public boolean isConstantQueryLengths() {
        return this.constantQueryLengths;
    }

    public String getAlignerName() {
        return this.alignerName;
    }

    public String getAlignerVersion() {
        return this.alignerVersion;
    }

    public String getSampleBasename(int sampleIndex) {
        return this.sampleBasenames.get(sampleIndex);
    }
}

