/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import edu.mit.broad.prodinfo.genomicplot.ParseException;
import edu.mit.broad.prodinfo.multiplealignment.MAFAlignment;
import edu.mit.broad.prodinfo.multiplealignment.MAFIO;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignment;
import edu.mit.broad.prodinfo.sequence.Sequence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class VirusMafTest {
    public static void main(String[] args) throws Exception {
        String in = "/Users/jrobinso/IGV/virus/poxvirus.1.USA_2003_044.maf";
        VirusMafTest.printSeqNames(in);
        VirusMafTest.load(in);
    }

    private static void printSeqNames(String in) throws IOException, ParseException {
        MAFIO mafio = new MAFIO();
        MAFAlignment maf = mafio.load(in);
        System.out.println(maf.getReferenceId());
        for (MultipleAlignment.AlignedSequence seq : maf.getAlignedSequences()) {
            System.out.println(seq.getId());
        }
    }

    private static void load(String in) throws ParseException, IOException {
        int i2;
        int start = 0;
        int end = 100;
        MAFIO mafio = new MAFIO();
        ArrayList<String> seqToLoad = new ArrayList<String>();
        seqToLoad.add("USA_2003_044");
        seqToLoad.add("USA_2003_039");
        MAFAlignment maf = mafio.load(in, seqToLoad, start, end);
        maf.load(in, start, end);
        List<MultipleAlignment.AlignedSequence> sequences = maf.getAlignedSequences();
        System.out.println("Ref start = " + maf.getReferenceStart());
        MultipleAlignment.AlignedSequence seq0 = sequences.get(0);
        for (Integer i3 : seq0.getGapSizes()) {
            System.out.print(i3 + " ");
        }
        System.out.println();
        System.out.println("Ungapped length = " + seq0.getUngappedLength());
        System.out.println("Seq length = " + seq0.getLength());
        System.out.println("Seq size =" + seq0.getSequenceBases().length());
        System.out.println("Gap=" + seq0.getGapsSize() + "\t");
        for (i2 = 0; i2 < seq0.getLength(); ++i2) {
            System.out.print(seq0.getGapAdjustedCoordinate(i2) + " ");
        }
        System.out.println();
        for (i2 = 0; i2 < seq0.getLength(); ++i2) {
            System.out.print(seq0.getSequencePosition(i2) + " ");
        }
        System.out.println();
        for (MultipleAlignment.AlignedSequence sequence : sequences) {
            Sequence seq = sequence.getSequence();
            System.out.println("Start = " + sequence.getStart());
            for (int i4 = 0; i4 < seq.getSequenceBases().length(); ++i4) {
                System.out.print(seq0.getGapAdjustedCoordinate(i4) + " ");
            }
            System.out.println();
            System.out.print(sequence.getId() + "\t");
            System.out.println(seq.getSequenceBases());
        }
    }
}

