/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil;

import it.unimi.dsi.fastutil.BigSwapper;
import it.unimi.dsi.fastutil.longs.LongComparator;

public class BigArrays {
    public static final int SEGMENT_SHIFT = 27;
    public static final int SEGMENT_SIZE = 0x8000000;
    public static final int SEGMENT_MASK = 0x7FFFFFF;
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    protected BigArrays() {
    }

    public static int segment(long index) {
        return (int)(index >>> 27);
    }

    public static int displacement(long index) {
        return (int)(index & 0x7FFFFFFL);
    }

    public static long start(int segment) {
        return (long)segment << 27;
    }

    public static long index(int segment, int displacement) {
        return BigArrays.start(segment) + (long)displacement;
    }

    public static void ensureFromTo(long bigArrayLength, long from, long to) {
        if (from < 0L) {
            throw new ArrayIndexOutOfBoundsException("Start index (" + from + ") is negative");
        }
        if (from > to) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        if (to > bigArrayLength) {
            throw new ArrayIndexOutOfBoundsException("End index (" + to + ") is greater than big-array length (" + bigArrayLength + ")");
        }
    }

    public static void ensureOffsetLength(long bigArrayLength, long offset, long length) {
        if (offset < 0L) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("Length (" + length + ") is negative");
        }
        if (offset + length > bigArrayLength) {
            throw new ArrayIndexOutOfBoundsException("Last index (" + (offset + length) + ") is greater than big-array length (" + bigArrayLength + ")");
        }
    }

    private static void inPlaceMerge(long from, long mid, long to, LongComparator comp, BigSwapper swapper) {
        long secondCut;
        long firstCut;
        if (from >= mid || mid >= to) {
            return;
        }
        if (to - from == 2L) {
            if (comp.compare(mid, from) < 0) {
                swapper.swap(from, mid);
            }
            return;
        }
        if (mid - from > to - mid) {
            firstCut = from + (mid - from) / 2L;
            secondCut = BigArrays.lowerBound(mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2L;
            firstCut = BigArrays.upperBound(from, mid, secondCut, comp);
        }
        long first2 = firstCut;
        long middle2 = mid;
        long last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            long first1 = first2;
            long last1 = middle2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
        }
        mid = firstCut + (secondCut - mid);
        BigArrays.inPlaceMerge(from, firstCut, mid, comp, swapper);
        BigArrays.inPlaceMerge(mid, secondCut, to, comp, swapper);
    }

    private static long lowerBound(long mid, long to, long firstCut, LongComparator comp) {
        long len = to - mid;
        while (len > 0L) {
            long half = len / 2L;
            long middle = mid + half;
            if (comp.compare(middle, firstCut) < 0) {
                mid = middle + 1L;
                len -= half + 1L;
                continue;
            }
            len = half;
        }
        return mid;
    }

    private static long med3(long a2, long b2, long c2, LongComparator comp) {
        int ab = comp.compare(a2, b2);
        int ac = comp.compare(a2, c2);
        int bc = comp.compare(b2, c2);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    public static void mergeSort(long from, long to, LongComparator comp, BigSwapper swapper) {
        long length = to - from;
        if (length < 7L) {
            for (long i2 = from; i2 < to; ++i2) {
                for (long j2 = i2; j2 > from && comp.compare(j2 - 1L, j2) > 0; --j2) {
                    swapper.swap(j2, j2 - 1L);
                }
            }
            return;
        }
        long mid = from + to >>> 1;
        BigArrays.mergeSort(from, mid, comp, swapper);
        BigArrays.mergeSort(mid, to, comp, swapper);
        if (comp.compare(mid - 1L, mid) <= 0) {
            return;
        }
        BigArrays.inPlaceMerge(from, mid, to, comp, swapper);
    }

    public static void quickSort(long from, long to, LongComparator comp, BigSwapper swapper) {
        long c2;
        long a2;
        long len = to - from;
        if (len < 7L) {
            for (long i2 = from; i2 < to; ++i2) {
                for (long j2 = i2; j2 > from && comp.compare(j2 - 1L, j2) > 0; --j2) {
                    swapper.swap(j2, j2 - 1L);
                }
            }
            return;
        }
        long m2 = from + len / 2L;
        if (len > 7L) {
            long l2 = from;
            long n2 = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l2 = BigArrays.med3(l2, l2 + s, l2 + 2L * s, comp);
                m2 = BigArrays.med3(m2 - s, m2, m2 + s, comp);
                n2 = BigArrays.med3(n2 - 2L * s, n2 - s, n2, comp);
            }
            m2 = BigArrays.med3(l2, m2, n2, comp);
        }
        long b2 = a2 = from;
        long d2 = c2 = to - 1L;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(b2, m2)) <= 0) {
                if (comparison == 0) {
                    if (a2 == m2) {
                        m2 = b2;
                    } else if (b2 == m2) {
                        m2 = a2;
                    }
                    swapper.swap(a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(c2, m2)) >= 0) {
                if (comparison == 0) {
                    if (c2 == m2) {
                        m2 = d2;
                    } else if (d2 == m2) {
                        m2 = c2;
                    }
                    swapper.swap(c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            if (b2 == m2) {
                m2 = d2;
            } else if (c2 == m2) {
                m2 = c2;
            }
            swapper.swap(b2++, c2--);
        }
        long n3 = from + len;
        long s = Math.min(a2 - from, b2 - a2);
        BigArrays.vecSwap(swapper, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1L);
        BigArrays.vecSwap(swapper, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1L) {
            BigArrays.quickSort(from, from + s, comp, swapper);
        }
        if ((s = d2 - c2) > 1L) {
            BigArrays.quickSort(n3 - s, n3, comp, swapper);
        }
    }

    private static long upperBound(long from, long mid, long secondCut, LongComparator comp) {
        long len = mid - from;
        while (len > 0L) {
            long half = len / 2L;
            long middle = from + half;
            if (comp.compare(secondCut, middle) < 0) {
                len = half;
                continue;
            }
            from = middle + 1L;
            len -= half + 1L;
        }
        return from;
    }

    private static void vecSwap(BigSwapper swapper, long from, long l2, long s) {
        int i2 = 0;
        while ((long)i2 < s) {
            swapper.swap(from, l2);
            ++i2;
            ++from;
            ++l2;
        }
    }
}

