/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.log4j.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.svg.SVGGraphics;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.Utilities;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SnapshotUtilities {
    private static Logger logger = Logger.getLogger(SnapshotUtilities.class);
    private static LinkedHashMap<SnapshotFileType, SnapshotFileFilter> SNAPSHOT_TYPE_TO_FILTER = new LinkedHashMap();
    public static int MAX_PANEL_HEIGHT = 1000;

    public static FileFilter[] getAllSnapshotFileFilters() {
        return SNAPSHOT_TYPE_TO_FILTER.values().toArray(new FileFilter[SNAPSHOT_TYPE_TO_FILTER.size()]);
    }

    public static SnapshotFileFilter getSnapshotFileFilterForType(SnapshotFileType type) {
        return SNAPSHOT_TYPE_TO_FILTER.get((Object)type);
    }

    public static BufferedImage getDeviceCompatibleImage(int width, int height) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice screenDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicConfiguration = screenDevice.getDefaultConfiguration();
        BufferedImage image = graphicConfiguration.createCompatibleImage(width, height);
        return image;
    }

    public static String getFileExtension(String filePath) {
        String extension = null;
        int indexOfExtension = filePath.lastIndexOf(".");
        if (indexOfExtension >= 0) {
            extension = filePath.substring(indexOfExtension, filePath.length());
        }
        return extension;
    }

    public static SnapshotFileType getSnapshotFileType(String fileExtension) {
        String extension = fileExtension.toLowerCase();
        SnapshotFileType type = null;
        type = SnapshotFileType.EPS.getExtension().equals(extension) ? SnapshotFileType.EPS : (SnapshotFileType.PDF.getExtension().equals(extension) ? SnapshotFileType.PDF : (SnapshotFileType.SVG.getExtension().equals(extension) ? SnapshotFileType.SVG : (SnapshotFileType.PNG.getExtension().equals(extension) ? SnapshotFileType.PNG : (SnapshotFileType.JPEG.getExtension().equals(extension) ? SnapshotFileType.JPEG : SnapshotFileType.NULL))));
        return type;
    }

    public static void doComponentSnapshot(Component component, File file, SnapshotFileType type) {
        int width = component.getWidth();
        int height = component.getHeight();
        switch (type) {
            case JPEG: {
                SnapshotUtilities.exportScreenShotJPEG(component, file, width, height);
                break;
            }
            case PNG: {
                SnapshotUtilities.exportScreenShotPNG(component, file, width, height);
                break;
            }
            case SVG: {
                logger.debug("Exporting svg screenshot");
                SnapshotUtilities.exportScreenshotSVG(component, file);
            }
        }
    }

    private static void exportScreenshotSVG2(Component target, File selecteddFile) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(selecteddFile));
            pw.println("<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \n\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n\n<svg width=\"100%\" height=\"100%\" version=\"1.1\"\nxmlns=\"http://www.w3.org/2000/svg\">");
            SVGGraphics g2d = new SVGGraphics(pw);
            target.paint(g2d);
            pw.print("</svg>");
            pw.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private static void exportScreenshotSVG(Component target, File selectedFile) {
        try {
            logger.debug("Getting dom");
            DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
            String svgNS = "http://www.w3.org/2000/svg";
            Document document = domImpl.createDocument(svgNS, "svg", null);
            SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
            target.paintAll(svgGenerator);
            boolean useCSS = true;
            BufferedWriter out = new BufferedWriter(new FileWriter(selectedFile));
            svgGenerator.stream(out, useCSS);
        }
        catch (Exception e2) {
            logger.error("Error creating SVG file", e2);
            MessageUtils.showMessage("Error encountered creating SVG file: " + e2.toString());
        }
    }

    private static void exportScreenShotJPEG(Component target, File selectedFile, int width, int height) {
        BufferedImage image = SnapshotUtilities.getDeviceCompatibleImage(width, height);
        Graphics2D g2 = image.createGraphics();
        target.paintAll(g2);
        if (selectedFile != null) {
            if (!selectedFile.getName().toLowerCase().endsWith(".jpeg")) {
                String correctedFilename = selectedFile.getAbsolutePath() + ".jpeg";
                selectedFile = new File(correctedFilename);
            }
            SnapshotUtilities.writeImage(image, selectedFile, "jpeg");
        }
    }

    private static void exportScreenShotPNG(Component target, File selectedFile, int width, int height) {
        BufferedImage image = SnapshotUtilities.getDeviceCompatibleImage(width, height);
        Graphics2D g2 = image.createGraphics();
        target.paintAll(g2);
        if (selectedFile != null) {
            if (!selectedFile.getName().toLowerCase().endsWith(".png")) {
                String correctedFilename = selectedFile.getAbsolutePath() + ".png";
                selectedFile = new File(correctedFilename);
            }
            SnapshotUtilities.writeImage(image, selectedFile, "png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doSnapshotOffscreen(Component target, File selectedFile) {
        if (!(target instanceof Paintable)) {
            return "Error: target is not paintable";
        }
        try {
            int height;
            IGV.getInstance().setExportingSnapshot(true);
            Rectangle rect = target.getBounds();
            rect.height = height = ((MainPanel)target).getOffscreenImageHeight();
            int dx = rect.x;
            int dy = rect.y;
            rect.x = 0;
            rect.y = 0;
            rect.width -= dx;
            rect.height -= dy;
            Paintable paintable = (Paintable)((Object)target);
            String filenameLowercase = selectedFile.getName().toLowerCase();
            if (filenameLowercase.endsWith(".svg")) {
                logger.debug("Getting dom");
                DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
                String svgNS = "http://www.w3.org/2000/svg";
                Document document = domImpl.createDocument(svgNS, "svg", null);
                SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
                paintable.paintOffscreen(svgGenerator, rect);
                boolean useCSS = true;
                BufferedWriter out = new BufferedWriter(new FileWriter(selectedFile));
                svgGenerator.stream(out, useCSS);
            } else {
                BufferedImage image = SnapshotUtilities.getDeviceCompatibleImage(rect.width, rect.height);
                Graphics2D g2 = image.createGraphics();
                paintable.paintOffscreen(g2, rect);
                if (selectedFile != null) {
                    if (!filenameLowercase.endsWith(".png")) {
                        String correctedFilename = selectedFile.getAbsolutePath() + ".png";
                        selectedFile = new File(correctedFilename);
                    }
                    String type = selectedFile.getName().substring(selectedFile.getName().length() - 3).toLowerCase();
                    SnapshotUtilities.writeImage(image, selectedFile, "png");
                }
            }
        }
        catch (Exception e2) {
            logger.error("Error creating snapshot", e2);
            String string = "Error: " + e2.toString();
            return string;
        }
        finally {
            IGV.getInstance().setExportingSnapshot(false);
        }
        return "OK";
    }

    private static void writeImage(BufferedImage image, File f2, String type) {
        try {
            ImageIO.write((RenderedImage)image, type, f2);
        }
        catch (IOException e2) {
            logger.error("Error creating: " + f2.getAbsolutePath(), e2);
        }
    }

    static {
        SNAPSHOT_TYPE_TO_FILTER.put(SnapshotFileType.JPEG, new SnapshotFileFilter(SnapshotFileType.JPEG));
        SNAPSHOT_TYPE_TO_FILTER.put(SnapshotFileType.SVG, new SnapshotFileFilter(SnapshotFileType.SVG));
        SNAPSHOT_TYPE_TO_FILTER.put(SnapshotFileType.PNG, new SnapshotFileFilter(SnapshotFileType.PNG));
    }

    public static class SnapshotFileChooser
    extends JFileChooser {
        boolean accepted = false;
        File previousFile;

        public SnapshotFileChooser(File directory, File selectedFile) {
            super(directory);
            this.setPreviousFile(selectedFile);
            this.init();
        }

        @Override
        public void approveSelection() {
            this.accepted = true;
            super.approveSelection();
        }

        public void setPreviousFile(File file) {
            this.previousFile = file;
            this.setSelectedFile(this.previousFile);
        }

        public File getPreviousFile() {
            return this.previousFile;
        }

        @Override
        public void cancelSelection() {
            this.setSelectedFile(null);
            super.cancelSelection();
        }

        @Override
        protected JDialog createDialog(Component parent) throws HeadlessException {
            JDialog dialog = super.createDialog(parent);
            dialog.setLocation(300, 200);
            dialog.setResizable(false);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e2) {
                    if (!SnapshotFileChooser.this.accepted) {
                        SnapshotFileChooser.this.setSelectedFile(null);
                    }
                }
            });
            return dialog;
        }

        private void init() {
            FileFilter[] fileFilters = SnapshotUtilities.getAllSnapshotFileFilters();
            if (fileFilters != null) {
                for (FileFilter fileFilter : fileFilters) {
                    this.addChoosableFileFilter(fileFilter);
                }
            }
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e2) {
                    File oldFile = null;
                    String property = e2.getPropertyName();
                    if ("SelectedFileChangedProperty".equals(property)) {
                        oldFile = (File)e2.getOldValue();
                    } else if ("fileFilterChanged".equals(property) && e2.getOldValue() instanceof SnapshotFileFilter && e2.getNewValue() instanceof SnapshotFileFilter) {
                        SnapshotFileFilter newFilter = (SnapshotFileFilter)e2.getNewValue();
                        File currentDirectory = SnapshotFileChooser.this.getCurrentDirectory();
                        File previousFile = SnapshotFileChooser.this.getPreviousFile();
                        if (previousFile != null) {
                            File file = null;
                            file = currentDirectory != null ? new File(currentDirectory, previousFile.getName()) : previousFile;
                            final File selectedFile = Utilities.changeFileExtension(file, newFilter.getExtension());
                            UIUtilities.invokeOnEventThread(new Runnable(){

                                @Override
                                public void run() {
                                    SnapshotFileChooser.this.setPreviousFile(selectedFile);
                                    SnapshotFileChooser.this.validate();
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    public static class SnapshotFileFilter
    extends FileFilter {
        private SnapshotFileType type = SnapshotFileType.EPS;

        public SnapshotFileFilter(SnapshotFileType type) {
            this.type = type;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(this.type.getExtension());
        }

        @Override
        public String getDescription() {
            return this.type.getDescription();
        }

        public String getExtension() {
            return this.type.getExtension();
        }

        public boolean accept(File file, String name) {
            return name.toLowerCase().endsWith(this.type.getExtension());
        }
    }

    public static enum SnapshotFileType {
        NULL("", ""),
        EPS(".eps", "Encapsulated Postscript Files (*.eps)"),
        PDF(".pdf", "Portable Document FormatFles (*.pdf)"),
        SVG(".svg", "Scalable Vector Graphics Files (*.svg)"),
        PNG(".png", "Portable Network Graphics Files (*.png)"),
        JPEG(".jpeg", "Joint Photographic Experts Group Files (*.jpeg)");

        private String fileExtension;
        private String fileDescription;

        private SnapshotFileType(String extension, String description) {
            this.fileExtension = extension;
            this.fileDescription = description;
        }

        public String getExtension() {
            return this.fileExtension;
        }

        public String getDescription() {
            return this.fileDescription;
        }
    }
}

