/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.maf.MAFConfigurationDialog;
import org.broad.igv.maf.MAFManager;
import org.broad.igv.maf.MAFRenderer;
import org.broad.igv.maf.MAFTile;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;

public class MAFTrack
extends AbstractTrack {
    public static final int margin = 5;
    private static Logger log = Logger.getLogger(MAFTrack.class);
    private static int EXPANDED_HEIGHT = 14;
    private static int GAPS_HEIGHT = 25;
    MAFManager mgr;
    MAFRenderer renderer = new MAFRenderer();
    Rectangle visibleNameRect;

    public MAFTrack(ResourceLocator locator) {
        super(locator);
        this.mgr = new MAFManager(locator);
    }

    @Override
    public int getHeight() {
        return GAPS_HEIGHT + (this.mgr.getSelectedSpecies().size() + 1) * EXPANDED_HEIGHT;
    }

    @Override
    public void renderName(Graphics2D g2D, Rectangle trackRectangle, Rectangle visibleRectangle) {
        this.visibleNameRect = trackRectangle;
        if (this.isSelected()) {
            g2D.setBackground(Color.LIGHT_GRAY);
        } else {
            g2D.setBackground(Color.WHITE);
        }
        Rectangle rect = new Rectangle(trackRectangle);
        g2D.clearRect(rect.x, rect.y, rect.width, rect.height);
        Font font = FontManager.getFont(this.fontSize);
        g2D.setFont(font);
        int y = trackRectangle.y;
        rect.height = GAPS_HEIGHT;
        rect.y = y;
        GraphicUtils.drawVerticallyCenteredText("Gaps", 5, rect, g2D, true);
        rect.y += rect.height;
        rect.height = EXPANDED_HEIGHT;
        String ref = MAFManager.speciesNames.getProperty(this.mgr.refId);
        if (ref == null) {
            ref = this.mgr.refId;
        }
        GraphicUtils.drawVerticallyCenteredText(ref, 5, rect, g2D, true);
        rect.y += rect.height;
        for (String sp : this.mgr.getSelectedSpecies()) {
            String name = MAFManager.speciesNames.getProperty(sp);
            if (name == null) {
                name = sp;
            }
            if (visibleRectangle.intersects(rect)) {
                GraphicUtils.drawVerticallyCenteredText(name, 5, rect, g2D, true);
            }
            rect.y += rect.height;
        }
    }

    @Override
    public void setColorScale(ContinuousColorScale colorScale) {
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        int end;
        int start;
        double locScale = context.getScale();
        if (locScale > 1.0) {
            Rectangle r = new Rectangle(rect);
            if (this.visibleNameRect != null) {
                r.y = this.visibleNameRect.y;
                r.height = this.visibleNameRect.height;
            }
            Graphics2D g2 = context.getGraphic2DForColor(Color.black);
            GraphicUtils.drawCenteredText("Zoom in to see alignments.", r, g2);
            return;
        }
        double origin = context.getOrigin();
        String chr = context.getChr();
        MAFTile[] tiles = this.mgr.getTiles(chr, start = (int)origin, end = (int)(origin + (double)rect.width * locScale) + 1);
        if (tiles != null) {
            for (MAFTile tile : tiles) {
                if (tile == null) continue;
                this.renderTile(context, rect, tile);
            }
        }
    }

    private void renderTile(RenderContext context, Rectangle trackRectangle, MAFTile tile) {
        int y = trackRectangle.y;
        MAFTile.MASequence reference = tile.refSeq;
        if (reference == null) {
            return;
        }
        Rectangle rect = new Rectangle(trackRectangle);
        rect.height = GAPS_HEIGHT;
        rect.y = y;
        this.renderer.renderGaps(tile.getGaps(), context, rect);
        rect.y += rect.height;
        rect.height = EXPANDED_HEIGHT;
        this.renderer.renderAligment(reference, reference, null, context, rect, this);
        rect.y += rect.height;
        for (String sp : this.mgr.getSelectedSpecies()) {
            MAFTile.MASequence seq = tile.alignedSequences.get(sp);
            if (seq != null) {
                this.renderer.renderAligment(seq, reference, tile.getGaps(), context, rect, this);
            }
            rect.y += rect.height;
        }
    }

    @Override
    public void setWindowFunction(WindowFunction type) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return null;
    }

    @Override
    public void setRendererClass(Class rc) {
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        return "Multiple alignments";
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, ReferenceFrame frame) {
        return 0.0f;
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        MouseEvent e2 = te.getMouseEvent();
        if (e2.isPopupTrigger()) {
            this.configureTrack();
            return true;
        }
        return false;
    }

    private void configureTrack() {
        MAFConfigurationDialog dialog = new MAFConfigurationDialog(IGV.getMainFrame(), true, this.mgr);
        dialog.setLocationRelativeTo(IGV.getMainFrame());
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        dialog.setVisible(true);
        if (!dialog.cancelled) {
            List<String> selectedSpecies = dialog.getSelectedSpecies();
            this.mgr.setSelectedSpecies(selectedSpecies);
            PreferenceManager.getInstance().setMafSpecies(selectedSpecies);
            IGV.getInstance().repaint();
        }
    }
}

