/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.tribble.BEDCodec;
import org.broad.igv.feature.tribble.GFFCodec;
import org.broad.igv.feature.tribble.PSLCodec;
import org.broad.igv.feature.tribble.REPMaskCodec;
import org.broad.igv.feature.tribble.SAMCodec;
import org.broad.igv.feature.tribble.VCFWrapperCodec;
import org.broad.igv.peaks.PeakCodec;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.util.BlockCompressedInputStream;
import org.broad.tribble.util.SeekableStreamFactory;
import org.broadinstitute.sting.utils.codecs.vcf.VCF3Codec;
import org.broadinstitute.sting.utils.codecs.vcf.VCFCodec;

public class CodecFactory {
    private static Logger log = Logger.getLogger(CodecFactory.class);

    public static FeatureCodec getCodec(String path) {
        String fn = path.toLowerCase();
        if (fn.endsWith(".gz")) {
            int l2 = fn.length() - 3;
            fn = fn.substring(0, l2);
        }
        if (fn.endsWith(".vcf4")) {
            return new VCFWrapperCodec(new VCFCodec());
        }
        if (fn.endsWith(".vcf")) {
            return new VCFWrapperCodec(CodecFactory.getVCFCodec(path));
        }
        if (fn.endsWith(".bed")) {
            return new BEDCodec();
        }
        if (fn.endsWith(".repmask")) {
            return new REPMaskCodec();
        }
        if (fn.endsWith(".gff3")) {
            return new GFFCodec(GFFCodec.Version.GFF3);
        }
        if (fn.endsWith(".gff") || fn.endsWith(".gtf")) {
            return new GFFCodec();
        }
        if (fn.endsWith(".sam")) {
            return new SAMCodec();
        }
        if (fn.endsWith(".psl") || fn.endsWith(".pslx")) {
            return new PSLCodec();
        }
        if (fn.endsWith(".peak")) {
            return new PeakCodec();
        }
        throw new DataLoadException("Unknown file type", path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FeatureCodec getVCFCodec(String path) {
        BufferedReader reader = null;
        try {
            String formatLine;
            reader = path.toLowerCase().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new BlockCompressedInputStream(SeekableStreamFactory.getStreamFor(path)))) : ParsingUtils.openBufferedReader(path);
            for (int lineCount = 0; (formatLine = reader.readLine()) != null && lineCount < 20; ++lineCount) {
                String[] tmp;
                if (!formatLine.toLowerCase().startsWith("##fileformat") || (tmp = formatLine.split("=")).length <= 1) continue;
                String version = tmp[1].toLowerCase();
                if (version.startsWith("vcfv3")) {
                    VCF3Codec vCF3Codec = new VCF3Codec();
                    return vCF3Codec;
                }
                VCFCodec vCFCodec = new VCFCodec();
                return vCFCodec;
            }
        }
        catch (IOException e2) {
            log.error("Error checking VCF Version");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new VCFCodec();
    }
}

