/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.util.ArrayList;
import java.util.List;
import org.broad.igv.feature.Cytoband;

public class Chromosome {
    private String name;
    private int length = 0;
    private List<Cytoband> cytobands;

    public Chromosome(String name) {
        this.name = name;
    }

    public Chromosome(String name, int length) {
        this.name = name;
        this.length = length;
    }

    public List<Cytoband> getCytobands() {
        return this.cytobands;
    }

    public void addCytoband(Cytoband band) {
        if (this.cytobands == null) {
            this.cytobands = new ArrayList<Cytoband>();
        }
        this.cytobands.add(band);
        this.length = Math.max(this.length, band.getEnd());
    }

    public int getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }
}

