/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.seg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.Globals;
import org.broad.igv.data.seg.SegmentedDataSet;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.WindowFunction;

public class FreqData {
    private static final float AMP_THRESHOLD = 0.1f;
    private static final float DEL_THRESHOLD = -0.1f;
    private int numberOfSamples;
    boolean logNormalized;
    Map<String, List<LocusScore>> amp;
    Map<String, List<LocusScore>> del;

    public FreqData(SegmentedDataSet ds, Genome genome) {
        this.compute(ds, genome);
    }

    void compute(SegmentedDataSet ds, Genome genome) {
        this.logNormalized = ds.isLogNormalized();
        int binSize = 200000;
        int sizeInKB = (int)(genome.getLength() / 1000L);
        int wgBinSize = sizeInKB / 700;
        int wgBinCount = sizeInKB / wgBinSize + 1;
        this.numberOfSamples = ds.getSampleNames().size();
        this.amp = new HashMap<String, List<LocusScore>>();
        this.del = new HashMap<String, List<LocusScore>>();
        for (String chr : genome.getChromosomeNames()) {
            Chromosome c2 = genome.getChromosome(chr);
            int len = c2.getLength();
            int nBins = len / binSize + 1;
            ArrayList<Bin> ampBins = new ArrayList<Bin>(nBins);
            ArrayList<Bin> delBins = new ArrayList<Bin>(nBins);
            for (int i2 = 0; i2 < nBins; ++i2) {
                int s = i2 * binSize;
                int e2 = s + binSize;
                ampBins.add(new Bin(chr, s, e2));
                delBins.add(new Bin(chr, s, e2));
            }
            this.amp.put(chr, ampBins);
            this.del.put(chr, delBins);
        }
        ArrayList<Bin> ampBins = new ArrayList<Bin>(wgBinCount);
        ArrayList<Bin> delBins = new ArrayList<Bin>(wgBinCount);
        for (int i3 = 0; i3 < wgBinCount; ++i3) {
            int s = i3 * wgBinSize;
            int e3 = s + wgBinSize;
            ampBins.add(new Bin("All", s, e3));
            delBins.add(new Bin("All", s, e3));
        }
        this.amp.put("All", ampBins);
        this.del.put("All", delBins);
        for (String sample : ds.getSampleNames()) {
            for (String chr : genome.getChromosomeNames()) {
                List<LocusScore> segments = ds.getSegments(sample, chr);
                if (segments == null) continue;
                for (LocusScore seg : segments) {
                    float segScore;
                    float f2 = segScore = this.logNormalized ? seg.getScore() : (float)(Math.log(seg.getScore() / 2.0f) / Globals.log2);
                    if (!(segScore > 0.1f) && !(segScore < -0.1f)) continue;
                    int startBin = seg.getStart() / binSize;
                    int endBin = seg.getEnd() / binSize;
                    for (int b2 = startBin; b2 <= endBin && b2 < this.amp.get(chr).size(); ++b2) {
                        this.binCounts(chr, seg.getStart(), seg.getEnd(), segScore, b2, binSize);
                    }
                    int gStart = genome.getGenomeCoordinate(chr, seg.getStart());
                    int gEnd = genome.getGenomeCoordinate(chr, seg.getEnd());
                    int wgStartBin = gStart / wgBinSize;
                    int wgEndBin = gEnd / wgBinSize;
                    for (int b3 = wgStartBin; b3 <= wgEndBin && b3 < this.amp.get("All").size(); ++b3) {
                        this.binCounts("All", gStart, gEnd, segScore, b3, wgBinSize);
                    }
                }
            }
        }
    }

    private void binCounts(String chr, int segStart, int segEnd, float segScore, int b2, int binSize) {
        int binStart = b2 * binSize;
        int binEnd = binStart + binSize;
        float weight = 1.0f;
        if (segEnd < binEnd) {
            int s = Math.max(segStart, binStart);
            weight = (float)(segEnd - s) / (float)binSize;
        } else if (segStart > binStart) {
            int e2 = Math.min(segEnd, binEnd);
            weight = (float)(e2 - segStart) / (float)binSize;
        }
        if (segScore > 0.1f) {
            Bin bin = (Bin)this.amp.get(chr).get(b2);
            bin.increment(weight, weight * segScore);
        }
        if (segScore < -0.1f) {
            Bin bin = (Bin)this.del.get(chr).get(b2);
            bin.increment(-weight, weight * segScore);
        }
    }

    public void dumpData(String chr) {
        System.out.println("track name=Amplifications");
        for (Map.Entry<String, List<LocusScore>> entry : this.amp.entrySet()) {
            if (entry.getKey().equals("All")) continue;
            for (LocusScore bin : entry.getValue()) {
                System.out.println(bin.getChr() + "\t" + bin.getStart() + "\t" + bin.getEnd() + "\t" + bin.getScore());
            }
        }
    }

    public int getNumberOfSamples() {
        return this.numberOfSamples;
    }

    public List<LocusScore> getAmpCounts(String chr) {
        return this.amp.get(chr);
    }

    public List<LocusScore> getDelCounts(String chr) {
        return this.del.get(chr);
    }

    public class Bin
    implements LocusScore {
        String chr;
        int start;
        int end;
        float count;
        private float totalCN;

        Bin(String chr, int start, int end) {
            this.chr = chr;
            this.start = start;
            this.end = end;
        }

        void increment(float count, float score) {
            this.count += count;
            this.totalCN = this.getTotalCN() + score;
        }

        float getCount() {
            return this.count;
        }

        float getAvgCN() {
            return this.count == 0.0f ? 0.0f : this.getTotalCN() / this.count;
        }

        @Override
        public String getChr() {
            return this.chr;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public void setStart(int start) {
        }

        @Override
        public void setEnd(int end) {
        }

        @Override
        public float getScore() {
            return this.getCount();
        }

        @Override
        public LocusScore copy() {
            return this;
        }

        @Override
        public String getValueString(double position, WindowFunction windowFunction) {
            int cnt = Math.abs(Math.round(this.count));
            int percent = cnt * 100 / FreqData.this.numberOfSamples;
            return cnt + " (" + percent + "%)";
        }

        public float getTotalCN() {
            return this.totalCN;
        }
    }
}

