/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.Timer;

public class InfiniteProgressPanel
extends JComponent
implements ActionListener {
    private static final int DEFAULT_NUMBER_OF_BARS = 12;
    private int numBars = 12;
    private double dScale = 1.2;
    private Area[] bars;
    private Rectangle barsBounds = null;
    private Rectangle barsScreenBounds = null;
    private AffineTransform centerAndScaleTransform = null;
    private Timer timer = new Timer(62, this);
    private Color[] colors = new Color[this.numBars * 2];
    private int colorOffset = 0;
    private boolean tempHide = false;
    private String text;

    public InfiniteProgressPanel() {
        this.bars = InfiniteProgressPanel.buildTicker(this.numBars);
        this.barsBounds = new Rectangle();
        for (Area area : this.bars) {
            this.barsBounds = this.barsBounds.union(area.getBounds());
        }
        for (int i2 = 0; i2 < this.bars.length; ++i2) {
            int n2 = 224 - 128 / (i2 + 1);
            this.colors[i2] = new Color(n2, n2, n2);
            this.colors[this.numBars + i2] = this.colors[i2];
        }
        this.setOpaque(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.colorOffset = this.colorOffset == this.numBars - 1 ? 0 : ++this.colorOffset;
        if (this.barsScreenBounds != null) {
            this.repaint(this.barsScreenBounds);
        } else {
            this.repaint();
        }
    }

    public void setVisible(boolean bl) {
        this.setOpaque(false);
        if (bl) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
        super.setVisible(bl);
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        super.setBounds(n2, n3, n4, n5);
        this.centerAndScaleTransform = new AffineTransform();
        this.centerAndScaleTransform.translate((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
        this.centerAndScaleTransform.scale(this.dScale, this.dScale);
        if (this.barsBounds != null) {
            Area area = new Area(this.barsBounds);
            area.transform(this.centerAndScaleTransform);
            this.barsScreenBounds = area.getBounds();
        }
    }

    protected void paintComponent(Graphics graphics) {
        if (!this.tempHide) {
            Rectangle rectangle = graphics.getClipBounds();
            if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.transform(this.centerAndScaleTransform);
            for (int i2 = 0; i2 < this.bars.length; ++i2) {
                graphics2D.setColor(this.colors[i2 + this.colorOffset]);
                graphics2D.fill(this.bars[i2]);
            }
        }
    }

    private static Area[] buildTicker(int n2) {
        Area[] areaArray = new Area[n2];
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        double d2 = Math.PI * 2 / (double)n2;
        for (double d3 = 0.0; d3 < (double)n2; d3 += 1.0) {
            Area area = InfiniteProgressPanel.buildPrimitive();
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(double_.getX(), double_.getY());
            AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(2.0, -0.4);
            AffineTransform affineTransform3 = AffineTransform.getRotateInstance(-d3 * d2, double_.getX(), double_.getY());
            AffineTransform affineTransform4 = new AffineTransform();
            affineTransform4.concatenate(affineTransform);
            affineTransform4.concatenate(affineTransform2);
            area.transform(affineTransform4);
            area.transform(affineTransform3);
            areaArray[(int)d3] = area;
        }
        return areaArray;
    }

    private static Area buildPrimitive() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 6.0, 1.0);
        Area area = new Area(double_);
        return area;
    }

    public void start() {
        this.setVisible(true);
    }

    public void stop() {
        this.setVisible(false);
    }
}

