/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gwas;

import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.gwas.GWASData;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.readers.AsciiLineReader;

public class GWASParser {
    private static final Logger log = Logger.getLogger(GWASParser.class);
    private ResourceLocator locator;
    private int locationCol = -1;
    private int chrCol = -1;
    private int pCol = -1;
    private int SNPCol = -1;

    public ResourceLocator getLocator() {
        return this.locator;
    }

    public void setLocator(ResourceLocator locator) {
        this.locator = locator;
    }

    public GWASParser(ResourceLocator locator) {
        this.locator = locator;
    }

    public boolean parseHeader(String headerString) {
        String[] headers;
        boolean parsingSuccessful = true;
        int headersSize = ParsingUtils.splitWhitespace(headerString = headerString.trim(), headers = new String[1000]);
        if (headersSize < 4) {
            parsingSuccessful = false;
        }
        int colCounter = 0;
        for (int i2 = 0; i2 < headersSize; ++i2) {
            String header = headers[i2];
            if ((header = header.toLowerCase()).equals("chr") || header.equals("chromosome")) {
                this.chrCol = colCounter;
            }
            if (header.equals("bp") || header.equals("pos") || header.equals("position")) {
                this.locationCol = colCounter;
            }
            if (header.equals("p") || header.equals("pval") || header.equals("p-value") || header.equals("pvalue") || header.equals("p.value")) {
                this.pCol = colCounter;
            }
            if (header.equals("snp") || header.equals("rs") || header.equals("rsid") || header.equals("rsnum") || header.equals("id") || header.equals("marker") || header.equals("markername")) {
                this.SNPCol = colCounter;
            }
            ++colCounter;
        }
        if (this.locationCol < 0 || this.chrCol < 0 || this.pCol < 0 || this.SNPCol < 0) {
            parsingSuccessful = false;
        }
        return parsingSuccessful;
    }

    public GWASData parseDescriptions(GWASData gData, String hitChr, long hitLocation, int searchStartRow) throws IOException {
        FileInputStream fs = null;
        AsciiLineReader reader = null;
        String nextLine = null;
        Genome genome = IGV.getInstance().getGenomeManager().getCurrentGenome();
        boolean hitFound = false;
        int cacheSize = gData.getDescriptionCache().getMaxSize();
        try {
            fs = new FileInputStream(this.locator.getPath());
            fs.getChannel().position(0L);
            reader = new AsciiLineReader(fs);
            String headerLine = reader.readLine();
            if (!this.parseHeader(headerLine)) {
                throw new ParserException("Error while parsing header line.", reader.getCurrentLineNumber(), nextLine);
            }
            gData.getDescriptionCache().setHeaderTokens(headerLine);
            int rowCounter = 0;
            int cacheAfter = cacheSize / 2;
            int cacheCounter = 0;
            while (cacheCounter < cacheAfter && (nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                int start;
                float p2;
                nextLine = nextLine.trim();
                if (++rowCounter < searchStartRow) continue;
                String[] tokens = new String[1000];
                ParsingUtils.splitWhitespace(nextLine, tokens);
                if (tokens.length <= 1 || tokens[this.pCol].trim().equals("NA")) continue;
                try {
                    p2 = Float.parseFloat(tokens[this.pCol].trim());
                    p2 = (float)(-Math.log10(p2));
                }
                catch (NumberFormatException e2) {
                    throw new ParserException("Column " + this.pCol + " must be a numeric value.", reader.getCurrentLineNumber(), nextLine);
                }
                String chr = genome.getChromosomeAlias(tokens[this.chrCol].trim());
                try {
                    start = Integer.parseInt(tokens[this.locationCol].trim());
                }
                catch (NumberFormatException e3) {
                    throw new ParserException("Column " + this.locationCol + " must be a numeric value.", reader.getCurrentLineNumber(), nextLine);
                }
                if (chr.equals(hitChr) && (long)start == hitLocation) {
                    hitFound = true;
                }
                if (hitFound) {
                    ++cacheCounter;
                }
                gData.getDescriptionCache().add(chr, start, p2, nextLine);
            }
        }
        catch (ParserException e4) {
            throw e4;
        }
        catch (Exception e5) {
            if (nextLine != null && reader.getCurrentLineNumber() != 0L) {
                throw new ParserException(e5.getMessage(), (Throwable)e5, reader.getCurrentLineNumber(), nextLine);
            }
            throw new RuntimeException(e5);
        }
        finally {
            reader.close();
            fs.close();
        }
        return gData;
    }

    public String parseDescriptionLine(String hitChr, double hitLocation, int searchStartRow) throws IOException {
        FileInputStream fs = null;
        AsciiLineReader reader = null;
        String nextLine = null;
        Genome genome = IGV.getInstance().getGenomeManager().getCurrentGenome();
        boolean hitFound = false;
        String resultLine = "";
        try {
            fs = new FileInputStream(this.locator.getPath());
            fs.getChannel().position(0L);
            reader = new AsciiLineReader(fs);
            String headerLine = reader.readLine();
            if (!this.parseHeader(headerLine)) {
                throw new ParserException("Error while parsing header line.", reader.getCurrentLineNumber(), nextLine);
            }
            headerLine = headerLine.trim();
            String[] headers = new String[1000];
            int headersSize = ParsingUtils.splitWhitespace(headerLine, headers);
            int rowCounter = 0;
            while (!hitFound && (nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                int start;
                nextLine = nextLine.trim();
                if (++rowCounter < searchStartRow) continue;
                String[] tokens = new String[100];
                ParsingUtils.splitWhitespace(nextLine, tokens);
                if (tokens.length <= 1) continue;
                String chr = genome.getChromosomeAlias(tokens[this.chrCol].trim());
                try {
                    start = Integer.parseInt(tokens[this.locationCol].trim());
                }
                catch (NumberFormatException e2) {
                    throw new ParserException("Column " + this.locationCol + " must be a numeric value.", reader.getCurrentLineNumber(), nextLine);
                }
                if (!chr.equals(hitChr) || (double)start != hitLocation) continue;
                hitFound = true;
                for (int i2 = 0; i2 < headersSize; ++i2) {
                    resultLine = resultLine + headers[i2] + ": " + tokens[i2] + "<br>";
                }
            }
            String string = resultLine;
            return string;
        }
        catch (ParserException e3) {
            throw e3;
        }
        catch (Exception e4) {
            if (nextLine != null && reader.getCurrentLineNumber() != 0L) {
                throw new ParserException(e4.getMessage(), (Throwable)e4, reader.getCurrentLineNumber(), nextLine);
            }
            throw new RuntimeException(e4);
        }
        finally {
            reader.close();
            fs.close();
        }
    }

    public GWASData parse() throws IOException {
        FileInputStream fs = null;
        AsciiLineReader reader = null;
        String nextLine = null;
        Genome genome = IGV.getInstance().getGenomeManager().getCurrentGenome();
        try {
            fs = new FileInputStream(this.locator.getPath());
            fs.getChannel().position(0L);
            reader = new AsciiLineReader(fs);
            String headerLine = reader.readLine();
            if (!this.parseHeader(headerLine)) {
                throw new ParserException("Error while parsing header line.", reader.getCurrentLineNumber(), nextLine);
            }
            GWASData gData = new GWASData();
            int rowCounter = 0;
            int indexCounter = 0;
            int addedValuesCounter = 0;
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                float p2;
                int start;
                nextLine = nextLine.trim();
                ++rowCounter;
                String[] tokens = new String[100];
                ParsingUtils.splitWhitespace(nextLine, tokens);
                if (tokens.length <= 1) continue;
                String chr = genome.getChromosomeAlias(tokens[this.chrCol].trim());
                try {
                    start = Integer.parseInt(tokens[this.locationCol].trim());
                }
                catch (NumberFormatException e2) {
                    throw new ParserException("Column " + this.locationCol + " must be a numeric value.", reader.getCurrentLineNumber(), nextLine);
                }
                if (tokens[this.pCol].trim().equals("NA")) continue;
                try {
                    p2 = Float.parseFloat(tokens[this.pCol].trim());
                    p2 = (float)(-Math.log10(p2));
                }
                catch (NumberFormatException e3) {
                    throw new ParserException("Column " + this.pCol + " must be a numeric value.", reader.getCurrentLineNumber(), nextLine);
                }
                gData.addLocation(chr, start);
                gData.addValue(chr, p2);
                ++addedValuesCounter;
                int indexSize = 10000;
                if (++indexCounter != indexSize) continue;
                gData.getFileIndex().add((int)reader.getPosition());
                indexCounter = 0;
            }
            GWASData gWASData = gData;
            return gWASData;
        }
        catch (ParserException e4) {
            throw e4;
        }
        catch (Exception e5) {
            if (nextLine != null && reader.getCurrentLineNumber() != 0L) {
                throw new ParserException(e5.getMessage(), (Throwable)e5, reader.getCurrentLineNumber(), nextLine);
            }
            throw new RuntimeException(e5);
        }
        finally {
            reader.close();
            fs.close();
        }
    }
}

