/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.moment;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.SecondMoment;

public class Variance
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -9111962718267217978L;
    protected SecondMoment moment = null;
    protected boolean incMoment = true;
    private boolean isBiasCorrected = true;

    public Variance() {
        this.moment = new SecondMoment();
    }

    public Variance(SecondMoment m2) {
        this.incMoment = false;
        this.moment = m2;
    }

    public Variance(boolean isBiasCorrected) {
        this.moment = new SecondMoment();
        this.isBiasCorrected = isBiasCorrected;
    }

    public Variance(boolean isBiasCorrected, SecondMoment m2) {
        this.incMoment = false;
        this.moment = m2;
        this.isBiasCorrected = isBiasCorrected;
    }

    public void increment(double d2) {
        if (this.incMoment) {
            this.moment.increment(d2);
        }
    }

    public double getResult() {
        if (this.moment.n == 0L) {
            return Double.NaN;
        }
        if (this.moment.n == 1L) {
            return 0.0;
        }
        if (this.isBiasCorrected) {
            return this.moment.m2 / ((double)this.moment.n - 1.0);
        }
        return this.moment.m2 / (double)this.moment.n;
    }

    public long getN() {
        return this.moment.getN();
    }

    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    public double evaluate(double[] values) {
        if (values == null) {
            throw new IllegalArgumentException("input values array is null");
        }
        return this.evaluate(values, 0, values.length);
    }

    public double evaluate(double[] values, int begin, int length) {
        double var = Double.NaN;
        if (this.test(values, begin, length)) {
            this.clear();
            if (length == 1) {
                var = 0.0;
            } else if (length > 1) {
                Mean mean = new Mean();
                double m2 = mean.evaluate(values, begin, length);
                var = this.evaluate(values, m2, begin, length);
            }
        }
        return var;
    }

    public double evaluate(double[] values, double mean, int begin, int length) {
        double var = Double.NaN;
        if (this.test(values, begin, length)) {
            if (length == 1) {
                var = 0.0;
            } else if (length > 1) {
                double accum = 0.0;
                double accum2 = 0.0;
                int i2 = begin;
                while (i2 < begin + length) {
                    accum += Math.pow(values[i2] - mean, 2.0);
                    accum2 += values[i2] - mean;
                    ++i2;
                }
                var = this.isBiasCorrected ? (accum - Math.pow(accum2, 2.0) / (double)length) / (double)(length - 1) : (accum - Math.pow(accum2, 2.0) / (double)length) / (double)length;
            }
        }
        return var;
    }

    public double evaluate(double[] values, double mean) {
        return this.evaluate(values, mean, 0, values.length);
    }

    public boolean isBiasCorrected() {
        return this.isBiasCorrected;
    }

    public void setBiasCorrected(boolean isBiasCorrected) {
        this.isBiasCorrected = isBiasCorrected;
    }
}

