/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.complex;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.commons.math.complex.Complex;

public class ComplexFormat
extends Format
implements Serializable {
    private static final long serialVersionUID = -6337346779577272306L;
    private static final String DEFAULT_IMAGINARY_CHARACTER = "i";
    private String imaginaryCharacter;
    private NumberFormat imaginaryFormat;
    private NumberFormat realFormat;

    public ComplexFormat() {
        this(DEFAULT_IMAGINARY_CHARACTER, ComplexFormat.getDefaultNumberFormat());
    }

    public ComplexFormat(NumberFormat format) {
        this(DEFAULT_IMAGINARY_CHARACTER, format);
    }

    public ComplexFormat(NumberFormat realFormat, NumberFormat imaginaryFormat) {
        this(DEFAULT_IMAGINARY_CHARACTER, realFormat, imaginaryFormat);
    }

    public ComplexFormat(String imaginaryCharacter) {
        this(imaginaryCharacter, ComplexFormat.getDefaultNumberFormat());
    }

    public ComplexFormat(String imaginaryCharacter, NumberFormat format) {
        this(imaginaryCharacter, format, (NumberFormat)format.clone());
    }

    public ComplexFormat(String imaginaryCharacter, NumberFormat realFormat, NumberFormat imaginaryFormat) {
        this.setImaginaryCharacter(imaginaryCharacter);
        this.setImaginaryFormat(imaginaryFormat);
        this.setRealFormat(realFormat);
    }

    public static String formatComplex(Complex c2) {
        return ComplexFormat.getInstance().format(c2);
    }

    public StringBuffer format(Complex complex, StringBuffer toAppendTo, FieldPosition pos) {
        pos.setBeginIndex(0);
        pos.setEndIndex(0);
        double re = complex.getReal();
        this.formatDouble(re, this.getRealFormat(), toAppendTo, pos);
        double im = complex.getImaginary();
        if (im < 0.0) {
            toAppendTo.append(" - ");
            this.formatDouble(-im, this.getImaginaryFormat(), toAppendTo, pos);
            toAppendTo.append(this.getImaginaryCharacter());
        } else if (im > 0.0 || Double.isNaN(im)) {
            toAppendTo.append(" + ");
            this.formatDouble(im, this.getImaginaryFormat(), toAppendTo, pos);
            toAppendTo.append(this.getImaginaryCharacter());
        }
        return toAppendTo;
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        StringBuffer ret = null;
        if (obj instanceof Complex) {
            ret = this.format((Complex)obj, toAppendTo, pos);
        } else if (obj instanceof Number) {
            ret = this.format(new Complex(((Number)obj).doubleValue(), 0.0), toAppendTo, pos);
        } else {
            throw new IllegalArgumentException("Cannot format given Object as a Date");
        }
        return ret;
    }

    private StringBuffer formatDouble(double value, NumberFormat format, StringBuffer toAppendTo, FieldPosition pos) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            toAppendTo.append('(');
            toAppendTo.append(value);
            toAppendTo.append(')');
        } else {
            this.getRealFormat().format(value, toAppendTo, pos);
        }
        return toAppendTo;
    }

    public static Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    private static NumberFormat getDefaultNumberFormat() {
        return ComplexFormat.getDefaultNumberFormat(Locale.getDefault());
    }

    private static NumberFormat getDefaultNumberFormat(Locale locale) {
        NumberFormat nf = NumberFormat.getInstance(locale);
        nf.setMaximumFractionDigits(2);
        return nf;
    }

    public String getImaginaryCharacter() {
        return this.imaginaryCharacter;
    }

    public NumberFormat getImaginaryFormat() {
        return this.imaginaryFormat;
    }

    public static ComplexFormat getInstance() {
        return ComplexFormat.getInstance(Locale.getDefault());
    }

    public static ComplexFormat getInstance(Locale locale) {
        NumberFormat f2 = ComplexFormat.getDefaultNumberFormat(locale);
        return new ComplexFormat(f2);
    }

    public NumberFormat getRealFormat() {
        return this.realFormat;
    }

    public Complex parse(String source) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Complex result = this.parse(source, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new ParseException("Unparseable complex number: \"" + source + "\"", parsePosition.getErrorIndex());
        }
        return result;
    }

    public Complex parse(String source, ParsePosition pos) {
        int endIndex;
        int initialIndex = pos.getIndex();
        this.parseAndIgnoreWhitespace(source, pos);
        Number re = this.parseNumber(source, this.getRealFormat(), pos);
        if (re == null) {
            pos.setIndex(initialIndex);
            return null;
        }
        int startIndex = pos.getIndex();
        char c2 = this.parseNextCharacter(source, pos);
        int sign = 0;
        switch (c2) {
            case '\u0000': {
                return new Complex(re.doubleValue(), 0.0);
            }
            case '-': {
                sign = -1;
                break;
            }
            case '+': {
                sign = 1;
                break;
            }
            default: {
                pos.setIndex(initialIndex);
                pos.setErrorIndex(startIndex);
                return null;
            }
        }
        this.parseAndIgnoreWhitespace(source, pos);
        Number im = this.parseNumber(source, this.getRealFormat(), pos);
        if (im == null) {
            pos.setIndex(initialIndex);
            return null;
        }
        int n2 = this.getImaginaryCharacter().length();
        startIndex = pos.getIndex();
        if (source.substring(startIndex, endIndex = startIndex + n2).compareTo(this.getImaginaryCharacter()) != 0) {
            pos.setIndex(initialIndex);
            pos.setErrorIndex(startIndex);
            return null;
        }
        pos.setIndex(endIndex);
        return new Complex(re.doubleValue(), im.doubleValue() * (double)sign);
    }

    private void parseAndIgnoreWhitespace(String source, ParsePosition pos) {
        this.parseNextCharacter(source, pos);
        pos.setIndex(pos.getIndex() - 1);
    }

    private char parseNextCharacter(String source, ParsePosition pos) {
        int index = pos.getIndex();
        int n2 = source.length();
        char ret = '\u0000';
        if (index < n2) {
            char c2;
            while (Character.isWhitespace(c2 = source.charAt(index++)) && index < n2) {
            }
            pos.setIndex(index);
            if (index < n2) {
                ret = c2;
            }
        }
        return ret;
    }

    private Number parseNumber(String source, double value, ParsePosition pos) {
        Double ret = null;
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        sb.append(value);
        sb.append(')');
        int n2 = sb.length();
        int startIndex = pos.getIndex();
        int endIndex = startIndex + n2;
        if (endIndex < source.length() && source.substring(startIndex, endIndex).compareTo(sb.toString()) == 0) {
            ret = new Double(value);
            pos.setIndex(endIndex);
        }
        return ret;
    }

    private Number parseNumber(String source, NumberFormat format, ParsePosition pos) {
        int startIndex = pos.getIndex();
        Number number = this.getRealFormat().parse(source, pos);
        int endIndex = pos.getIndex();
        if (startIndex == endIndex) {
            double[] special = new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
            int i2 = 0;
            while (i2 < special.length) {
                number = this.parseNumber(source, special[i2], pos);
                if (number != null) break;
                ++i2;
            }
        }
        return number;
    }

    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    public void setImaginaryCharacter(String imaginaryCharacter) {
        if (imaginaryCharacter == null || imaginaryCharacter.length() == 0) {
            throw new IllegalArgumentException("imaginaryCharacter must be a non-empty string.");
        }
        this.imaginaryCharacter = imaginaryCharacter;
    }

    public void setImaginaryFormat(NumberFormat imaginaryFormat) {
        if (imaginaryFormat == null) {
            throw new IllegalArgumentException("imaginaryFormat can not be null.");
        }
        this.imaginaryFormat = imaginaryFormat;
    }

    public void setRealFormat(NumberFormat realFormat) {
        if (realFormat == null) {
            throw new IllegalArgumentException("realFormat can not be null.");
        }
        this.realFormat = realFormat;
    }
}

