/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelComponent;
import org.broad.igv.ui.util.Packable;

public class AttributePanel
extends TrackPanelComponent
implements Packable,
Paintable {
    private static Logger log = Logger.getLogger(AttributePanel.class);

    public AttributePanel(TrackPanel trackPanel) {
        super(trackPanel);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.init();
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Rectangle visibleRect = this.getVisibleRect();
        this.removeMousableRegions();
        this.paintOffscreen((Graphics2D)g2, visibleRect);
    }

    @Override
    public void paintOffscreen(Graphics2D g2, Rectangle rect) {
        this.paintImpl(g2, rect);
        super.paintBorder(g2);
    }

    public void paintImpl(Graphics2D g2, Rectangle visibleRect) {
        TrackPanel trackPanel;
        List<TrackGroup> groups;
        List<String> names = AttributeManager.getInstance().getAttributeNames();
        if (names == null) {
            return;
        }
        Set<String> hiddenAttributes = IGV.getInstance().getSession().getHiddenAttributes();
        if (hiddenAttributes != null) {
            names.removeAll(hiddenAttributes);
        }
        if (names.size() > 0 && !(groups = (trackPanel = (TrackPanel)this.getParent()).getGroups()).isEmpty()) {
            int attributeColumnWidth = this.getAttributeColumnWidth();
            Graphics2D graphics2D = (Graphics2D)g2.create();
            graphics2D.setColor(Color.BLACK);
            Graphics2D greyGraphics = (Graphics2D)g2.create();
            greyGraphics.setColor(UIConstants.ZOOMED_OUT_COLOR);
            int regionX = 3;
            int regionY = 0;
            for (TrackGroup group : groups) {
                if (regionY > visibleRect.y + visibleRect.height) break;
                if (!group.isVisible()) continue;
                if (groups.size() > 1) {
                    greyGraphics.fillRect(0, regionY + 1, this.getWidth(), 9);
                    regionY += 10;
                }
                if (group.isDrawBorder()) {
                    g2.drawLine(0, regionY - 1, this.getWidth(), regionY - 1);
                }
                for (Track track : group.getTracks()) {
                    if (track == null) continue;
                    int trackHeight = track.getHeight();
                    if (regionY > visibleRect.y + visibleRect.height) break;
                    if (!track.isVisible()) continue;
                    if (regionY + trackHeight >= visibleRect.y) {
                        Rectangle trackRectangle = new Rectangle(regionX, regionY, this.getWidth(), trackHeight);
                        track.renderAttributes(graphics2D, trackRectangle, visibleRect, names, this.mouseRegions);
                    }
                    regionY += trackHeight;
                }
                if (!group.isDrawBorder()) continue;
                g2.drawLine(0, regionY, this.getWidth(), regionY);
            }
        }
    }

    private void init() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        if (!PreferenceManager.getInstance().getAsBoolean("IGV.track.show.attribute.views")) {
            this.setSize(0, this.getHeight());
        }
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setPreferredSize(new Dimension(0, 0));
        this.setVerifyInputWhenFocusTarget(false);
        AttributePanelMouseAdapter mouseAdapter = new AttributePanelMouseAdapter();
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    @Override
    public String getPopupMenuTitle(int x, int y) {
        Collection<Track> selectedTracks = this.getSelectedTracks();
        int selectedTrackCount = selectedTracks.size();
        if (selectedTrackCount == 1) {
            return selectedTracks.iterator().next().getName();
        }
        String keyValue = "";
        for (MouseableRegion region : this.getMouseRegions()) {
            if (!region.containsPoint(x, y)) continue;
            keyValue = region.getText();
        }
        return keyValue + " (" + selectedTrackCount + " tracks)";
    }

    public String getMouseDoc(int x, int y) {
        List<MouseableRegion> mouseRegions = this.getMouseRegions();
        for (MouseableRegion mr : mouseRegions) {
            if (!mr.containsPoint(x, y)) continue;
            return mr.getText();
        }
        return "";
    }

    public int getAttributeColumnWidth() {
        return 10;
    }

    private int calculatePackWidth() {
        if (!PreferenceManager.getInstance().getAsBoolean("IGV.track.show.attribute.views")) {
            return 0;
        }
        HashSet<String> attributeKeys = new HashSet<String>(AttributeManager.getInstance().getAttributeNames());
        Set<String> hiddenAttributes = IGV.getInstance().getSession().getHiddenAttributes();
        if (hiddenAttributes != null) {
            attributeKeys.removeAll(hiddenAttributes);
        }
        int attributeCount = attributeKeys.size();
        int packWidth = attributeCount * 12 + 2;
        return packWidth;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, this.calculatePackWidth(), height);
    }

    @Override
    public void packComponent() {
        int newWidth = this.calculatePackWidth();
        Dimension dimension = this.getSize();
        dimension = new Dimension(newWidth, dimension.height);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
    }

    class AttributePanelMouseAdapter
    extends MouseInputAdapter {
        int lastMousePressX = 0;

        AttributePanelMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (log.isDebugEnabled()) {
                log.debug("Enter mousePressed");
            }
            AttributePanel.this.clearTrackSelections();
            AttributePanel.this.selectTracks(e2);
            if (e2.isPopupTrigger()) {
                TrackClickEvent te = new TrackClickEvent(e2, null);
                AttributePanel.this.openPopupMenu(te);
            }
            IGV.getInstance().repaintNamePanels();
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (e2.isPopupTrigger()) {
                TrackClickEvent te = new TrackClickEvent(e2, null);
                AttributePanel.this.openPopupMenu(te);
                AttributePanel.this.clearTrackSelections();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            AttributePanel.this.setToolTipText(AttributePanel.this.getMouseDoc(e2.getX(), e2.getY()));
        }
    }
}

