/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.tools;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.hic.data.Block;
import org.broad.igv.hic.data.ContactRecord;
import org.broad.igv.hic.data.Matrix;
import org.broad.igv.hic.data.MatrixZoomData;
import org.broad.igv.hic.tools.AlignmentPair;
import org.broad.igv.hic.tools.AsciiPairIterator;
import org.broad.igv.hic.tools.BAMPairIterator;
import org.broad.igv.hic.tools.HiCTools;
import org.broad.igv.hic.tools.PairIterator;
import org.broad.igv.util.CompressionUtils;
import org.broad.tribble.util.LittleEndianOutputStream;

public class Preprocessor {
    File outputFile;
    LittleEndianOutputStream fos;
    long bytesWritten = 0L;
    long masterIndexPosition;
    Map<String, IndexEntry> matrixPositions = new LinkedHashMap<String, IndexEntry>();
    Map<String, Long> blockIndexPositions = new LinkedHashMap<String, Long>();
    Map<String, IndexEntry[]> blockIndexMap = new LinkedHashMap<String, IndexEntry[]>();

    public Preprocessor(File outputFile) {
        this.outputFile = outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preprocess(List<String> inputFileList, String genomeId) throws IOException {
        try {
            this.fos = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(this.outputFile)));
            this.writeLong(0L);
            int nChrs = HiCTools.chromosomes.length;
            this.writeInt(nChrs);
            for (int i2 = 0; i2 < nChrs; ++i2) {
                this.writeString(HiCTools.chromosomes[i2].getName());
                this.writeInt(HiCTools.chromosomes[i2].getSize());
            }
            int nAttributes = 0;
            this.writeInt(nAttributes);
            for (int c1 = 0; c1 < nChrs; ++c1) {
                for (int c2 = c1; c2 < nChrs; ++c2) {
                    Matrix matrix;
                    if (c1 == 0 && c2 != 0 || c2 == 0 && c1 != 0 || (matrix = this.readMatrix(inputFileList, c1, c2)) == null) continue;
                    System.out.println("writing matrix: " + matrix.getKey());
                    this.writeMatrix(matrix);
                }
            }
            this.masterIndexPosition = this.bytesWritten;
            this.writeMasterIndex();
        }
        finally {
            this.fos.close();
        }
        this.updateIndexPositions();
    }

    public Matrix readMatrix(List<String> inputFileList, int c1, int c2) throws IOException {
        boolean isWholeGenome = c1 == 0 && c2 == 0;
        Matrix matrix = null;
        if (isWholeGenome) {
            int genomeLength = HiCTools.chromosomes[0].getSize();
            int binSize = genomeLength / 500;
            matrix = new Matrix(c1, c2, binSize);
        } else {
            matrix = new Matrix(c1, c2);
        }
        for (String file : inputFileList) {
            PairIterator iter;
            PairIterator pairIterator = iter = file.endsWith(".bam") ? new BAMPairIterator(file) : new AsciiPairIterator(file);
            while (iter.hasNext()) {
                AlignmentPair pair = iter.next();
                int pos1 = pair.getPos1();
                int pos2 = pair.getPos2();
                Integer chr1 = HiCTools.chromosomeOrdinals.get(pair.getChr1());
                Integer chr2 = HiCTools.chromosomeOrdinals.get(pair.getChr2());
                if (chr1 == null || chr2 == null) continue;
                if (isWholeGenome) {
                    pos1 = Preprocessor.getGenomicPosition(chr1, pos1);
                    pos2 = Preprocessor.getGenomicPosition(chr2, pos2);
                    Preprocessor.incrementCount(matrix, c1, pos1, c2, pos2);
                    continue;
                }
                if ((c1 != chr1 || c2 != chr2) && (c1 != chr2 || c2 != chr1)) continue;
                Preprocessor.incrementCount(matrix, chr1, pos1, chr2, pos2);
            }
            iter.close();
        }
        matrix.parsingComplete();
        return matrix;
    }

    private static int getGenomicPosition(int chr, int pos) {
        long len = 0L;
        for (int i2 = 1; i2 < chr; ++i2) {
            len += (long)HiCTools.chromosomes[i2].getSize();
        }
        return (int)((len += (long)pos) / 1000L);
    }

    private static void incrementCount(Matrix matrix, int chr1, int pos1, int chr2, int pos2) {
        if (chr2 > chr1) {
            int tc2 = chr2;
            int tp2 = pos2;
            chr2 = chr1;
            pos2 = pos1;
            chr1 = tc2;
            pos1 = tp2;
        }
        matrix.incrementCount(pos1, pos2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndexPositions() throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.outputFile, "rw");
            raf.getChannel().position(0L);
            BufferedByteWriter buffer = new BufferedByteWriter();
            buffer.putLong(this.masterIndexPosition);
            raf.write(buffer.getBytes());
            for (String key : this.blockIndexPositions.keySet()) {
                long pos = this.blockIndexPositions.get(key);
                IndexEntry[] blockIndex = this.blockIndexMap.get(key);
                raf.getChannel().position(pos);
                buffer = new BufferedByteWriter();
                for (int i2 = 0; i2 < blockIndex.length; ++i2) {
                    buffer.putInt(blockIndex[i2].id);
                    buffer.putLong(blockIndex[i2].position);
                    buffer.putInt(blockIndex[i2].size);
                }
                raf.write(buffer.getBytes());
            }
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    public void writeMasterIndex() throws IOException {
        BufferedByteWriter buffer = new BufferedByteWriter();
        buffer.putInt(this.matrixPositions.size());
        for (Map.Entry<String, IndexEntry> entry : this.matrixPositions.entrySet()) {
            buffer.putString(entry.getKey());
            buffer.putLong(entry.getValue().position);
            buffer.putInt(entry.getValue().size);
        }
        byte[] bytes = buffer.getBytes();
        this.writeInt(bytes.length);
        this.write(bytes);
    }

    public void writeMatrix(Matrix matrix) throws IOException {
        long position = this.bytesWritten;
        this.writeInt(matrix.chr1);
        this.writeInt(matrix.chr2);
        this.writeInt(matrix.zoomData.length);
        for (MatrixZoomData zd : matrix.zoomData) {
            this.writeZoomHeader(zd);
        }
        int size = (int)(this.bytesWritten - position);
        this.matrixPositions.put(matrix.getKey(), new IndexEntry(position, size));
        for (MatrixZoomData zd : matrix.zoomData) {
            IndexEntry[] blockIndex = this.writeZoomData(zd);
            this.blockIndexMap.put(this.getBlockKey(zd), blockIndex);
        }
    }

    private String getBlockKey(MatrixZoomData zd) {
        return zd.getChr1() + "_" + zd.getChr2() + "_" + zd.getZoom();
    }

    private void writeZoomHeader(MatrixZoomData zd) throws IOException {
        this.writeInt(zd.getZoom());
        this.writeInt(zd.getBinSize());
        this.writeInt(zd.getBlockBinCount());
        this.writeInt(zd.getColumnCount());
        Map<Integer, Block> blocks = zd.getBlocks();
        this.writeInt(blocks.size());
        this.blockIndexPositions.put(this.getBlockKey(zd), this.bytesWritten);
        for (int i2 = 0; i2 < zd.getBlocks().size(); ++i2) {
            this.writeInt(0);
            this.writeLong(0L);
            this.writeInt(0);
        }
    }

    private IndexEntry[] writeZoomData(MatrixZoomData zd) throws IOException {
        Map<Integer, Block> blocks = zd.getBlocks();
        IndexEntry[] indexEntries = new IndexEntry[blocks.size()];
        int i2 = 0;
        for (Map.Entry<Integer, Block> entry : blocks.entrySet()) {
            int blockNumber = entry.getKey();
            Block block = entry.getValue();
            long position = this.bytesWritten;
            this.writeContactRecords(block);
            int size = (int)(this.bytesWritten - position);
            indexEntries[i2] = new IndexEntry(blockNumber, position, size);
            ++i2;
        }
        return indexEntries;
    }

    private void writeContactRecords(Block block) throws IOException {
        ContactRecord[] records = block.getContactRecords();
        int len = records.length;
        BufferedByteWriter buffer = new BufferedByteWriter(len * 12);
        buffer.putInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            ContactRecord rec = records[i2];
            buffer.putInt(rec.getX());
            buffer.putInt(rec.getY());
            buffer.putInt(rec.getCounts());
        }
        byte[] bytes = buffer.getBytes();
        byte[] compressedBytes = CompressionUtils.compress(bytes);
        this.write(compressedBytes);
    }

    private void writeDouble(double d2) throws IOException {
        this.fos.writeDouble(d2);
        this.bytesWritten += 8L;
    }

    private void writeInt(int v) throws IOException {
        this.fos.writeInt(v);
        this.bytesWritten += 4L;
    }

    private void writeShort(short v) throws IOException {
        this.fos.writeShort(v);
        this.bytesWritten += 2L;
    }

    public void writeLong(long v) throws IOException {
        this.fos.writeLong(v);
        this.bytesWritten += 8L;
    }

    private void write(byte[] bytes) throws IOException {
        this.fos.write(bytes);
        this.bytesWritten += (long)bytes.length;
    }

    private void writeString(String string) throws IOException {
        byte[] bytes = string.getBytes();
        this.write(bytes);
        this.fos.write(0);
        ++this.bytesWritten;
    }

    public static class IndexEntry {
        int id;
        public long position;
        public int size;

        IndexEntry(int id, long position, int size) {
            this.id = id;
            this.position = position;
            this.size = size;
        }

        public IndexEntry(long position, int size) {
            this.position = position;
            this.size = size;
        }
    }

    public static class BufferedByteWriter {
        ByteArrayOutputStream buffer;
        LittleEndianOutputStream dos;

        public BufferedByteWriter() {
            this(8192);
        }

        public BufferedByteWriter(int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Buffer size <= 0");
            }
            this.buffer = new ByteArrayOutputStream(size);
            this.dos = new LittleEndianOutputStream(this.buffer);
        }

        public byte[] getBytes() {
            return this.buffer.toByteArray();
        }

        private void put(byte[] b2) throws IOException {
            this.dos.write(b2);
        }

        private void put(byte b2) throws IOException {
            this.dos.write(b2);
        }

        private void putShort(short v) throws IOException {
            this.dos.writeShort(v);
        }

        public void putInt(int v) throws IOException {
            this.dos.writeInt(v);
        }

        public void putLong(long v) throws IOException {
            this.dos.writeLong(v);
        }

        public void putString(String string) throws IOException {
            this.dos.writeString(string);
        }
    }
}

