/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArraySet<K>
extends AbstractObjectSet<K>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private transient Object[] a;
    private int size;

    public ObjectArraySet(Object[] a2) {
        this.a = a2;
        this.size = a2.length;
    }

    public ObjectArraySet() {
        this.a = ObjectArrays.EMPTY_ARRAY;
    }

    public ObjectArraySet(int capacity) {
        this.a = new Object[capacity];
    }

    public ObjectArraySet(ObjectSet<K> s) {
        this(s.size());
        this.addAll(s);
    }

    public ObjectArraySet(Object[] a2, int size) {
        this.a = a2;
        this.size = size;
        if (size > a2.length) {
            throw new IllegalArgumentException("The provided size (" + size + ") is larger than or equal to the array size (" + a2.length + ")");
        }
    }

    private int findKey(Object o2) {
        int i2 = this.size;
        while (i2-- != 0) {
            if (!(this.a[i2] == null ? o2 == null : this.a[i2].equals(o2))) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public ObjectIterator<K> iterator() {
        return ObjectIterators.wrap(this.a, 0, this.size);
    }

    @Override
    public boolean contains(Object k2) {
        return this.findKey(k2) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean remove(Object k2) {
        int pos = this.findKey(k2);
        if (pos == -1) {
            return false;
        }
        int tail = this.size - pos - 1;
        for (int i2 = 0; i2 < tail; ++i2) {
            this.a[pos + i2] = this.a[pos + i2 + 1];
        }
        --this.size;
        this.a[this.size] = null;
        return true;
    }

    @Override
    public boolean add(K k2) {
        int pos = this.findKey(k2);
        if (pos != -1) {
            return false;
        }
        if (this.size == this.a.length) {
            Object[] b2 = new Object[this.size == 0 ? 2 : this.size * 2];
            int i2 = this.size;
            while (i2-- != 0) {
                b2[i2] = this.a[i2];
            }
            this.a = b2;
        }
        this.a[this.size++] = k2;
        return true;
    }

    @Override
    public void clear() {
        int i2 = this.size;
        while (i2-- != 0) {
            this.a[i2] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public ObjectArraySet<K> clone() {
        ObjectArraySet c2;
        try {
            c2 = (ObjectArraySet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c2.a = (Object[])this.a.clone();
        return c2;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int i2 = 0; i2 < this.size; ++i2) {
            s.writeObject(this.a[i2]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = new Object[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.a[i2] = s.readObject();
        }
    }
}

