/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.IOException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.broad.tribble.util.SeekableFTPStreamHelper;
import org.broad.tribble.util.SeekableStream;
import org.broad.tribble.util.SeekableStreamFactory;
import org.broad.tribble.util.ftp.UserPasswordInput;

public class SeekableFTPStream
extends SeekableStream {
    static Logger log = Logger.getLogger(SeekableFTPStream.class);
    SeekableFTPStreamHelper helper;
    private static final String EXPECTED1 = "\u00cf\u00ac\u00c9uC\u00d4\u00d5y";
    private static final String EXPECTED2 = "\u00e4lw\f\u0016\u00f10\u008f";

    public SeekableFTPStream(URL url) throws IOException {
        this(url, null);
    }

    public SeekableFTPStream(URL url, UserPasswordInput userPasswordInput) throws IOException {
        this.helper = new SeekableFTPStreamHelper(url, userPasswordInput);
    }

    @Override
    public void seek(long position) {
        this.helper.seek(position);
    }

    @Override
    public long position() {
        return this.helper.position();
    }

    @Override
    public boolean eof() throws IOException {
        return this.helper.eof();
    }

    @Override
    public long length() {
        return this.helper.length();
    }

    @Override
    public long skip(long n2) throws IOException {
        return this.helper.skip(n2);
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        return this.helper.read(buffer, offset, len);
    }

    @Override
    public void close() throws IOException {
        this.helper.close();
    }

    @Override
    public int read() throws IOException {
        return this.helper.read();
    }

    public static void main(String[] args) throws IOException {
        String testURL = args.length < 1 ? "ftp://hgdownload.cse.ucsc.edu/goldenPath/panTro3/vsHg19/panTro3.hg19.all.chain.gz" : args[0];
        long startPosition = args.length < 2 ? 11955320L : Long.parseLong(args[1]);
        int len = args.length < 3 ? 8 : Integer.parseInt(args[2]);
        int skipLen = args.length < 4 ? 24 : Integer.parseInt(args[3]);
        SeekableStream s = SeekableStreamFactory.getStreamFor(testURL);
        byte[] buffer = new byte[len];
        s.seek(startPosition);
        s.read(buffer, 0, len);
        if (s.position() != startPosition + (long)len && s.position() != s.length()) {
            System.out.println("1) updated position is incorrect");
        }
        String data = new String(buffer);
        System.out.println("1) read:" + data);
        if (args.length == 0) {
            System.out.println("1) expected:\u00cf\u00ac\u00c9uC\u00d4\u00d5y");
            System.out.println("1) values do" + (EXPECTED1.equals(data) ? "" : " not") + " match");
        }
        s.skip(skipLen);
        s.read(buffer, 0, len);
        if (s.position() != startPosition + (long)(2 * len) + (long)skipLen && s.position() != s.length()) {
            System.out.println("2) updated position is incorrect");
        }
        String data2 = new String(buffer);
        System.out.println("2) read:" + data2);
        if (args.length == 0) {
            System.out.println("2) expected:\u00e4lw\f\u0016\u00f10\u008f");
            System.out.println("2) values do" + (EXPECTED2.equals(data2) ? "" : " not") + " match");
        }
    }
}

