/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.AttributePanel;
import org.broad.igv.ui.panel.DataPanelContainer;
import org.broad.igv.ui.panel.IGVPanel;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.TrackNamePanel;

public class TrackPanel
extends IGVPanel {
    private static Logger log = Logger.getLogger(TrackPanel.class);
    private String name = null;
    private TrackNamePanel namePanel;
    private AttributePanel attributePanel;
    private DataPanelContainer dataPanelContainer;
    private String groupAttribute;
    int trackCountEstimate = 0;
    List<TrackGroup> trackGroups;

    public TrackPanel(String name, MainPanel mainPanel) {
        super(mainPanel);
        this.name = name;
        TrackGroup nullGroup = new TrackGroup();
        nullGroup.setDrawBorder(false);
        this.trackGroups = new LinkedList<TrackGroup>();
        this.trackGroups.add(nullGroup);
        this.init();
    }

    private void init() {
        this.namePanel = new TrackNamePanel(this);
        this.attributePanel = new AttributePanel(this);
        this.dataPanelContainer = new DataPanelContainer(this);
        this.add(this.namePanel);
        this.add(this.attributePanel);
        this.add(this.dataPanelContainer);
    }

    public void createDataPanels() {
        this.dataPanelContainer.createDataPanels();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.namePanel != null) {
            this.namePanel.setBackground(color);
            this.attributePanel.setBackground(color);
            this.dataPanelContainer.setBackground(color);
        }
    }

    public TrackNamePanel getNamePanel() {
        return this.namePanel;
    }

    public AttributePanel getAttributePanel() {
        return this.attributePanel;
    }

    public DataPanelContainer getDataPanelContainer() {
        return this.dataPanelContainer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<TrackGroup> getGroups() {
        return this.trackGroups;
    }

    public boolean hasTracks() {
        for (TrackGroup tg : this.trackGroups) {
            if (tg.getTracks().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public int getVisibleTrackCount() {
        int count = 0;
        for (TrackGroup tg : this.trackGroups) {
            for (Track t : tg.getTracks()) {
                if (t == null || !t.isVisible()) continue;
                ++count;
            }
        }
        return count;
    }

    public List<Track> getTracks() {
        ArrayList<Track> tracks = new ArrayList<Track>(this.trackCountEstimate);
        for (TrackGroup tg : this.trackGroups) {
            tracks.addAll(tg.getTracks());
        }
        return tracks;
    }

    public void clearTracks() {
        this.trackGroups.clear();
        this.trackCountEstimate = 0;
    }

    public void addTrack(Track track) {
        String groupName = this.groupAttribute == null ? null : track.getAttributeValue(this.groupAttribute);
        boolean foundGroup = false;
        for (TrackGroup tg : this.trackGroups) {
            if (this.groupAttribute != null && groupName != null && !tg.getName().equals(groupName)) continue;
            tg.add(track);
            foundGroup = true;
            break;
        }
        if (!foundGroup) {
            TrackGroup newGroup = new TrackGroup(groupName);
            newGroup.add(track);
            if (this.groupAttribute == null) {
                newGroup.setDrawBorder(false);
            }
            this.trackGroups.add(newGroup);
        }
        ++this.trackCountEstimate;
    }

    public void addTracks(Collection<Track> tracks) {
        for (Track t : tracks) {
            this.addTrack(t);
        }
    }

    public void moveGroup(TrackGroup group, int index) {
        if (index > this.trackGroups.indexOf(group)) {
            --index;
        }
        this.trackGroups.remove(group);
        if (index >= this.trackGroups.size()) {
            this.trackGroups.add(group);
        } else {
            this.trackGroups.add(index, group);
        }
    }

    public void reset() {
        this.groupAttribute = null;
        this.trackGroups.clear();
    }

    public void groupTracksByAttribute(String attribute) {
        this.groupAttribute = attribute;
        List<Track> tracks = this.getTracks();
        this.trackGroups.clear();
        if (attribute == null || attribute.length() == 0) {
            TrackGroup nullGroup = new TrackGroup();
            nullGroup.addAll(tracks);
            nullGroup.setDrawBorder(false);
            this.trackGroups.add(nullGroup);
        } else {
            HashMap<String, TrackGroup> groupMap = new HashMap<String, TrackGroup>();
            for (Track track : tracks) {
                TrackGroup group;
                String attributeValue = track.getAttributeValue(attribute);
                if (attributeValue == null) {
                    attributeValue = "";
                }
                if ((group = (TrackGroup)groupMap.get(attributeValue)) == null) {
                    group = new TrackGroup(attributeValue);
                    groupMap.put(attributeValue, group);
                    this.trackGroups.add(group);
                }
                group.add(track);
            }
        }
    }

    public void sortTracksByAttributes(String[] attributeNames, boolean[] ascending) {
        assert (attributeNames.length == ascending.length);
        for (TrackGroup tg : this.trackGroups) {
            tg.sortByAttributes(attributeNames, ascending);
        }
    }

    public void sortTracksByPosition(List<String> trackIds) {
        for (TrackGroup tg : this.trackGroups) {
            tg.sortByList(trackIds);
        }
    }

    public void sortByRegionsScore(RegionOfInterest region, RegionScoreType type, ReferenceFrame frame) {
        boolean useLinkedSorting = PreferenceManager.getInstance().getAsBoolean("ENABLE_LINKED_SORTING");
        String linkingAtt = IGV.getInstance().getSession().getOverlayAttribute();
        this.sortGroupsByRegionScore(this.trackGroups, region, type, frame);
        for (TrackGroup group : this.trackGroups) {
            if (linkingAtt != null && !useLinkedSorting) {
                group.sortByRegionScore(region, type, frame);
                continue;
            }
            group.sortGroup(region, linkingAtt, type, frame);
        }
    }

    private void sortGroupsByRegionScore(List<TrackGroup> groups, RegionOfInterest region, final RegionScoreType type, final ReferenceFrame frame) {
        if (groups != null && region != null && !groups.isEmpty()) {
            final int zoom = Math.max(0, frame.getZoom());
            final String chr = region.getChr();
            final int start = region.getStart();
            final int end = region.getEnd();
            Comparator<TrackGroup> c2 = new Comparator<TrackGroup>(){

                @Override
                public int compare(TrackGroup group1, TrackGroup group2) {
                    float s1 = group1.getRegionScore(chr, start, end, zoom, type, frame);
                    float s2 = group2.getRegionScore(chr, start, end, zoom, type, frame);
                    if (s2 > s1) {
                        return 1;
                    }
                    if (s1 < s2) {
                        return -1;
                    }
                    return 0;
                }
            };
            Collections.sort(groups, c2);
        }
    }

    public boolean replaceTrack(Track oldTrack, Track newTrack) {
        boolean foundTrack = false;
        for (TrackGroup g2 : this.trackGroups) {
            if (!g2.contains(oldTrack)) continue;
            int idx = g2.indexOf(oldTrack);
            g2.remove(oldTrack);
            idx = Math.min(g2.size(), idx);
            if (newTrack != null) {
                g2.add(idx, newTrack);
            }
            foundTrack = true;
        }
        return foundTrack;
    }

    public void removeTracks(Collection<Track> tracksToRemove) {
        for (TrackGroup tg : this.trackGroups) {
            tg.removeTracks(tracksToRemove);
        }
    }

    public void moveSelectedTracksTo(Collection<Track> selectedTracks, Track targetTrack, boolean before) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        for (TrackGroup tg : this.trackGroups) {
            if (!tg.moveSelectedTracksTo(selectedTracks, targetTrack, before)) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPreferredPanelHeight() {
        int height = 0;
        List<TrackGroup> groups = this.getGroups();
        if (groups.size() > 1) {
            height += 10;
        }
        List<TrackGroup> list = groups;
        synchronized (list) {
            for (TrackGroup group : groups) {
                if (group == null || !group.isVisible()) continue;
                if (groups.size() > 1) {
                    height += 10;
                }
                height += group.getHeight();
            }
        }
        return Math.max(20, height);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.height = this.getPreferredPanelHeight();
        return dim;
    }

    @Override
    public void paintOffscreen(Graphics2D g2, Rectangle rect) {
        int h2 = rect.height;
        Component[] children = this.getComponents();
        g2.translate(this.mainPanel.getNamePanelX(), 0);
        Rectangle nameRect = new Rectangle(children[0].getBounds());
        nameRect.height = h2;
        g2.setClip(nameRect);
        ((Paintable)((Object)children[0])).paintOffscreen(g2, nameRect);
        int dx = this.mainPanel.getAttributePanelX() - this.mainPanel.getNamePanelX();
        g2.translate(dx, 0);
        Rectangle attRect = new Rectangle(0, 0, children[1].getWidth(), h2);
        g2.setClip(attRect);
        ((Paintable)((Object)children[1])).paintOffscreen(g2, attRect);
        dx = this.mainPanel.getDataPanelX() - this.mainPanel.getAttributePanelX();
        g2.translate(dx, 0);
        Rectangle dataRect = new Rectangle(0, 0, this.mainPanel.getDataPanelWidth(), h2);
        g2.setClip(dataRect);
        ((Paintable)((Object)children[2])).paintOffscreen(g2, dataRect);
        super.paintBorder(g2);
    }
}

