/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import org.broad.igv.hic.ColorScale;
import org.broad.igv.hic.Context;
import org.broad.igv.hic.HeatmapPanel;
import org.broad.igv.hic.HiCRulerPanel;
import org.broad.igv.hic.ThumbnailPanel;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.hic.data.Dataset;
import org.broad.igv.hic.data.DatasetReader;
import org.broad.igv.hic.data.Matrix;
import org.broad.igv.hic.data.MatrixZoomData;
import org.broad.igv.ui.util.IconFactory;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;
import org.broad.tribble.util.SeekableStream;

public class MainWindow
extends JFrame {
    public static final int MIN_BIN_WIDTH = 2;
    public static Cursor fistCursor;
    public static int[] zoomBinSizes;
    public static final int MAX_ZOOM = 10;
    public Context xContext;
    public Context yContext;
    Dataset dataset;
    MatrixZoomData zd;
    private Chromosome[] chromosomes;
    ColorScale colorScale;
    private int[] chromosomeBoundaries;
    private JPanel panel2;
    private JPanel panel4;
    private JPanel chrSelectionPanel;
    private JComboBox chrBox1;
    private JComboBox chrBox2;
    private JButton refreshButton;
    private JPanel panel1;
    private JLabel label1;
    private JTextField minRange;
    private JLabel label3;
    private JTextField maxRange;
    private JPanel panel7;
    private JLabel label2;
    private JButton zoomOutButton;
    private JButton zoomInButton;
    private JPanel panel3;
    private JPanel panel5;
    private JPanel spacerLeft;
    private HiCRulerPanel rulerPanel2;
    private JPanel spacerRight;
    private HeatmapPanel heatmapPanel;
    private HiCRulerPanel rulerPanel1;
    private JPanel panel8;
    ThumbnailPanel thumbnailPanel;
    private JMenuBar menuBar1;
    private JMenu fileMenu;
    private JMenuItem loadMenuItem;
    private JMenuItem loadFromURL;
    private JMenuItem loadDmelDataset;
    private JMenuItem loadGM;
    private JMenuItem load562;
    private JMenuItem exit;

    public static void main(String[] args) throws IOException {
        MainWindow mainWindow = new MainWindow();
        mainWindow.setVisible(true);
        mainWindow.setSize(870, 870);
    }

    public void createCursors() {
        BufferedImage handImage = new BufferedImage(32, 32, 2);
        Graphics2D g2 = handImage.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(1, 0.0f));
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, 32.0, 32.0);
        g2.fill(rect);
        g2 = handImage.createGraphics();
        g2.drawImage(IconFactory.getInstance().getIcon(IconFactory.IconID.FIST).getImage(), 0, 0, null);
        fistCursor = this.getToolkit().createCustomCursor(handImage, new Point(8, 6), "Move");
    }

    public MainWindow() throws IOException {
        int initialMaxCount = 50000;
        this.colorScale = new ColorScale();
        this.colorScale.maxCount = initialMaxCount;
        this.colorScale.background = Color.white;
        this.initComponents();
        this.rootPane.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        this.rootPane.getGlassPane().addMouseListener(new MouseAdapter(){});
        this.createCursors();
        this.maxRange.setText(String.valueOf(this.colorScale.maxCount));
        this.minRange.setText(String.valueOf(this.colorScale.minCount));
        this.thumbnailPanel.setMainWindow(this);
        this.getHeatmapPanel().setSize(500, 500);
        this.thumbnailPanel.setPreferredSize(new Dimension(100, 100));
        ZoomLabel[] zooms = new ZoomLabel[]{new ZoomLabel("2.5 mb", 0), new ZoomLabel("1   mb", 1), new ZoomLabel("500 kb", 2), new ZoomLabel("250 kb", 3), new ZoomLabel("100 kb", 4), new ZoomLabel("50  kb", 5), new ZoomLabel("25  kb", 6), new ZoomLabel("10  kb", 7), new ZoomLabel("5   kb", 8), new ZoomLabel("2.5 kb", 9), new ZoomLabel("1   kb", 10)};
        this.pack();
        this.setDefaultCloseOperation(3);
    }

    public HeatmapPanel getHeatmapPanel() {
        return this.heatmapPanel;
    }

    public boolean isWholeGenome() {
        return this.xContext != null && this.xContext.getChromosome().getName().equals("All");
    }

    public Chromosome[] getChromosomes() {
        return this.chromosomes;
    }

    public void setChromosomes(Chromosome[] chromosomes) {
        this.chromosomes = chromosomes;
        this.chromosomeBoundaries = new int[chromosomes.length - 1];
        long bound = 0L;
        for (int i2 = 1; i2 < chromosomes.length; ++i2) {
            Chromosome c2 = chromosomes[i2];
            this.getChromosomeBoundaries()[i2 - 1] = (int)(bound += (long)(c2.getSize() / 1000));
        }
    }

    public int[] getChromosomeBoundaries() {
        return this.chromosomeBoundaries;
    }

    public void setSelectedChromosomes(Chromosome xChrom, Chromosome yChrom) {
        this.chrBox1.setSelectedIndex(yChrom.getIndex());
        this.chrBox2.setSelectedIndex(xChrom.getIndex());
        this.refreshChromosomes();
    }

    private void load(String file) throws IOException {
        if (file.endsWith("hic")) {
            SeekableStream ss = IGVSeekableStreamFactory.getStreamFor(file);
            this.dataset = new DatasetReader(ss).read();
            this.setChromosomes(this.dataset.getChromosomes());
            this.chrBox1.setModel(new DefaultComboBoxModel<Chromosome>(this.getChromosomes()));
            this.chrBox2.setModel(new DefaultComboBoxModel<Chromosome>(this.getChromosomes()));
        }
        this.setTitle(file);
        this.xContext = null;
        this.yContext = null;
        this.refreshChromosomes();
    }

    private void refreshChromosomes() {
        this.getRootPane().getGlassPane().setVisible(true);
        SwingWorker worker = new SwingWorker(){

            @Override
            protected void done() {
                MainWindow.this.getGlassPane().setVisible(false);
                MainWindow.this.getContentPane().repaint();
            }

            protected Object doInBackground() throws Exception {
                Chromosome chr1 = (Chromosome)MainWindow.this.chrBox1.getSelectedItem();
                Chromosome chr2 = (Chromosome)MainWindow.this.chrBox2.getSelectedItem();
                MainWindow.this.zoomInButton.setEnabled(chr1.getIndex() != 0);
                MainWindow.this.zoomOutButton.setEnabled(chr1.getIndex() != 0);
                int t1 = chr1.getIndex();
                int t2 = chr2.getIndex();
                if (t1 > t2) {
                    Chromosome tmp = chr2;
                    chr2 = chr1;
                    chr1 = tmp;
                }
                MainWindow.this.getHeatmapPanel().clearTileCache();
                if (MainWindow.this.xContext != null && MainWindow.this.xContext.getChromosome().getIndex() == chr2.getIndex() && MainWindow.this.yContext != null && MainWindow.this.yContext.getChromosome().getIndex() == chr1.getIndex()) {
                    MainWindow.this.repaint();
                } else {
                    MainWindow.this.xContext = new Context(chr2);
                    MainWindow.this.yContext = new Context(chr1);
                    MainWindow.this.rulerPanel2.setFrame(MainWindow.this.xContext, HiCRulerPanel.Orientation.HORIZONTAL);
                    MainWindow.this.rulerPanel1.setFrame(MainWindow.this.yContext, HiCRulerPanel.Orientation.VERTICAL);
                    Matrix m2 = MainWindow.this.dataset.getMatrix(chr1, chr2);
                    if (m2 != null) {
                        MainWindow.this.setInitialZoom();
                    }
                    Image thumbnail = MainWindow.this.getHeatmapPanel().getThumbnailImage(MainWindow.this.zd, MainWindow.this.thumbnailPanel.getWidth(), MainWindow.this.thumbnailPanel.getHeight());
                    MainWindow.this.thumbnailPanel.setImage(thumbnail);
                }
                return null;
            }
        };
        worker.execute();
    }

    private void setInitialZoom() {
        int pixels;
        int len = Math.max(this.xContext.getChrLength(), this.yContext.getChrLength());
        int maxNBins = pixels = this.getHeatmapPanel().getWidth();
        if (this.xContext.getChromosome().getName().equals("All")) {
            this.setZoom(0, -1, -1);
        } else {
            int bp_bin = len / maxNBins;
            int initialZoom = zoomBinSizes.length - 1;
            for (int z = 1; z < zoomBinSizes.length; ++z) {
                if (zoomBinSizes[z] >= bp_bin) continue;
                initialZoom = z - 1;
                break;
            }
            this.setZoom(initialZoom, -1, -1);
        }
    }

    public void setZoom(int newZoom) {
        newZoom = Math.max(0, Math.min(newZoom, 10));
        int centerLocationX = (int)this.xContext.getChromosomePosition(this.getHeatmapPanel().getWidth() / 2);
        int centerLocationY = (int)this.yContext.getChromosomePosition(this.getHeatmapPanel().getHeight() / 2);
        this.setZoom(newZoom, centerLocationX, centerLocationY);
        this.zoomInButton.setEnabled(newZoom < 10);
        this.zoomOutButton.setEnabled(newZoom > 0);
    }

    public void setZoom(int newZoom, int centerLocationX, int centerLocationY) {
        if (newZoom < 0 || newZoom > 10) {
            return;
        }
        Chromosome chr1 = this.xContext.getChromosome();
        Chromosome chr2 = this.yContext.getChromosome();
        this.zd = this.dataset.getMatrix(chr1, chr2).getZoomData(newZoom);
        int newBinSize = this.zd.getBinSize();
        double scale = newBinSize;
        double xScaleMax = (double)this.xContext.getChrLength() / (double)this.getHeatmapPanel().getWidth();
        double yScaleMax = (double)this.yContext.getChrLength() / (double)this.getHeatmapPanel().getWidth();
        double scaleMax = Math.min(xScaleMax, yScaleMax);
        scale = Math.min(scale, scaleMax);
        this.xContext.setZoom(newZoom, scale);
        this.yContext.setZoom(newZoom, scale);
        this.center(centerLocationX, centerLocationY);
        this.getHeatmapPanel().clearTileCache();
        this.repaint();
    }

    public void zoomTo(double xBP, double yBP, double scale) {
        int zoom = zoomBinSizes.length - 1;
        for (int z = 1; z < zoomBinSizes.length; ++z) {
            if (!((double)zoomBinSizes[z] < scale)) continue;
            zoom = z - 1;
            break;
        }
        Chromosome chr1 = this.xContext.getChromosome();
        Chromosome chr2 = this.yContext.getChromosome();
        this.zd = this.dataset.getMatrix(chr1, chr2).getZoomData(zoom);
        this.xContext.setZoom(zoom, scale);
        this.yContext.setZoom(zoom, scale);
        this.xContext.setOrigin((int)xBP);
        this.yContext.setOrigin((int)yBP);
        this.getHeatmapPanel().clearTileCache();
        this.repaint();
    }

    public void center(int centerLocationX, int centerLocationY) {
        int binSize;
        if (centerLocationX < 0) {
            this.xContext.setOrigin(0);
        } else {
            binSize = this.zd.getBinSize();
            double w = (double)this.getHeatmapPanel().getWidth() * this.xContext.getScale();
            this.xContext.setOrigin((int)((double)centerLocationX - w / 2.0));
        }
        if (centerLocationY < 0) {
            this.yContext.setOrigin(0);
        } else {
            binSize = this.zd.getBinSize();
            double h2 = (double)this.getHeatmapPanel().getHeight() * this.yContext.getScale();
            this.yContext.setOrigin((int)((double)centerLocationY - h2 / 2.0));
        }
        this.repaint();
    }

    public void moveBy(int dx, int dy) {
        int maxX = (int)((double)this.xContext.getChrLength() - this.xContext.getScale() * (double)this.getHeatmapPanel().getWidth());
        int maxY = (int)((double)this.yContext.getChrLength() - this.yContext.getScale() * (double)this.getHeatmapPanel().getHeight());
        int x = Math.max(0, Math.min(maxX, this.xContext.getOrigin() + dx));
        int y = Math.max(0, Math.min(maxY, this.yContext.getOrigin() + dy));
        this.xContext.setOrigin(x);
        this.yContext.setOrigin(y);
        this.repaint();
    }

    private void heatmapPanelMouseDragged(MouseEvent e2) {
    }

    private void refreshButtonActionPerformed(ActionEvent e2) {
        this.refreshChromosomes();
    }

    private void loadMenuItemActionPerformed(ActionEvent e2) {
        FileDialog dlg = new FileDialog(this);
        dlg.setMode(0);
        dlg.setVisible(true);
        String file = dlg.getFile();
        if (file != null) {
            try {
                File f2 = new File(dlg.getDirectory(), dlg.getFile());
                this.load(f2.getAbsolutePath());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void loadFromURLActionPerformed(ActionEvent e2) {
        String url = JOptionPane.showInputDialog("Enter URL: ");
        if (url != null) {
            try {
                this.load(url);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void exitActionPerformed(ActionEvent e2) {
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    private void loadDmelDatasetActionPerformed(ActionEvent e2) {
        try {
            this.colorScale.maxCount = 20000;
            this.maxRange.setText("20000");
            this.minRange.setText("0");
            this.zd = null;
            this.load("http://iwww.broadinstitute.org/igvdata/hic/dmel/selected_formatted.hic");
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this, "Error loading data: " + e1.getMessage());
        }
    }

    private void loadGMActionPerformed(ActionEvent e2) {
        try {
            this.colorScale.maxCount = 100;
            this.maxRange.setText("100");
            this.minRange.setText("0");
            this.zd = null;
            this.load("http://www.broadinstitute.org/igvdata/hic/hg18/GM.summary.binned.hic");
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this, "Error loading data: " + e1.getMessage());
        }
    }

    private void load562ActionPerformed(ActionEvent e2) {
        try {
            this.colorScale.maxCount = 100;
            this.maxRange.setText("100");
            this.minRange.setText("0");
            this.zd = null;
            this.load("http://www.broadinstitute.org/igvdata/hic/hg18/K562.summary.binned.hic");
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this, "Error loading data: " + e1.getMessage());
        }
    }

    private void minRangeFocusLost(FocusEvent e2) {
        this.minRangeActionPerformed(null);
    }

    private void maxRangeFocusLost(FocusEvent e2) {
        this.maxRangeActionPerformed(null);
    }

    private void minRangeActionPerformed(ActionEvent e2) {
        try {
            int min;
            this.colorScale.minCount = min = Integer.parseInt(this.minRange.getText());
            this.heatmapPanel.clearTileCache();
            this.repaint();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void maxRangeActionPerformed(ActionEvent e2) {
        try {
            int max;
            this.colorScale.maxCount = max = Integer.parseInt(this.maxRange.getText());
            this.heatmapPanel.clearTileCache();
            this.repaint();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void chrBox1ActionPerformed(ActionEvent e2) {
        if (this.chrBox1.getSelectedIndex() == 0) {
            this.chrBox2.setSelectedIndex(0);
            this.refreshChromosomes();
        }
    }

    private void chrBox2ActionPerformed(ActionEvent e2) {
        if (this.chrBox2.getSelectedIndex() == 0) {
            this.chrBox1.setSelectedIndex(0);
            this.refreshChromosomes();
        }
    }

    private void zoomOutButtonActionPerformed(ActionEvent e2) {
        int z = this.xContext.getZoom();
        int newZoom = Math.max(z - 1, 0);
        this.setZoom(newZoom);
        this.repaint();
    }

    private void zoomInButtonActionPerformed(ActionEvent e2) {
        int z = this.xContext.getZoom();
        int newZoom = Math.min(z + 1, 10);
        this.setZoom(newZoom);
        this.repaint();
    }

    private void initComponents() {
        this.panel2 = new JPanel();
        this.panel4 = new JPanel();
        this.chrSelectionPanel = new JPanel();
        this.chrBox1 = new JComboBox();
        this.chrBox2 = new JComboBox();
        this.refreshButton = new JButton();
        this.panel1 = new JPanel();
        this.label1 = new JLabel();
        this.minRange = new JTextField();
        this.label3 = new JLabel();
        this.maxRange = new JTextField();
        this.panel7 = new JPanel();
        this.label2 = new JLabel();
        this.zoomOutButton = new JButton();
        this.zoomInButton = new JButton();
        this.panel3 = new JPanel();
        this.panel5 = new JPanel();
        this.spacerLeft = new JPanel();
        this.rulerPanel2 = new HiCRulerPanel(this);
        this.spacerRight = new JPanel();
        this.heatmapPanel = new HeatmapPanel(this);
        this.rulerPanel1 = new HiCRulerPanel(this);
        this.panel8 = new JPanel();
        this.thumbnailPanel = new ThumbnailPanel();
        this.menuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.loadMenuItem = new JMenuItem();
        this.loadFromURL = new JMenuItem();
        this.loadDmelDataset = new JMenuItem();
        this.loadGM = new JMenuItem();
        this.load562 = new JMenuItem();
        this.exit = new JMenuItem();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.panel2.setLayout(new BorderLayout());
        this.panel4.setBorder(new MatteBorder(1, 1, 1, 1, Color.black));
        this.panel4.setLayout(new FlowLayout(0, 25, 5));
        this.chrSelectionPanel.setBorder(new MatteBorder(1, 1, 1, 1, Color.black));
        this.chrSelectionPanel.setLayout(new FlowLayout());
        this.chrBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MainWindow.this.chrBox1ActionPerformed(e2);
            }
        });
        this.chrSelectionPanel.add(this.chrBox1);
        this.chrBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MainWindow.this.chrBox2ActionPerformed(e2);
            }
        });
        this.chrSelectionPanel.add(this.chrBox2);
        this.refreshButton.setText("Refresh");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MainWindow.this.refreshButtonActionPerformed(e2);
            }
        });
        this.chrSelectionPanel.add(this.refreshButton);
        this.panel4.add(this.chrSelectionPanel);
        this.panel1.setBorder(new LineBorder(Color.black));
        this.panel1.setLayout(new FlowLayout());
        this.label1.setText("Color Range");
        this.label1.setHorizontalAlignment(0);
        this.label1.setToolTipText("Range of color scale in counts per mega-base squared.");
        this.panel1.add(this.label1);
        this.minRange.setPreferredSize(new Dimension(64, 26));
        this.minRange.setMinimumSize(new Dimension(14, 26));
        this.minRange.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                MainWindow.this.minRangeFocusLost(e2);
            }
        });
        this.minRange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MainWindow.this.minRangeActionPerformed(e2);
            }
        });
        this.panel1.add(this.minRange);
        this.label3.setText("to");
        this.panel1.add(this.label3);
        this.maxRange.setPreferredSize(new Dimension(64, 26));
        this.maxRange.setMinimumSize(new Dimension(14, 26));
        this.maxRange.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                MainWindow.this.maxRangeFocusLost(e2);
            }
        });
        this.maxRange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MainWindow.this.maxRangeActionPerformed(e2);
            }
        });
        this.panel1.add(this.maxRange);
        this.panel4.add(this.panel1);
        this.panel7.setBorder(new MatteBorder(1, 1, 1, 1, Color.black));
        this.panel7.setLayout(new FlowLayout());
        this.label2.setText("Zoom ");
        this.panel7.add(this.label2);
        this.zoomOutButton.setText("-");
        this.zoomOutButton.setMinimumSize(new Dimension(5, 5));
        this.zoomOutButton.setPreferredSize(new Dimension(29, 29));
        this.zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MainWindow.this.zoomOutButtonActionPerformed(e2);
            }
        });
        this.panel7.add(this.zoomOutButton);
        this.zoomInButton.setText("+");
        this.zoomInButton.setPreferredSize(new Dimension(25, 29));
        this.zoomInButton.setMinimumSize(new Dimension(5, 29));
        this.zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MainWindow.this.zoomInButtonActionPerformed(e2);
            }
        });
        this.panel7.add(this.zoomInButton);
        this.panel4.add(this.panel7);
        this.panel2.add((Component)this.panel4, "North");
        this.panel3.setLayout(new BorderLayout());
        this.panel5.setLayout(new BorderLayout());
        this.spacerLeft.setMaximumSize(new Dimension(50, 50));
        this.spacerLeft.setMinimumSize(new Dimension(50, 50));
        this.spacerLeft.setPreferredSize(new Dimension(50, 50));
        this.spacerLeft.setLayout(null);
        this.panel5.add((Component)this.spacerLeft, "West");
        this.rulerPanel2.setMaximumSize(new Dimension(4000, 50));
        this.rulerPanel2.setMinimumSize(new Dimension(1, 50));
        this.rulerPanel2.setPreferredSize(new Dimension(1, 50));
        this.rulerPanel2.setBorder(null);
        this.panel5.add((Component)this.rulerPanel2, "Center");
        this.spacerRight.setMinimumSize(new Dimension(120, 0));
        this.spacerRight.setPreferredSize(new Dimension(120, 0));
        this.spacerRight.setMaximumSize(new Dimension(120, Short.MAX_VALUE));
        this.spacerRight.setLayout(null);
        this.panel5.add((Component)this.spacerRight, "East");
        this.panel3.add((Component)this.panel5, "North");
        this.heatmapPanel.setBorder(LineBorder.createBlackLineBorder());
        this.heatmapPanel.setMaximumSize(new Dimension(500, 500));
        this.heatmapPanel.setMinimumSize(new Dimension(500, 500));
        this.heatmapPanel.setPreferredSize(new Dimension(500, 500));
        this.heatmapPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                MainWindow.this.heatmapPanelMouseDragged(e2);
            }
        });
        this.panel3.add((Component)this.heatmapPanel, "Center");
        this.rulerPanel1.setMaximumSize(new Dimension(50, 4000));
        this.rulerPanel1.setPreferredSize(new Dimension(50, 500));
        this.rulerPanel1.setBorder(null);
        this.rulerPanel1.setMinimumSize(new Dimension(50, 1));
        this.panel3.add((Component)this.rulerPanel1, "West");
        this.panel8.setMaximumSize(new Dimension(120, 100));
        this.panel8.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.panel8.setLayout(new FlowLayout());
        this.thumbnailPanel.setMaximumSize(new Dimension(100, 100));
        this.thumbnailPanel.setMinimumSize(new Dimension(100, 100));
        this.thumbnailPanel.setPreferredSize(new Dimension(100, 100));
        this.thumbnailPanel.setBorder(LineBorder.createBlackLineBorder());
        this.panel8.add(this.thumbnailPanel);
        this.panel3.add((Component)this.panel8, "East");
        this.panel2.add((Component)this.panel3, "Center");
        contentPane.add((Component)this.panel2, "Center");
        this.fileMenu.setText("File");
        this.loadMenuItem.setText("Load...");
        this.loadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MainWindow.this.loadMenuItemActionPerformed(e2);
            }
        });
        this.fileMenu.add(this.loadMenuItem);
        this.loadFromURL.setText("Load from URL ...");
        this.loadFromURL.setName("loadFromURL");
        this.loadFromURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MainWindow.this.loadFromURLActionPerformed(e2);
            }
        });
        this.fileMenu.add(this.loadFromURL);
        this.fileMenu.addSeparator();
        this.loadDmelDataset.setText("Fly");
        this.loadDmelDataset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MainWindow.this.loadDmelDatasetActionPerformed(e2);
            }
        });
        this.fileMenu.add(this.loadDmelDataset);
        this.loadGM.setText("GM cell line (human)");
        this.loadGM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MainWindow.this.loadGMActionPerformed(e2);
            }
        });
        this.fileMenu.add(this.loadGM);
        this.load562.setText("K562 cell line (human)");
        this.load562.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MainWindow.this.load562ActionPerformed(e2);
            }
        });
        this.fileMenu.add(this.load562);
        this.fileMenu.addSeparator();
        this.exit.setText("Exit");
        this.exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MainWindow.this.exitActionPerformed(e2);
            }
        });
        this.fileMenu.add(this.exit);
        this.menuBar1.add(this.fileMenu);
        contentPane.add((Component)this.menuBar1, "North");
        this.setLocationRelativeTo(this.getOwner());
    }

    static {
        zoomBinSizes = new int[]{2500000, 1000000, 500000, 250000, 100000, 50000, 25000, 10000, 5000, 2500, 1000};
    }

    class ZoomLabel {
        String label;
        int zoom;

        ZoomLabel(String label, int zoom) {
            this.label = label;
            this.zoom = zoom;
        }

        public String toString() {
            return this.label;
        }
    }
}

