/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import org.broad.igv.hic.data.Chromosome;

public class Context {
    private Chromosome chromosome;
    private int zoom = 4;
    private int origin = 0;
    private double scale;

    public Context(Chromosome chromosome) {
        this.chromosome = chromosome;
    }

    public void setOrigin(int x) {
        this.origin = Math.max(0, x);
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom, double scale) {
        this.scale = scale;
        this.zoom = zoom;
    }

    public int getOrigin() {
        return this.origin;
    }

    public int getChrLength() {
        return this.chromosome.getSize();
    }

    public double getScale() {
        return this.scale;
    }

    public int getScreenPosition(double chromosomePosition) {
        return (int)((chromosomePosition - (double)this.origin) / this.scale);
    }

    public double getChromosomePosition(int screenPosition) {
        return (double)this.origin + (double)screenPosition * this.scale;
    }

    public Chromosome getChromosome() {
        return this.chromosome;
    }
}

