/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gwas;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.util.ParsingUtils;

public class DescriptionCache {
    private static final Logger log = Logger.getLogger(DescriptionCache.class);
    private int maxSize;
    private ArrayList<String> chrs = new ArrayList();
    private ArrayList<Integer> locations = new ArrayList();
    private ArrayList<Float> values = new ArrayList();
    private ArrayList<String> descriptions = new ArrayList();
    private String[] headerTokens = new String[1000];

    public DescriptionCache() {
        PreferenceManager prefs = PreferenceManager.getInstance();
        this.maxSize = prefs.getAsInt("GWAS_DESCRIPTION_CACHE_SIZE");
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize < 10) {
            maxSize = 10;
        }
        this.maxSize = maxSize;
    }

    public String[] getHeaderTokens() {
        return this.headerTokens;
    }

    public void setHeaderTokens(String[] headerTokens) {
        this.headerTokens = headerTokens;
    }

    public void setHeaderTokens(String headerString) {
        headerString = headerString.trim();
        ParsingUtils.splitWhitespace(headerString, this.headerTokens);
    }

    public void clear() {
        this.chrs = new ArrayList();
        this.locations = new ArrayList();
        this.descriptions = new ArrayList();
    }

    public boolean add(String chr, int location, float value, String description) {
        if (this.locations.size() >= this.maxSize) {
            this.locations.remove(0);
            this.chrs.remove(0);
            this.descriptions.remove(0);
            this.values.remove(0);
        }
        return this.chrs.add(chr) & this.locations.add(location) & this.descriptions.add(description) & this.values.add(Float.valueOf(value));
    }

    public String getDescription(String chr, int location, float value) {
        String description = null;
        boolean descriptionFound = false;
        for (int indexCounter = 0; indexCounter < this.descriptions.size() && !descriptionFound; ++indexCounter) {
            if (!this.chrs.get(indexCounter).equals(chr) || this.locations.get(indexCounter) != location || this.values.get(indexCounter).floatValue() != value) continue;
            description = this.descriptions.get(indexCounter);
            descriptionFound = true;
        }
        return description;
    }

    public String getDescriptionString(String chr, int location, float value) {
        String description = this.getDescription(chr, location, value);
        String descriptionString = null;
        if (description != null) {
            descriptionString = "";
            int headersSize = this.getHeaderTokens().length;
            String[] tokens = new String[1000];
            ParsingUtils.splitWhitespace(description, tokens);
            for (int i2 = 0; i2 < headersSize; ++i2) {
                String tmpHeaderToken = this.getHeaderTokens()[i2];
                if (tmpHeaderToken == null) continue;
                descriptionString = descriptionString + tmpHeaderToken + ": " + tokens[i2] + "<br>";
            }
        }
        return descriptionString;
    }
}

