/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.inference;

import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.ChiSquaredDistribution;
import org.apache.commons.math.distribution.DistributionFactory;
import org.apache.commons.math.stat.inference.ChiSquareTest;

public class ChiSquareTestImpl
implements ChiSquareTest {
    private DistributionFactory distributionFactory = null;

    public double chiSquare(double[] expected, long[] observed) throws IllegalArgumentException {
        double sumSq = 0.0;
        double dev = 0.0;
        if (expected.length < 2 || expected.length != observed.length) {
            throw new IllegalArgumentException("observed, expected array lengths incorrect");
        }
        if (!this.isPositive(expected) || !this.isNonNegative(observed)) {
            throw new IllegalArgumentException("observed counts must be non-negative and expected counts must be postive");
        }
        int i2 = 0;
        while (i2 < observed.length) {
            dev = (double)observed[i2] - expected[i2];
            sumSq += dev * dev / expected[i2];
            ++i2;
        }
        return sumSq;
    }

    public double chiSquareTest(double[] expected, long[] observed) throws IllegalArgumentException, MathException {
        ChiSquaredDistribution chiSquaredDistribution = this.getDistributionFactory().createChiSquareDistribution((double)expected.length - 1.0);
        return 1.0 - chiSquaredDistribution.cumulativeProbability(this.chiSquare(expected, observed));
    }

    public boolean chiSquareTest(double[] expected, long[] observed, double alpha) throws IllegalArgumentException, MathException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new IllegalArgumentException("bad significance level: " + alpha);
        }
        return this.chiSquareTest(expected, observed) < alpha;
    }

    public double chiSquare(long[][] counts) throws IllegalArgumentException {
        this.checkArray(counts);
        int nRows = counts.length;
        int nCols = counts[0].length;
        double[] rowSum = new double[nRows];
        double[] colSum = new double[nCols];
        double total = 0.0;
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                int n2 = row;
                rowSum[n2] = rowSum[n2] + (double)counts[row][col];
                int n3 = col;
                colSum[n3] = colSum[n3] + (double)counts[row][col];
                total += (double)counts[row][col];
                ++col;
            }
            ++row;
        }
        double sumSq = 0.0;
        double expected = 0.0;
        int row2 = 0;
        while (row2 < nRows) {
            int col = 0;
            while (col < nCols) {
                expected = rowSum[row2] * colSum[col] / total;
                sumSq += ((double)counts[row2][col] - expected) * ((double)counts[row2][col] - expected) / expected;
                ++col;
            }
            ++row2;
        }
        return sumSq;
    }

    public double chiSquareTest(long[][] counts) throws IllegalArgumentException, MathException {
        this.checkArray(counts);
        double df = ((double)counts.length - 1.0) * ((double)counts[0].length - 1.0);
        ChiSquaredDistribution chiSquaredDistribution = this.getDistributionFactory().createChiSquareDistribution(df);
        return 1.0 - chiSquaredDistribution.cumulativeProbability(this.chiSquare(counts));
    }

    public boolean chiSquareTest(long[][] counts, double alpha) throws IllegalArgumentException, MathException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new IllegalArgumentException("bad significance level: " + alpha);
        }
        return this.chiSquareTest(counts) < alpha;
    }

    private void checkArray(long[][] in) throws IllegalArgumentException {
        if (in.length < 2) {
            throw new IllegalArgumentException("Input table must have at least two rows");
        }
        if (in[0].length < 2) {
            throw new IllegalArgumentException("Input table must have at least two columns");
        }
        if (!this.isRectangular(in)) {
            throw new IllegalArgumentException("Input table must be rectangular");
        }
        if (!this.isNonNegative(in)) {
            throw new IllegalArgumentException("All entries in input 2-way table must be non-negative");
        }
    }

    protected DistributionFactory getDistributionFactory() {
        if (this.distributionFactory == null) {
            this.distributionFactory = DistributionFactory.newInstance();
        }
        return this.distributionFactory;
    }

    private boolean isRectangular(long[][] in) {
        int i2 = 1;
        while (i2 < in.length) {
            if (in[i2].length != in[0].length) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private boolean isPositive(double[] in) {
        int i2 = 0;
        while (i2 < in.length) {
            if (in[i2] <= 0.0) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private boolean isNonNegative(long[] in) {
        int i2 = 0;
        while (i2 < in.length) {
            if (in[i2] < 0L) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private boolean isNonNegative(long[][] in) {
        int i2 = 0;
        while (i2 < in.length) {
            int j2 = 0;
            while (j2 < in[i2].length) {
                if (in[i2][j2] < 0L) {
                    return false;
                }
                ++j2;
            }
            ++i2;
        }
        return true;
    }
}

