/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import org.apache.batik.util.EncodingUtilities;
import org.apache.batik.xml.XMLCharacters;

public class XMLUtilities
extends XMLCharacters {
    protected XMLUtilities() {
    }

    public static boolean isXMLSpace(char c2) {
        return c2 <= ' ' && (4294977024L >> c2 & 1L) != 0L;
    }

    public static boolean isXMLNameFirstCharacter(char c2) {
        return (XMLCharacters.NAME_FIRST_CHARACTER[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static boolean isXML11NameFirstCharacter(char c2) {
        return (XMLCharacters.NAME11_FIRST_CHARACTER[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static boolean isXMLNameCharacter(char c2) {
        return (XMLCharacters.NAME_CHARACTER[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static boolean isXML11NameCharacter(char c2) {
        return (XMLCharacters.NAME11_CHARACTER[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static boolean isXMLCharacter(int c2) {
        return (XMLCharacters.XML_CHARACTER[c2 >>> 5] & 1 << (c2 & 0x1F)) != 0 || c2 >= 65536 && c2 <= 0x10FFFF;
    }

    public static boolean isXML11Character(int c2) {
        return c2 >= 1 && c2 <= 55295 || c2 >= 57344 && c2 <= 65533 || c2 >= 65536 && c2 <= 0x10FFFF;
    }

    public static boolean isXMLPublicIdCharacter(char c2) {
        return c2 < '\u0080' && (XMLCharacters.PUBLIC_ID_CHARACTER[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static boolean isXMLVersionCharacter(char c2) {
        return c2 < '\u0080' && (XMLCharacters.VERSION_CHARACTER[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static boolean isXMLAlphabeticCharacter(char c2) {
        return c2 < '\u0080' && (XMLCharacters.ALPHABETIC_CHARACTER[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static Reader createXMLDocumentReader(InputStream is) throws IOException {
        PushbackInputStream pbis = new PushbackInputStream(is, 128);
        byte[] buf = new byte[4];
        int len = pbis.read(buf);
        if (len > 0) {
            pbis.unread(buf, 0, len);
        }
        if (len == 4) {
            switch (buf[0] & 0xFF) {
                case 0: {
                    if (buf[1] != 60 || buf[2] != 0 || buf[3] != 63) break;
                    return new InputStreamReader((InputStream)pbis, "UnicodeBig");
                }
                case 60: {
                    switch (buf[1] & 0xFF) {
                        case 0: {
                            if (buf[2] != 63 || buf[3] != 0) break;
                            return new InputStreamReader((InputStream)pbis, "UnicodeLittle");
                        }
                        case 63: {
                            if (buf[2] != 120 || buf[3] != 109) break;
                            Reader r = XMLUtilities.createXMLDeclarationReader(pbis, "UTF8");
                            String enc = XMLUtilities.getXMLDeclarationEncoding(r, "UTF8");
                            return new InputStreamReader((InputStream)pbis, enc);
                        }
                    }
                    break;
                }
                case 76: {
                    if (buf[1] != 111 || (buf[2] & 0xFF) != 167 || (buf[3] & 0xFF) != 148) break;
                    Reader r = XMLUtilities.createXMLDeclarationReader(pbis, "CP037");
                    String enc = XMLUtilities.getXMLDeclarationEncoding(r, "CP037");
                    return new InputStreamReader((InputStream)pbis, enc);
                }
                case 254: {
                    if ((buf[1] & 0xFF) != 255) break;
                    return new InputStreamReader((InputStream)pbis, "Unicode");
                }
                case 255: {
                    if ((buf[1] & 0xFF) != 254) break;
                    return new InputStreamReader((InputStream)pbis, "Unicode");
                }
            }
        }
        return new InputStreamReader((InputStream)pbis, "UTF8");
    }

    protected static Reader createXMLDeclarationReader(PushbackInputStream pbis, String enc) throws IOException {
        byte[] buf = new byte[128];
        int len = pbis.read(buf);
        if (len > 0) {
            pbis.unread(buf, 0, len);
        }
        return new InputStreamReader((InputStream)new ByteArrayInputStream(buf, 4, len), enc);
    }

    protected static String getXMLDeclarationEncoding(Reader r, String e2) throws IOException {
        int c2 = r.read();
        if (c2 != 108) {
            return e2;
        }
        c2 = r.read();
        if (!XMLUtilities.isXMLSpace((char)c2)) {
            return e2;
        }
        while (XMLUtilities.isXMLSpace((char)(c2 = r.read()))) {
        }
        if (c2 != 118) {
            return e2;
        }
        c2 = r.read();
        if (c2 != 101) {
            return e2;
        }
        c2 = r.read();
        if (c2 != 114) {
            return e2;
        }
        c2 = r.read();
        if (c2 != 115) {
            return e2;
        }
        c2 = r.read();
        if (c2 != 105) {
            return e2;
        }
        c2 = r.read();
        if (c2 != 111) {
            return e2;
        }
        c2 = r.read();
        if (c2 != 110) {
            return e2;
        }
        c2 = r.read();
        while (XMLUtilities.isXMLSpace((char)c2)) {
            c2 = r.read();
        }
        if (c2 != 61) {
            return e2;
        }
        while (XMLUtilities.isXMLSpace((char)(c2 = r.read()))) {
        }
        if (c2 != 34 && c2 != 39) {
            return e2;
        }
        char sc = (char)c2;
        while ((c2 = r.read()) != sc) {
            if (XMLUtilities.isXMLVersionCharacter((char)c2)) continue;
            return e2;
        }
        c2 = r.read();
        if (!XMLUtilities.isXMLSpace((char)c2)) {
            return e2;
        }
        while (XMLUtilities.isXMLSpace((char)(c2 = r.read()))) {
        }
        if (c2 != 101) {
            return e2;
        }
        c2 = r.read();
        if (c2 != 110) {
            return e2;
        }
        c2 = r.read();
        if (c2 != 99) {
            return e2;
        }
        c2 = r.read();
        if (c2 != 111) {
            return e2;
        }
        c2 = r.read();
        if (c2 != 100) {
            return e2;
        }
        c2 = r.read();
        if (c2 != 105) {
            return e2;
        }
        c2 = r.read();
        if (c2 != 110) {
            return e2;
        }
        c2 = r.read();
        if (c2 != 103) {
            return e2;
        }
        c2 = r.read();
        while (XMLUtilities.isXMLSpace((char)c2)) {
            c2 = r.read();
        }
        if (c2 != 61) {
            return e2;
        }
        while (XMLUtilities.isXMLSpace((char)(c2 = r.read()))) {
        }
        if (c2 != 34 && c2 != 39) {
            return e2;
        }
        sc = (char)c2;
        StringBuffer enc = new StringBuffer();
        while ((c2 = r.read()) != -1) {
            if (c2 == sc) {
                return XMLUtilities.encodingToJavaEncoding(enc.toString(), e2);
            }
            enc.append((char)c2);
        }
        return e2;
    }

    public static String encodingToJavaEncoding(String e2, String de) {
        String result = EncodingUtilities.javaEncoding(e2);
        return result == null ? de : result;
    }
}

