/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLongCollection
extends AbstractCollection<Long>
implements LongCollection {
    protected AbstractLongCollection() {
    }

    @Override
    public long[] toArray(long[] a2) {
        return this.toLongArray(a2);
    }

    @Override
    public long[] toLongArray() {
        return this.toLongArray(null);
    }

    @Override
    public long[] toLongArray(long[] a2) {
        if (a2 == null || a2.length < this.size()) {
            a2 = new long[this.size()];
        }
        LongIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public boolean addAll(LongCollection c2) {
        boolean retVal = false;
        LongIterator i2 = c2.iterator();
        int n2 = c2.size();
        while (n2-- != 0) {
            if (!this.add(i2.nextLong())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean containsAll(LongCollection c2) {
        LongIterator i2 = c2.iterator();
        int n2 = c2.size();
        while (n2-- != 0) {
            if (this.contains(i2.nextLong())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(LongCollection c2) {
        boolean retVal = false;
        int n2 = this.size();
        LongIterator i2 = this.iterator();
        while (n2-- != 0) {
            if (c2.contains(i2.nextLong())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(LongCollection c2) {
        boolean retVal = false;
        int n2 = c2.size();
        LongIterator i2 = c2.iterator();
        while (n2-- != 0) {
            if (!this.rem(i2.nextLong())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public Object[] toArray() {
        Object[] a2 = new Object[this.size()];
        ObjectIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        if (a2.length < this.size()) {
            a2 = (Object[])Array.newInstance(a2.getClass().getComponentType(), this.size());
        }
        ObjectIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public boolean addAll(Collection<? extends Long> c2) {
        boolean retVal = false;
        Iterator<? extends Long> i2 = c2.iterator();
        int n2 = c2.size();
        while (n2-- != 0) {
            if (!this.add(i2.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean add(long k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public LongIterator longIterator() {
        return this.iterator();
    }

    @Override
    public abstract LongIterator iterator();

    @Override
    public boolean remove(Object ok) {
        return this.rem((Long)ok);
    }

    @Override
    public boolean add(Long o2) {
        return this.add((long)o2);
    }

    public boolean rem(Object o2) {
        return this.rem((Long)o2);
    }

    @Override
    public boolean contains(Object o2) {
        return this.contains((Long)o2);
    }

    @Override
    public boolean contains(long k2) {
        LongIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (k2 != iterator.nextLong()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(long k2) {
        LongIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (k2 != iterator.nextLong()) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        int n2 = c2.size();
        Iterator<?> i2 = c2.iterator();
        while (n2-- != 0) {
            if (this.contains(i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        boolean retVal = false;
        int n2 = this.size();
        LongIterator i2 = this.iterator();
        while (n2-- != 0) {
            if (c2.contains(i2.next())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        boolean retVal = false;
        int n2 = c2.size();
        Iterator<?> i2 = c2.iterator();
        while (n2-- != 0) {
            if (!this.remove(i2.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        LongIterator i2 = this.iterator();
        int n2 = this.size();
        boolean first = true;
        s.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            long k2 = i2.nextLong();
            s.append(String.valueOf(k2));
        }
        s.append("}");
        return s.toString();
    }
}

