/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public class VetoableChangeMulticaster
implements Serializable {
    protected transient VetoableChangeListener[] listeners = new VetoableChangeListener[0];
    protected final Object source;
    protected HashMap children;

    protected synchronized VetoableChangeMulticaster getChild(String string) {
        return this.children == null ? null : (VetoableChangeMulticaster)this.children.get(string);
    }

    public VetoableChangeMulticaster(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException();
        }
        int n2 = this.listeners.length;
        VetoableChangeListener[] vetoableChangeListenerArray = new VetoableChangeListener[n2 + 1];
        if (n2 > 0) {
            System.arraycopy(this.listeners, 0, vetoableChangeListenerArray, 0, n2);
        }
        vetoableChangeListenerArray[n2] = vetoableChangeListener;
        this.listeners = vetoableChangeListenerArray;
    }

    public synchronized void addVetoableChangeListenerIfAbsent(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException();
        }
        int n2 = this.listeners.length;
        VetoableChangeListener[] vetoableChangeListenerArray = new VetoableChangeListener[n2 + 1];
        for (int i2 = 0; i2 < n2; ++i2) {
            vetoableChangeListenerArray[i2] = this.listeners[i2];
            if (!vetoableChangeListener.equals(this.listeners[i2])) continue;
            return;
        }
        vetoableChangeListenerArray[n2] = vetoableChangeListener;
        this.listeners = vetoableChangeListenerArray;
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        int n2 = this.listeners.length - 1;
        if (n2 < 0 || vetoableChangeListener == null) {
            return;
        }
        VetoableChangeListener[] vetoableChangeListenerArray = new VetoableChangeListener[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (vetoableChangeListener.equals(this.listeners[i2])) {
                for (int i3 = i2 + 1; i3 <= n2; ++i3) {
                    vetoableChangeListenerArray[i3 - 1] = this.listeners[i3];
                }
                this.listeners = vetoableChangeListenerArray;
                return;
            }
            vetoableChangeListenerArray[i2] = this.listeners[i2];
        }
        if (vetoableChangeListener.equals(this.listeners[n2])) {
            this.listeners = vetoableChangeListenerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException();
        }
        VetoableChangeMulticaster vetoableChangeMulticaster = null;
        VetoableChangeMulticaster vetoableChangeMulticaster2 = this;
        synchronized (vetoableChangeMulticaster2) {
            if (this.children == null) {
                this.children = new HashMap();
            } else {
                vetoableChangeMulticaster = (VetoableChangeMulticaster)this.children.get(string);
            }
            if (vetoableChangeMulticaster == null) {
                vetoableChangeMulticaster = new VetoableChangeMulticaster(this.source);
                this.children.put(string, vetoableChangeMulticaster);
            }
        }
        vetoableChangeMulticaster.addVetoableChangeListener(vetoableChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListenerIfAbsent(String string, VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException();
        }
        VetoableChangeMulticaster vetoableChangeMulticaster = null;
        VetoableChangeMulticaster vetoableChangeMulticaster2 = this;
        synchronized (vetoableChangeMulticaster2) {
            if (this.children == null) {
                this.children = new HashMap();
            } else {
                vetoableChangeMulticaster = (VetoableChangeMulticaster)this.children.get(string);
            }
            if (vetoableChangeMulticaster == null) {
                vetoableChangeMulticaster = new VetoableChangeMulticaster(this.source);
                this.children.put(string, vetoableChangeMulticaster);
            }
        }
        vetoableChangeMulticaster.addVetoableChangeListenerIfAbsent(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        VetoableChangeMulticaster vetoableChangeMulticaster = this.getChild(string);
        if (vetoableChangeMulticaster != null) {
            vetoableChangeMulticaster.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void multicast(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        VetoableChangeListener[] vetoableChangeListenerArray;
        VetoableChangeMulticaster vetoableChangeMulticaster = null;
        VetoableChangeMulticaster vetoableChangeMulticaster2 = this;
        synchronized (vetoableChangeMulticaster2) {
            vetoableChangeListenerArray = this.listeners;
            if (this.children != null && propertyChangeEvent.getPropertyName() != null) {
                vetoableChangeMulticaster = (VetoableChangeMulticaster)this.children.get(propertyChangeEvent.getPropertyName());
            }
        }
        int n2 = 0;
        try {
            for (n2 = 0; n2 < vetoableChangeListenerArray.length; ++n2) {
                vetoableChangeListenerArray[n2].vetoableChange(propertyChangeEvent);
            }
            if (vetoableChangeMulticaster != null) {
                vetoableChangeMulticaster.multicast(propertyChangeEvent);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(propertyChangeEvent.getSource(), propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue(), propertyChangeEvent.getOldValue());
            int n3 = n2 < vetoableChangeListenerArray.length ? n2 : vetoableChangeListenerArray.length - 1;
            for (int i2 = 0; i2 <= n3; ++i2) {
                try {
                    vetoableChangeListenerArray[i2].vetoableChange(propertyChangeEvent2);
                    continue;
                }
                catch (PropertyVetoException propertyVetoException2) {
                    // empty catch block
                }
            }
            throw propertyVetoException;
        }
    }

    public void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (object == null || object2 == null || !object.equals(object2)) {
            this.multicast(new PropertyChangeEvent(this.source, string, object, object2));
        }
    }

    public void fireVetoableChange(String string, int n2, int n3) throws PropertyVetoException {
        if (n2 != n3) {
            this.multicast(new PropertyChangeEvent(this.source, string, new Integer(n2), new Integer(n3)));
        }
    }

    public void fireVetoableChange(String string, boolean bl, boolean bl2) throws PropertyVetoException {
        if (bl != bl2) {
            this.multicast(new PropertyChangeEvent(this.source, string, new Boolean(bl), new Boolean(bl2)));
        }
    }

    public void fireVetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        if (object == null || object2 == null || !object.equals(object2)) {
            this.multicast(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners(String string) {
        VetoableChangeMulticaster vetoableChangeMulticaster;
        VetoableChangeMulticaster vetoableChangeMulticaster2 = this;
        synchronized (vetoableChangeMulticaster2) {
            if (this.listeners.length > 0) {
                return true;
            }
            if (string == null || this.children == null) {
                return false;
            }
            vetoableChangeMulticaster = (VetoableChangeMulticaster)this.children.get(string);
            if (vetoableChangeMulticaster == null) {
                return false;
            }
        }
        return vetoableChangeMulticaster.hasListeners(null);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i2 = 0; i2 < this.listeners.length; ++i2) {
            VetoableChangeListener vetoableChangeListener = this.listeners[i2];
            if (!(this.listeners[i2] instanceof Serializable)) continue;
            objectOutputStream.writeObject(this.listeners[i2]);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        this.listeners = new VetoableChangeListener[0];
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            this.addVetoableChangeListener((VetoableChangeListener)object);
        }
    }
}

